/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.resource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.resource.ResourceFactory;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResourceFactoryTrackerData {
    private static final String JNDI_SERVICENAME = "osgi.jndi.service.name";
    private final BundleContext context;
    private ServiceRegistration<?> registration;
    private String[] interfaces;
    static final long serialVersionUID = 7071819092476537634L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ResourceFactoryTrackerData(BundleContext context) {
        this.context = context;
    }

    private String[] getServiceInterfaces(ServiceReference<ResourceFactory> ref) {
        Object createsObjectClass = ref.getProperty("creates.objectClass");
        if (createsObjectClass instanceof String[]) {
            Object createsObjectClassDefault = ref.getProperty("creates.objectClassDefault");
            if (createsObjectClassDefault instanceof String) {
                return new String[]{(String)createsObjectClassDefault};
            }
            if (createsObjectClassDefault instanceof String[]) {
                return (String[])createsObjectClassDefault;
            }
            return (String[])createsObjectClass;
        }
        if (createsObjectClass instanceof String) {
            return new String[]{(String)createsObjectClass};
        }
        return null;
    }

    private Dictionary<String, Object> getServiceProperties(ServiceReference<ResourceFactory> ref) {
        String[] keys = ref.getPropertyKeys();
        Hashtable<String, Object> properties = new Hashtable<String, Object>(keys.length);
        for (String key : keys) {
            if (key.equals("jndiName") || key.equals("creates.objectClass")) continue;
            ((Dictionary)properties).put(key, ref.getProperty(key));
        }
        ((Dictionary)properties).put(ResourceFactory.class.getName(), "true");
        ((Dictionary)properties).put(JNDI_SERVICENAME, ref.getProperty("jndiName"));
        return properties;
    }

    public void register(ServiceReference<ResourceFactory> ref) {
        this.register(ref, this.getServiceInterfaces(ref));
    }

    private void register(final ServiceReference<ResourceFactory> ref, String[] interfaces) {
        if (interfaces != null) {
            ServiceFactory<Object> factory = new ServiceFactory<Object>(){
                static final long serialVersionUID = -5395261454852493419L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                public Object getService(Bundle bundle, ServiceRegistration<Object> registration) {
                    BundleContext ctx = bundle.getBundleContext();
                    if (ctx == null) {
                        return null;
                    }
                    ResourceFactory factory = (ResourceFactory)ctx.getService(ref);
                    try {
                        return factory.createResource(null);
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.resource.internal.ResourceFactoryTrackerData$1", (String)"122", (Object)this, (Object[])new Object[]{bundle, registration});
                        throw new RuntimeException((Throwable)e);
                    }
                }

                @FFDCIgnore(value={IllegalStateException.class})
                public void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {
                    try {
                        BundleContext ctx = bundle.getBundleContext();
                        if (ctx != null) {
                            ResourceFactoryTrackerData.this.context.ungetService(ref);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            this.registration = this.context.registerService(interfaces, (Object)factory, this.getServiceProperties(ref));
            this.interfaces = interfaces;
        }
    }

    public void modifed(ServiceReference<ResourceFactory> ref) {
        Object[] newInterfaces = this.getServiceInterfaces(ref);
        if (!Arrays.equals(this.interfaces, newInterfaces)) {
            this.unregister();
            this.register(ref, (String[])newInterfaces);
        } else {
            this.registration.setProperties(this.getServiceProperties(ref));
        }
    }

    public void unregister() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
            this.interfaces = null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ResourceFactoryTrackerData.class);
    }
}

