/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchIllegalJobStatusTransitionException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV2;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV2;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.persistence.jpa.RemotableSplitFlowEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotableSplitFlowKey;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceKey;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceKey;
import com.ibm.jbatch.container.services.IJPAQueryHelper;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.AbstractPersistenceManager;
import com.ibm.jbatch.container.util.WSStepThreadExecutionAggregateImpl;
import com.ibm.jbatch.container.ws.BatchLocationService;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.RemotablePartitionState;
import com.ibm.jbatch.container.ws.WSPartitionStepThreadExecution;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.container.ws.WSTopLevelStepExecution;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(service={IPersistenceManagerService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.ranking:Integer=10", "persistenceType=In-Memory"})
public class MemoryPersistenceManagerImpl
extends AbstractPersistenceManager
implements IPersistenceManagerService {
    private static final Logger logger = Logger.getLogger(MemoryPersistenceManagerImpl.class.getName(), "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    private BatchLocationService batchLocationService;
    private static final Data GLOBAL_DATA = new Data();
    private Data data;
    static final long serialVersionUID = -8029644782822440649L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MemoryPersistenceManagerImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "activate", new Object[]{context, config});
        }
        logger.log(Level.INFO, "persistence.service.status", new Object[]{"In-Memory", "activated"});
        this.data = GLOBAL_DATA;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "deactivate", new Object[0]);
        }
        logger.log(Level.INFO, "persistence.service.status", new Object[]{"In-Memory", "deactivated"});
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setBatchLocationService(BatchLocationService batchLocationService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "setBatchLocationService", new Object[]{batchLocationService});
        }
        this.batchLocationService = batchLocationService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "setBatchLocationService");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "init", new Object[]{batchConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "init");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "shutdown", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "shutdown");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity createJobInstance(String appName, String jobXMLName, String submitter, Date createTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createJobInstance", new Object[]{appName, jobXMLName, submitter, createTime});
        }
        JobInstanceEntity jobInstanceEntity = this.createJobInstance(appName, jobXMLName, null, submitter, createTime);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity createJobInstance(String appName, String jobXMLName, String jsl, String submitter, Date createTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createJobInstance", new Object[]{appName, jobXMLName, jsl, submitter, createTime});
        }
        JobInstanceEntityV2 jobInstance = new JobInstanceEntityV2(this.data.jobInstanceIdGenerator.getAndIncrement());
        jobInstance.setAmcName(appName);
        jobInstance.setJobXmlName(jobXMLName);
        jobInstance.setJobXml(jsl);
        jobInstance.setSubmitter(submitter);
        jobInstance.setCreateTime(createTime);
        ((JobInstanceEntity)jobInstance).setLastUpdatedTime(createTime);
        jobInstance.setInstanceState(InstanceState.SUBMITTED);
        jobInstance.setBatchStatus(BatchStatus.STARTING);
        this.data.jobInstanceData.put(jobInstance.getInstanceId(), jobInstance);
        JobInstanceEntityV2 jobInstanceEntityV2 = jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntityV2 = jobInstanceEntityV2;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createJobInstance", jobInstanceEntityV2);
        }
        return jobInstanceEntityV2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity getJobInstance(long jobInstanceId) throws NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstance", new Object[]{jobInstanceId});
        }
        JobInstanceEntity jobInstance = this.data.jobInstanceData.get(jobInstanceId);
        if (jobInstance == null) {
            throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
        }
        JobInstanceEntity jobInstanceEntity = jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity getJobInstanceFromExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstanceFromExecutionId", new Object[]{jobExecutionId});
        }
        JobExecutionEntity jobExecution = this.data.executionInstanceData.get(jobExecutionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
        }
        JobInstanceEntity jobInstanceEntity = jobExecution.getJobInstance();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstanceFromExecutionId", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(String jobName, int start, int count) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", new Object[]{jobName, start, count});
        }
        List<JobInstanceEntity> list = this.getJobInstances(jobName, null, start, count);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(String jobName, String submitter, int start, int count) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", new Object[]{jobName, submitter, start, count});
        }
        LinkedList<JobInstanceEntity> out = new LinkedList<JobInstanceEntity>();
        for (JobInstanceEntity jobInstance : this.data.jobInstanceData.values()) {
            boolean hasTag;
            if (jobInstance.getJobName() == null || !jobInstance.getJobName().equals(jobName)) continue;
            boolean bl = hasTag = submitter != null;
            if (hasTag && !submitter.equals(jobInstance.getSubmitter())) continue;
            out.add(jobInstance);
        }
        Collections.sort(out, ReverseJobInstanceCreationDateComparator.INSTANCE);
        if (start + count > out.size()) {
            List<JobInstanceEntity> list = out.subList(start, out.size());
            if (logger != null && logger.isLoggable(Level.FINER)) {
                list = list;
                logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", list);
            }
            return list;
        }
        List<JobInstanceEntity> list = out.subList(start, start + count);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(int page, int pageSize) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", new Object[]{page, pageSize});
        }
        List<JobInstanceEntity> list = this.getJobInstances(page, pageSize, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(int page, int pageSize, String user) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", new Object[]{page, pageSize, user});
        }
        ArrayList<JobInstanceEntity> jobInstancesMatched = new ArrayList<JobInstanceEntity>();
        ArrayList<JobInstanceEntity> jobInstances = new ArrayList<JobInstanceEntity>(this.data.jobInstanceData.values());
        Collections.sort(jobInstances, ReverseJobInstanceCreationDateComparator.INSTANCE);
        for (JobInstanceEntity jobInstance : jobInstances) {
            if (user != null) {
                if (!user.equals(jobInstance.getSubmitter())) continue;
                jobInstancesMatched.add(jobInstance);
                continue;
            }
            jobInstancesMatched.add(jobInstance);
        }
        List<JobInstanceEntity> list = this.readJobInstancesPage(jobInstancesMatched, page, pageSize);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getJobNamesSet() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobNamesSet", new Object[0]);
        }
        Set<String> set = this.getJobNamesSet(null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobNamesSet", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getJobNamesSet(String submitter) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobNamesSet", new Object[]{submitter});
        }
        HashSet<String> out = new HashSet<String>();
        boolean hasTag = submitter != null;
        for (JobInstanceEntity jobInstance : this.data.jobInstanceData.values()) {
            if (hasTag && !submitter.equals(jobInstance.getSubmitter()) || jobInstance.getJobName() == null) continue;
            out.add(jobInstance.getJobName());
        }
        HashSet<String> hashSet = out;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobNamesSet", hashSet);
        }
        return hashSet;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceCount(String jobName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstanceCount", new Object[]{jobName});
        }
        int n = this.getJobInstanceCount(jobName, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstanceCount", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceCount(String jobName, String submitter) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstanceCount", new Object[]{jobName, submitter});
        }
        boolean hasTag = submitter != null;
        int i = 0;
        for (JobInstanceEntity jobInstance : this.data.jobInstanceData.values()) {
            if (jobInstance.getJobName() == null || !jobInstance.getJobName().equals(jobName) || hasTag && !submitter.equals(jobInstance.getSubmitter())) continue;
            ++i;
        }
        int n = i;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstanceCount", n);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithInstanceState(long jobInstanceId, InstanceState state, Date lastUpdated) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithInstanceState", new Object[]{jobInstanceId, state, lastUpdated});
        }
        JobInstanceEntity jobInstance = this.data.jobInstanceData.get(jobInstanceId);
        try {
            this.verifyStateTransitionIsValid(jobInstance, state);
        }
        catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
            void e;
            FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", (String)"312", (Object)this, (Object[])new Object[]{jobInstanceId, state, lastUpdated});
            throw new PersistenceException((Throwable)e);
        }
        jobInstance.setInstanceState(state);
        jobInstance.setLastUpdatedTime(lastUpdated);
        JobInstanceEntity jobInstanceEntity = jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithInstanceState", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithInstanceStateUponRestart(long jobInstanceId, InstanceState state, Date lastUpdated) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithInstanceStateUponRestart", new Object[]{jobInstanceId, state, lastUpdated});
        }
        JobInstanceEntity jobInstance = this.data.jobInstanceData.get(jobInstanceId);
        if (jobInstance.getInstanceState() == InstanceState.STOPPED || jobInstance.getInstanceState() == InstanceState.FAILED) {
            try {
                this.verifyStateTransitionIsValid(jobInstance, state);
            }
            catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                void e;
                FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", (String)"329", (Object)this, (Object[])new Object[]{jobInstanceId, state, lastUpdated});
                throw new PersistenceException((Throwable)e);
            }
        } else {
            String msg = "The job instance " + jobInstanceId + " cannot be restarted because it is still in a non-final state.";
            throw new JobRestartException(msg);
        }
        jobInstance.setInstanceState(state);
        jobInstance.setBatchStatus(BatchStatus.STARTING);
        jobInstance.setLastUpdatedTime(lastUpdated);
        JobInstanceEntity jobInstanceEntity = jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithInstanceStateUponRestart", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceNullOutRestartOn(long jobInstanceId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceNullOutRestartOn", new Object[]{jobInstanceId});
        }
        JobInstanceEntity jobInstance = this.data.jobInstanceData.get(jobInstanceId);
        jobInstance.setRestartOn(null);
        JobInstanceEntity jobInstanceEntity = jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceNullOutRestartOn", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithRestartOn(long jobInstanceId, String restartOn) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithRestartOn", new Object[]{jobInstanceId, restartOn});
        }
        JobInstanceEntity jobInstance = this.data.jobInstanceData.get(jobInstanceId);
        jobInstance.setRestartOn(restartOn);
        JobInstanceEntity jobInstanceEntity = jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithRestartOn", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithJobNameAndJSL(long instanceId, String jobName, String jobXml) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithJobNameAndJSL", new Object[]{instanceId, jobName, jobXml});
        }
        JobInstanceEntity jobInstance = this.data.jobInstanceData.get(instanceId);
        jobInstance.setJobName(jobName);
        jobInstance.setJobXml(jobXml);
        JobInstanceEntity jobInstanceEntity = jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithJobNameAndJSL", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStarted(long jobExecutionId, Date startedTime) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStarted", new Object[]{jobExecutionId, startedTime});
        }
        JobExecutionEntity exec = this.getJobExecution(jobExecutionId);
        try {
            this.verifyStatusTransitionIsValid(exec, BatchStatus.STARTED);
            this.verifyStateTransitionIsValid(exec.getJobInstance(), InstanceState.DISPATCHED);
        }
        catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
            void e;
            FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", (String)"372", (Object)this, (Object[])new Object[]{jobExecutionId, startedTime});
            throw new PersistenceException((Throwable)e);
        }
        exec.setBatchStatus(BatchStatus.STARTED);
        exec.getJobInstance().setInstanceState(InstanceState.DISPATCHED);
        exec.getJobInstance().setBatchStatus(BatchStatus.STARTED);
        exec.getJobInstance().setLastUpdatedTime(startedTime);
        exec.setStartTime(startedTime);
        exec.setLastUpdatedTime(startedTime);
        JobExecutionEntity jobExecutionEntity = exec;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStarted", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStop(long jobExecutionId, Date lastUpdatedTime) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStop", new Object[]{jobExecutionId, lastUpdatedTime});
        }
        JobExecutionEntity exec = this.getJobExecution(jobExecutionId);
        if (exec.getServerId().equals("")) {
            try {
                this.verifyStatusTransitionIsValid(exec, BatchStatus.STOPPED);
            }
            catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                void e;
                FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", (String)"392", (Object)this, (Object[])new Object[]{jobExecutionId, lastUpdatedTime});
                throw new PersistenceException((Throwable)e);
            }
        } else {
            String msg = "No job execution found for id = " + jobExecutionId + " and serverId = \"\"";
            throw new NoSuchJobExecutionException(msg);
        }
        exec.setBatchStatus(BatchStatus.STOPPED);
        exec.getJobInstance().setInstanceState(InstanceState.STOPPED);
        exec.getJobInstance().setBatchStatus(BatchStatus.STOPPED);
        exec.getJobInstance().setLastUpdatedTime(lastUpdatedTime);
        exec.setLastUpdatedTime(lastUpdatedTime);
        JobExecutionEntity jobExecutionEntity = exec;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStop", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStatusChange(long jobExecutionId, BatchStatus newBatchStatus, Date updateTime) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStatusChange", new Object[]{jobExecutionId, newBatchStatus, updateTime});
        }
        JobExecutionEntity exec = this.getJobExecution(jobExecutionId);
        try {
            this.verifyStatusTransitionIsValid(exec, newBatchStatus);
        }
        catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
            void e;
            FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", (String)"414", (Object)this, (Object[])new Object[]{jobExecutionId, newBatchStatus, updateTime});
            throw new PersistenceException((Throwable)e);
        }
        exec.setBatchStatus(newBatchStatus);
        exec.getJobInstance().setBatchStatus(newBatchStatus);
        exec.getJobInstance().setLastUpdatedTime(updateTime);
        exec.setLastUpdatedTime(updateTime);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JobExecution : " + Long.toString(jobExecutionId) + " batchStatus updated : " + newBatchStatus.toString());
        }
        JobExecutionEntity jobExecutionEntity = exec;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStatusChange", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnEnd(long jobExecutionId, BatchStatus finalBatchStatus, String finalExitStatus, Date endTime) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionAndInstanceOnEnd", new Object[]{jobExecutionId, finalBatchStatus, finalExitStatus, endTime});
        }
        JobExecutionEntity exec = this.getJobExecution(jobExecutionId);
        try {
            this.verifyStatusTransitionIsValid(exec, finalBatchStatus);
        }
        catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
            void e;
            FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", (String)"437", (Object)this, (Object[])new Object[]{jobExecutionId, finalBatchStatus, finalExitStatus, endTime});
            throw new PersistenceException((Throwable)e);
        }
        exec.setBatchStatus(finalBatchStatus);
        exec.getJobInstance().setBatchStatus(finalBatchStatus);
        exec.setExitStatus(finalExitStatus);
        exec.getJobInstance().setExitStatus(finalExitStatus);
        exec.getJobInstance().setLastUpdatedTime(endTime);
        if (FINAL_STATUS_SET.contains(finalBatchStatus)) {
            InstanceState newInstanceState = InstanceState.valueOf(finalBatchStatus.toString());
            exec.getJobInstance().setInstanceState(newInstanceState);
        }
        exec.setLastUpdatedTime(endTime);
        exec.setEndTime(endTime);
        JobExecutionEntity jobExecutionEntity = exec;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionAndInstanceOnEnd", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity createJobExecution(long jobInstanceId, Properties jobParameters, Date createTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createJobExecution", new Object[]{jobInstanceId, jobParameters, createTime});
        }
        JobExecutionEntityV2 execution = new JobExecutionEntityV2(this.data.executionInstanceIdGenerator.getAndIncrement());
        execution.setCreateTime(createTime);
        execution.setLastUpdatedTime(createTime);
        execution.setBatchStatus(BatchStatus.STARTING);
        ((JobExecutionEntity)execution).setJobParameters(jobParameters);
        execution.setServerId(this.batchLocationService.getServerId());
        execution.setRestUrl(this.batchLocationService.getBatchRestUrl());
        JobInstanceEntity jobInstance = this.getJobInstance(jobInstanceId);
        int currentNumExecutionsPreviously = jobInstance.getNumberOfExecutions();
        execution.setExecutionNumberForThisInstance(currentNumExecutionsPreviously);
        jobInstance.setNumberOfExecutions(currentNumExecutionsPreviously + 1);
        this.data.executionInstanceData.put(execution.getExecutionId(), execution);
        jobInstance.getJobExecutions().add(0, execution);
        execution.setJobInstance(jobInstance);
        JobExecutionEntityV2 jobExecutionEntityV2 = execution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntityV2 = jobExecutionEntityV2;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createJobExecution", jobExecutionEntityV2);
        }
        return jobExecutionEntityV2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity getJobExecution(long jobExecutionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecution", new Object[]{jobExecutionId});
        }
        JobExecutionEntity jobExecution = this.data.executionInstanceData.get(jobExecutionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
        }
        JobExecutionEntity jobExecutionEntity = jobExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecution", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobExecutionEntity> getJobExecutionsFromJobInstanceId(long jobInstanceId) throws NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecutionsFromJobInstanceId", new Object[]{jobInstanceId});
        }
        JobInstanceEntity instance = this.getJobInstance(jobInstanceId);
        ArrayList<JobExecutionEntity> executions = new ArrayList<JobExecutionEntity>(instance.getJobExecutions());
        Collections.sort(executions, ReverseJobExecutionSequenceForOneInstanceComparator.INSTANCE);
        ArrayList<JobExecutionEntity> arrayList = executions;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecutionsFromJobInstanceId", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getJobExecutionsRunning(String jobName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecutionsRunning", new Object[]{jobName});
        }
        ArrayList<Long> out = new ArrayList<Long>();
        ArrayList<JobExecutionEntity> entities = new ArrayList<JobExecutionEntity>();
        for (JobInstanceEntity jobInstance : this.data.jobInstanceData.values()) {
            if (jobInstance.getJobName() == null || !jobInstance.getJobName().equals(jobName)) continue;
            for (JobExecutionEntity exec : jobInstance.getJobExecutions()) {
                if (!RUNNING_STATUSES.contains(exec.getBatchStatus())) continue;
                entities.add(exec);
            }
        }
        Collections.sort(entities, ReverseJobExecutionCreationDateComparator.INSTANCE);
        for (JobExecutionEntity e : entities) {
            out.add(e.getExecutionId());
        }
        ArrayList<Long> arrayList = out;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecutionsRunning", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity getJobExecutionFromJobExecNum(long jobInstanceId, int jobExecNum) throws NoSuchJobInstanceException, IllegalArgumentException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecutionFromJobExecNum", new Object[]{jobInstanceId, jobExecNum});
        }
        JobInstanceEntity instance = this.getJobInstance(jobInstanceId);
        ArrayList<JobExecutionEntity> executions = new ArrayList<JobExecutionEntity>(instance.getJobExecutions());
        for (JobExecutionEntity jobExecution : executions) {
            if (jobExecution.getExecutionNumberForThisInstance() != jobExecNum) continue;
            JobExecutionEntity jobExecutionEntity = jobExecution;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                jobExecutionEntity = jobExecutionEntity;
                logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecutionFromJobExecNum", jobExecutionEntity);
            }
            return jobExecutionEntity;
        }
        throw new IllegalArgumentException("Didn't find any job execution entries at job instance id: " + jobInstanceId + ", job execution sequence number: " + jobExecNum);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity updateJobExecutionLogDir(long jobExecutionId, String logDirPath) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionLogDir", new Object[]{jobExecutionId, logDirPath});
        }
        JobExecutionEntity exec = this.getJobExecution(jobExecutionId);
        exec.setLogpath(logDirPath);
        JobExecutionEntity jobExecutionEntity = exec;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionLogDir", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity updateJobExecutionServerIdAndRestUrl(long jobExecutionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionServerIdAndRestUrl", new Object[]{jobExecutionId});
        }
        JobExecutionEntity exec = this.getJobExecution(jobExecutionId);
        if (exec.getBatchStatus() != BatchStatus.STARTING) {
            String msg = "No job execution found for id = " + jobExecutionId + " and status = STARTING";
            throw new NoSuchJobExecutionException(msg);
        }
        exec.setServerId(this.batchLocationService.getServerId());
        exec.setRestUrl(this.batchLocationService.getBatchRestUrl());
        JobExecutionEntity jobExecutionEntity = exec;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobExecutionServerIdAndRestUrl", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity createTopLevelStepExecutionAndNewThreadInstance(long jobExecutionId, StepThreadInstanceKey instanceKey, boolean isPartitioned) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createTopLevelStepExecutionAndNewThreadInstance", new Object[]{jobExecutionId, instanceKey, isPartitioned});
        }
        JobInstanceEntity jobInstance = this.getJobInstance(instanceKey.getJobInstance());
        JobExecutionEntity jobExecution = this.getJobExecution(jobExecutionId);
        TopLevelStepInstanceEntity stepInstance = new TopLevelStepInstanceEntity(jobInstance, instanceKey.getStepName(), isPartitioned);
        long newStepExecutionId = this.data.stepExecutionIdGenerator.getAndIncrement();
        TopLevelStepExecutionEntity stepExecution = new TopLevelStepExecutionEntity(newStepExecutionId, jobExecution, instanceKey.getStepName(), isPartitioned);
        jobInstance.getStepThreadInstances().add(stepInstance);
        stepInstance.setLatestStepThreadExecution(stepExecution);
        jobExecution.getStepThreadExecutions().add(stepExecution);
        this.data.stepExecutionInstanceData.put(newStepExecutionId, stepExecution);
        this.data.stepThreadInstanceData.put(instanceKey, stepInstance);
        TopLevelStepExecutionEntity topLevelStepExecutionEntity = stepExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createTopLevelStepExecutionAndNewThreadInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity createPartitionStepExecutionAndNewThreadInstance(long jobExecutionId, StepThreadInstanceKey instanceKey, boolean isRemoteDispatch) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createPartitionStepExecutionAndNewThreadInstance", new Object[]{jobExecutionId, instanceKey, isRemoteDispatch});
        }
        JobInstanceEntity jobInstance = this.getJobInstance(instanceKey.getJobInstance());
        JobExecutionEntity jobExecution = this.getJobExecution(jobExecutionId);
        TopLevelStepExecutionEntity topLevelStepExecution = this.getStepExecutionTopLevelFromJobExecutionIdAndStepName(jobExecutionId, instanceKey.getStepName());
        StepThreadInstanceEntity stepInstance = new StepThreadInstanceEntity(jobInstance, instanceKey.getStepName(), instanceKey.getPartitionNumber());
        long newStepExecutionId = this.data.stepExecutionIdGenerator.getAndIncrement();
        StepThreadExecutionEntity stepExecution = new StepThreadExecutionEntity(newStepExecutionId, jobExecution, instanceKey.getStepName(), instanceKey.getPartitionNumber());
        jobInstance.getStepThreadInstances().add(stepInstance);
        stepInstance.setLatestStepThreadExecution(stepExecution);
        jobExecution.getStepThreadExecutions().add(stepExecution);
        stepExecution.setTopLevelStepExecution(topLevelStepExecution);
        topLevelStepExecution.getTopLevelAndPartitionStepExecutions().add(stepExecution);
        this.data.stepExecutionInstanceData.put(newStepExecutionId, stepExecution);
        this.data.stepThreadInstanceData.put(instanceKey, stepInstance);
        StepThreadExecutionEntity stepThreadExecutionEntity = stepExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createPartitionStepExecutionAndNewThreadInstance", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity createTopLevelStepExecutionOnRestartFromPreviousStepInstance(long jobExecutionId, TopLevelStepInstanceEntity stepInstance) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartFromPreviousStepInstance", new Object[]{jobExecutionId, stepInstance});
        }
        JobExecutionEntity newJobExecution = this.getJobExecution(jobExecutionId);
        StepThreadExecutionEntity lastStepExecution = stepInstance.getLatestStepThreadExecution();
        long newStepExecutionId = this.data.stepExecutionIdGenerator.getAndIncrement();
        TopLevelStepExecutionEntity newStepExecution = new TopLevelStepExecutionEntity(newStepExecutionId, newJobExecution, stepInstance.getStepName(), stepInstance.isPartitionedStep());
        newStepExecution.setPersistentUserDataBytes(lastStepExecution.getPersistentUserDataBytes());
        stepInstance.incrementStartCount();
        stepInstance.setLatestStepThreadExecution(newStepExecution);
        newJobExecution.getStepThreadExecutions().add(newStepExecution);
        this.data.stepExecutionInstanceData.put(newStepExecutionId, newStepExecution);
        TopLevelStepExecutionEntity topLevelStepExecutionEntity = newStepExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartFromPreviousStepInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity createPartitionStepExecutionOnRestartFromPreviousStepInstance(long jobExecutionId, StepThreadInstanceEntity stepThreadInstance, boolean isRemoteDispatch) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createPartitionStepExecutionOnRestartFromPreviousStepInstance", new Object[]{jobExecutionId, stepThreadInstance, isRemoteDispatch});
        }
        JobExecutionEntity newJobExecution = this.getJobExecution(jobExecutionId);
        StepThreadExecutionEntity lastStepExecution = stepThreadInstance.getLatestStepThreadExecution();
        TopLevelStepExecutionEntity topLevelStepExecution = this.getStepExecutionTopLevelFromJobExecutionIdAndStepName(jobExecutionId, stepThreadInstance.getStepName());
        long newStepExecutionId = this.data.stepExecutionIdGenerator.getAndIncrement();
        StepThreadExecutionEntity newStepExecution = new StepThreadExecutionEntity(newStepExecutionId, newJobExecution, stepThreadInstance.getStepName(), stepThreadInstance.getPartitionNumber());
        newStepExecution.setPersistentUserDataBytes(lastStepExecution.getPersistentUserDataBytes());
        stepThreadInstance.setLatestStepThreadExecution(newStepExecution);
        newJobExecution.getStepThreadExecutions().add(newStepExecution);
        newStepExecution.setTopLevelStepExecution(topLevelStepExecution);
        topLevelStepExecution.getTopLevelAndPartitionStepExecutions().add(newStepExecution);
        this.data.stepExecutionInstanceData.put(newStepExecutionId, newStepExecution);
        StepThreadExecutionEntity stepThreadExecutionEntity = newStepExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createPartitionStepExecutionOnRestartFromPreviousStepInstance", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity createTopLevelStepExecutionOnRestartAndCleanStepInstance(long jobExecutionId, TopLevelStepInstanceEntity stepInstance) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartAndCleanStepInstance", new Object[]{jobExecutionId, stepInstance});
        }
        JobExecutionEntity newJobExecution = this.getJobExecution(jobExecutionId);
        long newStepExecutionId = this.data.stepExecutionIdGenerator.getAndIncrement();
        TopLevelStepExecutionEntity newStepExecution = new TopLevelStepExecutionEntity(newStepExecutionId, newJobExecution, stepInstance.getStepName(), stepInstance.isPartitionedStep());
        stepInstance.incrementStartCount();
        stepInstance.deleteCheckpointData();
        stepInstance.setLatestStepThreadExecution(newStepExecution);
        newJobExecution.getStepThreadExecutions().add(newStepExecution);
        this.data.stepExecutionInstanceData.put(newStepExecutionId, newStepExecution);
        TopLevelStepExecutionEntity topLevelStepExecutionEntity = newStepExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartAndCleanStepInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadInstanceEntity getStepThreadInstance(StepThreadInstanceKey stepInstanceKey) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepThreadInstance", new Object[]{stepInstanceKey});
        }
        StepThreadInstanceEntity stepThreadInstanceEntity = this.data.stepThreadInstanceData.get(stepInstanceKey);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadInstanceEntity = stepThreadInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepThreadInstance", stepThreadInstanceEntity);
        }
        return stepThreadInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Integer> getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions(StepThreadInstanceKey topLevelKey) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions", new Object[]{topLevelKey});
        }
        ArrayList<Integer> out = new ArrayList<Integer>();
        long compareInstanceId = topLevelKey.getJobInstance();
        for (StepThreadInstanceEntity stepThreadInstance : this.data.stepThreadInstanceData.values()) {
            if (stepThreadInstance.getJobInstance().getInstanceId() != compareInstanceId || !stepThreadInstance.getStepName().equals(topLevelKey.getStepName()) || stepThreadInstance instanceof TopLevelStepInstanceEntity || stepThreadInstance.getLatestStepThreadExecution().getBatchStatus() != BatchStatus.COMPLETED) continue;
            out.add(stepThreadInstance.getPartitionNumber());
        }
        Collections.sort(out);
        ArrayList<Integer> arrayList = out;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadInstanceEntity updateStepThreadInstanceWithCheckpointData(StepThreadInstanceEntity stepThreadInstance) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateStepThreadInstanceWithCheckpointData", new Object[]{stepThreadInstance});
        }
        StepThreadInstanceEntity stepThreadInstanceEntity = stepThreadInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadInstanceEntity = stepThreadInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateStepThreadInstanceWithCheckpointData", stepThreadInstanceEntity);
        }
        return stepThreadInstanceEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepInstanceEntity updateStepThreadInstanceWithPartitionPlanSize(StepThreadInstanceKey instanceKey, int numCurrentPartitions) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateStepThreadInstanceWithPartitionPlanSize", new Object[]{instanceKey, numCurrentPartitions});
        }
        TopLevelStepInstanceEntity stepInstance = null;
        try {
            stepInstance = (TopLevelStepInstanceEntity)this.data.stepThreadInstanceData.get(instanceKey);
        }
        catch (ClassCastException classCastException) {
            void e;
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", (String)"780", (Object)this, (Object[])new Object[]{instanceKey, numCurrentPartitions});
            throw new IllegalArgumentException("Expected top-level step instance, but found another type.", (Throwable)e);
        }
        stepInstance.setPartitionPlanSize(numCurrentPartitions);
        TopLevelStepInstanceEntity topLevelStepInstanceEntity = stepInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelStepInstanceEntity = topLevelStepInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateStepThreadInstanceWithPartitionPlanSize", topLevelStepInstanceEntity);
        }
        return topLevelStepInstanceEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private TopLevelStepExecutionEntity getStepExecutionTopLevelFromJobExecutionIdAndStepName(long jobExecutionId, String stepName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionTopLevelFromJobExecutionIdAndStepName", new Object[]{jobExecutionId, stepName});
        }
        JobExecutionEntity jobExecution = this.data.executionInstanceData.get(jobExecutionId);
        for (StepThreadExecutionEntity stepExec : new ArrayList<StepThreadExecutionEntity>(jobExecution.getStepThreadExecutions())) {
            if (!stepExec.getStepName().equals(stepName) || !(stepExec instanceof TopLevelStepExecutionEntity)) continue;
            TopLevelStepExecutionEntity topLevelStepExecutionEntity = (TopLevelStepExecutionEntity)stepExec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                topLevelStepExecutionEntity = topLevelStepExecutionEntity;
                logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionTopLevelFromJobExecutionIdAndStepName", topLevelStepExecutionEntity);
            }
            return topLevelStepExecutionEntity;
        }
        throw new IllegalStateException("Couldn't find top-level step execution for jobExecution = " + jobExecutionId + ", and stepName = " + stepName);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void deleteStepThreadInstanceOfRelatedPartitions(TopLevelStepInstanceKey stepInstanceKey) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "deleteStepThreadInstanceOfRelatedPartitions", new Object[]{stepInstanceKey});
        }
        long compareInstanceId = stepInstanceKey.getJobInstance();
        for (StepThreadInstanceEntity stepThreadInstance : this.data.stepThreadInstanceData.values()) {
            if (stepThreadInstance.getJobInstance().getInstanceId() != compareInstanceId || !stepThreadInstance.getStepName().equals(stepInstanceKey.getStepName()) || stepThreadInstance instanceof TopLevelStepInstanceEntity) continue;
            StepThreadInstanceKey removalKey = new StepThreadInstanceKey(stepThreadInstance);
            this.data.stepThreadInstanceData.remove(removalKey);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "deleteStepThreadInstanceOfRelatedPartitions");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity getStepThreadExecution(long stepExecutionId) throws IllegalArgumentException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepThreadExecution", new Object[]{stepExecutionId});
        }
        StepThreadExecutionEntity retVal = this.data.stepExecutionInstanceData.get(stepExecutionId);
        if (retVal == null) {
            throw new IllegalArgumentException("StepThreadExecEntity with id =" + stepExecutionId + " should be persisted at this point, but didn't find it.");
        }
        StepThreadExecutionEntity stepThreadExecutionEntity = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepThreadExecution", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<StepExecution> getStepExecutionsTopLevelFromJobExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionsTopLevelFromJobExecutionId", new Object[]{jobExecutionId});
        }
        ArrayList<StepExecution> out = new ArrayList<StepExecution>();
        for (StepThreadExecutionEntity stepThreadExecution : this.data.stepExecutionInstanceData.values()) {
            if (stepThreadExecution.getJobExecution().getExecutionId() != jobExecutionId || !(stepThreadExecution instanceof TopLevelStepExecutionEntity)) continue;
            out.add(stepThreadExecution);
        }
        if (out.isEmpty()) {
            this.getJobExecution(jobExecutionId);
        }
        Collections.sort(out, StepExecutionStartDateComparator.INSTANCE);
        ArrayList<StepExecution> arrayList = out;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionsTopLevelFromJobExecutionId", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecutionId(long jobExecutionId, String stepName) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionId", new Object[]{jobExecutionId, stepName});
        }
        WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
        ArrayList<StepThreadExecutionEntity> partitionExecs = new ArrayList<StepThreadExecutionEntity>();
        boolean foundTopLevelStepExec = false;
        for (StepThreadExecutionEntity stepThreadExecution : this.data.stepExecutionInstanceData.values()) {
            if (stepThreadExecution.getJobExecution().getExecutionId() != jobExecutionId || !stepThreadExecution.getStepName().equals(stepName)) continue;
            if (stepThreadExecution instanceof TopLevelStepExecutionEntity) {
                if (foundTopLevelStepExec) {
                    throw new IllegalArgumentException("Found two top-level step thread execs at job execution id: " + jobExecutionId + ", and stepName: " + stepName);
                }
                retVal.setTopLevelStepExecution((WSTopLevelStepExecution)((Object)stepThreadExecution));
                foundTopLevelStepExec = true;
                continue;
            }
            partitionExecs.add(stepThreadExecution);
        }
        if (!foundTopLevelStepExec) {
            throw new IllegalArgumentException("Didn't find top-level step thread exec at job execution id: " + jobExecutionId + ", and stepName: " + stepName);
        }
        Collections.sort(partitionExecs, StepThreadExecutionPartitionNumberComparator.INSTANCE);
        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(partitionExecs));
        WSStepThreadExecutionAggregateImpl wSStepThreadExecutionAggregateImpl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregateImpl = wSStepThreadExecutionAggregateImpl;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionId", wSStepThreadExecutionAggregateImpl);
        }
        return wSStepThreadExecutionAggregateImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregate(long topLevelStepExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionAggregate", new Object[]{topLevelStepExecutionId});
        }
        WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
        ArrayList<StepThreadExecutionEntity> partitionExecs = new ArrayList<StepThreadExecutionEntity>();
        boolean foundTopLevelStepExec = false;
        for (StepThreadExecutionEntity stepThreadExecution : this.data.stepExecutionInstanceData.values()) {
            if (stepThreadExecution.getTopLevelStepExecution().getStepExecutionId() != topLevelStepExecutionId) continue;
            if (stepThreadExecution instanceof TopLevelStepExecutionEntity) {
                retVal.setTopLevelStepExecution((WSTopLevelStepExecution)((Object)stepThreadExecution));
                foundTopLevelStepExec = true;
                continue;
            }
            partitionExecs.add(stepThreadExecution);
        }
        if (!foundTopLevelStepExec) {
            throw new IllegalArgumentException("Didn't find top-level step thread exec at id: " + topLevelStepExecutionId);
        }
        Collections.sort(partitionExecs, StepThreadExecutionPartitionNumberComparator.INSTANCE);
        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(partitionExecs));
        WSStepThreadExecutionAggregateImpl wSStepThreadExecutionAggregateImpl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregateImpl = wSStepThreadExecutionAggregateImpl;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionAggregate", wSStepThreadExecutionAggregateImpl);
        }
        return wSStepThreadExecutionAggregateImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecutionNumberAndStepName(long jobInstanceId, int jobExecNum, String stepName) throws NoSuchJobInstanceException, IllegalArgumentException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionNumberAndStepName", new Object[]{jobInstanceId, jobExecNum, stepName});
        }
        WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
        ArrayList<StepThreadExecutionEntity> partitionExecs = new ArrayList<StepThreadExecutionEntity>();
        boolean foundTopLevelStepExec = false;
        for (StepThreadExecutionEntity stepThreadExecution : this.data.stepExecutionInstanceData.values()) {
            if (stepThreadExecution.getJobExecution().getJobInstance().getInstanceId() != jobInstanceId || !stepThreadExecution.getStepName().equals(stepName) || stepThreadExecution.getJobExecution().getExecutionNumberForThisInstance() != jobExecNum) continue;
            if (stepThreadExecution instanceof TopLevelStepExecutionEntity) {
                if (foundTopLevelStepExec) {
                    throw new IllegalArgumentException("Found two top-level step thread execs at job instance id: " + jobInstanceId + " stepName: " + stepName + ", and job execution sequence number: " + jobExecNum);
                }
                retVal.setTopLevelStepExecution((WSTopLevelStepExecution)((Object)stepThreadExecution));
                foundTopLevelStepExec = true;
                continue;
            }
            partitionExecs.add(stepThreadExecution);
        }
        if (!foundTopLevelStepExec) {
            this.getJobInstance(jobInstanceId);
            throw new IllegalArgumentException("Didn't find top-level step thread exec at job instance id: " + jobInstanceId + " stepName: " + stepName + ", and job execution sequence number: " + jobExecNum);
        }
        Collections.sort(partitionExecs, StepThreadExecutionPartitionNumberComparator.INSTANCE);
        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(partitionExecs));
        WSStepThreadExecutionAggregateImpl wSStepThreadExecutionAggregateImpl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregateImpl = wSStepThreadExecutionAggregateImpl;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionNumberAndStepName", wSStepThreadExecutionAggregateImpl);
        }
        return wSStepThreadExecutionAggregateImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity updateStepExecution(RuntimeStepExecution runtimeStepExecution) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateStepExecution", new Object[]{runtimeStepExecution});
        }
        StepThreadExecutionEntity stepExecutionEntity = this.getStepThreadExecution(runtimeStepExecution.getInternalStepThreadExecutionId());
        if (stepExecutionEntity == null) {
            throw new IllegalStateException("StepThreadExecEntity with id =" + runtimeStepExecution.getInternalStepThreadExecutionId() + " should be persisted at this point, but didn't find it.");
        }
        this.updateStepExecutionStatusTimeStampsUserDataAndMetrics(stepExecutionEntity, runtimeStepExecution);
        StepThreadExecutionEntity stepThreadExecutionEntity = stepExecutionEntity;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateStepExecution", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity updateStepExecutionWithPartitionAggregate(RuntimeStepExecution runtimeStepExecution) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateStepExecutionWithPartitionAggregate", new Object[]{runtimeStepExecution});
        }
        TopLevelStepExecutionEntity stepExec = (TopLevelStepExecutionEntity)this.getStepThreadExecution(runtimeStepExecution.getInternalStepThreadExecutionId());
        this.updateStepExecutionStatusTimeStampsUserDataAndMetrics(stepExec, runtimeStepExecution);
        for (StepThreadExecutionEntity stepThreadExec : stepExec.getTopLevelAndPartitionStepExecutions()) {
            if (stepThreadExec instanceof TopLevelStepExecutionEntity) continue;
            stepExec.addMetrics(stepThreadExec);
        }
        TopLevelStepExecutionEntity topLevelStepExecutionEntity = stepExec;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateStepExecutionWithPartitionAggregate", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<JobInstanceEntity> readJobInstancesPage(List<JobInstanceEntity> totalJobInstances, int page, int pageSize) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "readJobInstancesPage", new Object[]{totalJobInstances, page, pageSize});
        }
        ArrayList<JobInstanceEntity> retMe = new ArrayList<JobInstanceEntity>();
        int index = page * pageSize;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("page value : " + page);
            logger.finest("pageSize value : " + pageSize);
            logger.finest("index (page * pageSize) : " + index);
            logger.finest("totalJobInstances.size() = " + totalJobInstances.size());
        }
        if (totalJobInstances.size() < 1) {
            ArrayList<JobInstanceEntity> arrayList = retMe;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                arrayList = arrayList;
                logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "readJobInstancesPage", arrayList);
            }
            return arrayList;
        }
        while (retMe.size() < pageSize && index < totalJobInstances.size()) {
            retMe.add(totalJobInstances.get(index));
            ++index;
        }
        ArrayList<JobInstanceEntity> arrayList = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "readJobInstancesPage", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void purgeInGlassfish(String submitter) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "purgeInGlassfish", new Object[]{submitter});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "purgeInGlassfish");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean purgeJobInstanceAndRelatedData(long jobInstanceId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "purgeJobInstanceAndRelatedData", new Object[]{jobInstanceId});
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "purgeJobInstanceAndRelatedData", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithInstanceStateAndBatchStatus(long jobInstanceId, InstanceState state, BatchStatus batchStatus, Date lastUpdated) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithInstanceStateAndBatchStatus", new Object[]{jobInstanceId, state, batchStatus, lastUpdated});
        }
        JobInstanceEntity jobInstance = this.data.jobInstanceData.get(jobInstanceId);
        try {
            this.verifyStatusTransitionIsValid(jobInstance, batchStatus);
            this.verifyStateTransitionIsValid(jobInstance, state);
        }
        catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
            void e;
            FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", (String)"1312", (Object)this, (Object[])new Object[]{jobInstanceId, state, batchStatus, lastUpdated});
            throw new PersistenceException((Throwable)e);
        }
        jobInstance.setInstanceState(state);
        jobInstance.setBatchStatus(batchStatus);
        jobInstance.setLastUpdatedTime(lastUpdated);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JobInstance : " + Long.toString(jobInstanceId) + " batchStatus updated : " + batchStatus.toString() + " InstanceState updated : " + state.toString());
        }
        JobInstanceEntity jobInstanceEntity = jobInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateJobInstanceWithInstanceStateAndBatchStatus", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(IJPAQueryHelper queryHelper, int page, int pageSize) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstances", new Object[]{queryHelper, page, pageSize});
        }
        throw new UnsupportedOperationException("The REST URL search parameters requesting this function are not supported by the Java batch memory-based persistence configuration.");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotablePartitionEntity createRemotablePartition(long jobExecId, String stepName, int partitionNum, RemotablePartitionState partitionState) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createRemotablePartition", new Object[]{jobExecId, stepName, partitionNum, partitionState});
        }
        RemotablePartitionKey partitionKey = new RemotablePartitionKey(jobExecId, stepName, partitionNum);
        JobExecutionEntity jobExecution = this.data.executionInstanceData.get(partitionKey.getJobExec());
        RemotablePartitionEntity partition = new RemotablePartitionEntity(jobExecution, partitionKey);
        partition.setInternalStatus(RemotablePartitionState.QUEUED);
        partition.setLastUpdated(new Date());
        this.data.partitionData.put(partitionKey, partition);
        jobExecution.getRemotablePartitions().add(partition);
        RemotablePartitionEntity remotablePartitionEntity = partition;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            remotablePartitionEntity = remotablePartitionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "createRemotablePartition", remotablePartitionEntity);
        }
        return remotablePartitionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotablePartitionEntity updateRemotablePartitionInternalState(long jobExecId, String stepName, int partitionNum, RemotablePartitionState internalStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateRemotablePartitionInternalState", new Object[]{jobExecId, stepName, partitionNum, internalStatus});
        }
        RemotablePartitionKey partitionKey = new RemotablePartitionKey(jobExecId, stepName, partitionNum);
        RemotablePartitionEntity partition = this.data.partitionData.get(partitionKey);
        partition.setInternalStatus(internalStatus);
        partition.setRestUrl(this.batchLocationService.getBatchRestUrl());
        partition.setServerId(this.batchLocationService.getServerId());
        partition.setLastUpdated(new Date());
        RemotablePartitionEntity remotablePartitionEntity = partition;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            remotablePartitionEntity = remotablePartitionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "updateRemotablePartitionInternalState", remotablePartitionEntity);
        }
        return remotablePartitionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobExecutionTableVersion() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecutionTableVersion", new Object[0]);
        }
        int n = 2;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobExecutionTableVersion", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceTableVersion() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstanceTableVersion", new Object[0]);
        }
        int n = 2;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getJobInstanceTableVersion", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPersistenceType() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getPersistenceType", new Object[0]);
        }
        String string = "MEM";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.MemoryPersistenceManagerImpl", "getPersistenceType", string);
        }
        return string;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class StepExecutionIDComparator
    implements Comparator<StepExecution> {
        public static final StepExecutionIDComparator INSTANCE;
        static final long serialVersionUID = 7147268955466016702L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private StepExecutionIDComparator() {
        }

        @Override
        public int compare(StepExecution o1, StepExecution o2) {
            return new Long(o1.getStepExecutionId()).compareTo(o2.getStepExecutionId());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StepExecutionIDComparator.class);
            INSTANCE = new StepExecutionIDComparator();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class JobExecutionIDComparator
    implements Comparator<JobExecution> {
        public static final JobExecutionIDComparator INSTANCE;
        static final long serialVersionUID = -8793950730252920369L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobExecutionIDComparator() {
        }

        @Override
        public int compare(JobExecution o1, JobExecution o2) {
            return new Long(o1.getExecutionId()).compareTo(o2.getExecutionId());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(JobExecutionIDComparator.class);
            INSTANCE = new JobExecutionIDComparator();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class StepThreadExecutionPartitionNumberComparator
    implements Comparator<StepThreadExecutionEntity> {
        public static final StepThreadExecutionPartitionNumberComparator INSTANCE;
        static final long serialVersionUID = -3101741062550203219L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private StepThreadExecutionPartitionNumberComparator() {
        }

        @Override
        public int compare(StepThreadExecutionEntity o1, StepThreadExecutionEntity o2) {
            return o1.getPartitionNumber() - o2.getPartitionNumber();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StepThreadExecutionPartitionNumberComparator.class);
            INSTANCE = new StepThreadExecutionPartitionNumberComparator();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class StepExecutionStartDateComparator
    implements Comparator<StepExecution> {
        public static final StepExecutionStartDateComparator INSTANCE;
        static final long serialVersionUID = 9211906663765955444L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private StepExecutionStartDateComparator() {
        }

        @Override
        public int compare(StepExecution o1, StepExecution o2) {
            return o1.getStartTime().compareTo(o2.getStartTime());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StepExecutionStartDateComparator.class);
            INSTANCE = new StepExecutionStartDateComparator();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ReverseJobInstanceCreationDateComparator
    implements Comparator<JobInstanceEntity> {
        public static final ReverseJobInstanceCreationDateComparator INSTANCE;
        static final long serialVersionUID = -4315871144793595341L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ReverseJobInstanceCreationDateComparator() {
        }

        @Override
        public int compare(JobInstanceEntity o1, JobInstanceEntity o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReverseJobInstanceCreationDateComparator.class);
            INSTANCE = new ReverseJobInstanceCreationDateComparator();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ReverseJobExecutionCreationDateComparator
    implements Comparator<JobExecutionEntity> {
        public static final ReverseJobExecutionCreationDateComparator INSTANCE;
        static final long serialVersionUID = -8526425975880581096L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ReverseJobExecutionCreationDateComparator() {
        }

        @Override
        public int compare(JobExecutionEntity o1, JobExecutionEntity o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReverseJobExecutionCreationDateComparator.class);
            INSTANCE = new ReverseJobExecutionCreationDateComparator();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ReverseJobExecutionSequenceForOneInstanceComparator
    implements Comparator<JobExecutionEntity> {
        public static final ReverseJobExecutionSequenceForOneInstanceComparator INSTANCE;
        static final long serialVersionUID = 8567235778304388375L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ReverseJobExecutionSequenceForOneInstanceComparator() {
        }

        @Override
        public int compare(JobExecutionEntity o1, JobExecutionEntity o2) {
            Integer i1 = o1.getExecutionNumberForThisInstance();
            Integer i2 = o2.getExecutionNumberForThisInstance();
            return i2.compareTo(i1);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReverseJobExecutionSequenceForOneInstanceComparator.class);
            INSTANCE = new ReverseJobExecutionSequenceForOneInstanceComparator();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class Data {
        protected final AtomicLong jobInstanceIdGenerator = new AtomicLong(1L);
        protected final AtomicLong executionInstanceIdGenerator = new AtomicLong(1L);
        protected final AtomicLong stepExecutionIdGenerator = new AtomicLong(1L);
        protected final Map<Long, JobInstanceEntity> jobInstanceData = new ConcurrentHashMap<Long, JobInstanceEntity>();
        protected final Map<Long, JobExecutionEntity> executionInstanceData = new ConcurrentHashMap<Long, JobExecutionEntity>();
        protected final Map<Long, StepThreadExecutionEntity> stepExecutionInstanceData = new ConcurrentHashMap<Long, StepThreadExecutionEntity>();
        protected final Map<StepThreadInstanceKey, StepThreadInstanceEntity> stepThreadInstanceData = new ConcurrentHashMap<StepThreadInstanceKey, StepThreadInstanceEntity>();
        protected final Map<RemotablePartitionKey, RemotablePartitionEntity> partitionData = new ConcurrentHashMap<RemotablePartitionKey, RemotablePartitionEntity>();
        protected final Map<RemotableSplitFlowKey, RemotableSplitFlowEntity> splitFlowData = new ConcurrentHashMap<RemotableSplitFlowKey, RemotableSplitFlowEntity>();
        static final long serialVersionUID = 3595263559715931796L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Data() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Data.class);
        }
    }
}

