/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IThreadRootController;
import com.ibm.jbatch.container.callback.IJobExecutionEndCallbackService;
import com.ibm.jbatch.container.callback.IJobExecutionStartCallbackService;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.execution.impl.JobExecutionHelper;
import com.ibm.jbatch.container.execution.impl.RuntimeJobExecution;
import com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.impl.ParallelStepBuilder;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobXMLSource;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.JobXMLSource;
import com.ibm.jbatch.container.util.BatchJobWorkUnit;
import com.ibm.jbatch.container.util.BatchPartitionWorkUnit;
import com.ibm.jbatch.container.util.BatchSplitFlowWorkUnit;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.util.SplitFlowConfig;
import com.ibm.jbatch.container.ws.JobStoppedOnStartException;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(service={IBatchKernelService.class, ServerQuiesceListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class BatchKernelImpl
implements IBatchKernelService,
ServerQuiesceListener {
    private static final Logger logger = Logger.getLogger(BatchKernelImpl.class.getName(), "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    private final Map<Long, BatchJobWorkUnit> executingJobs;
    private final Map<String, SubWorkUnitComparisonHelper> executingSubWorkUnits;
    private IBatchThreadPoolService executorService;
    private IPersistenceManagerService persistenceService;
    private MetaDataIdentifierService metaDataIdentifierService;
    private final List<IJobExecutionStartCallbackService> jobExecutionStartCallbacks;
    private final List<IJobExecutionEndCallbackService> jobExecutionEndCallbacks;
    private JobExecutionHelper jobExecutionHelper;
    private final Object shutdownLock;
    private BatchEventsPublisher eventsPublisher;
    static final long serialVersionUID = -7839340226763132679L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchKernelImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "<init>", new Object[0]);
        }
        this.executingJobs = new ConcurrentHashMap<Long, BatchJobWorkUnit>();
        this.executingSubWorkUnits = new ConcurrentHashMap<String, SubWorkUnitComparisonHelper>();
        this.executorService = null;
        this.persistenceService = null;
        this.metaDataIdentifierService = null;
        this.jobExecutionStartCallbacks = new ArrayList<IJobExecutionStartCallbackService>();
        this.jobExecutionEndCallbacks = new ArrayList<IJobExecutionEndCallbackService>();
        this.shutdownLock = new Object();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "activate", new Object[0]);
        }
        this.jobExecutionHelper = new JobExecutionHelper(this);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "deactivate", new Object[0]);
        }
        this.shutdown();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    public void setIBatchThreadPoolService(IBatchThreadPoolService reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "setIBatchThreadPoolService", new Object[]{reference});
        }
        this.executorService = reference;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "setIBatchThreadPoolService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    public void setIPersistenceManagerService(IPersistenceManagerService reference, Map<String, Object> props) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "setIPersistenceManagerService", new Object[]{reference, props});
        }
        logger.log(Level.INFO, "batch.kernel.persistence", props.get("persistenceType"));
        this.persistenceService = reference;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "setIPersistenceManagerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    public void setMetaDataIdentifierService(MetaDataIdentifierService metaDataIdentifierService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "setMetaDataIdentifierService", new Object[]{metaDataIdentifierService});
        }
        this.metaDataIdentifierService = metaDataIdentifierService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "setMetaDataIdentifierService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void unsetMetaDataIdentifierService(MetaDataIdentifierService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "unsetMetaDataIdentifierService", new Object[]{ref});
        }
        if (this.metaDataIdentifierService == ref) {
            this.metaDataIdentifierService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "unsetMetaDataIdentifierService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IPersistenceManagerService getPersistenceManagerService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "getPersistenceManagerService", new Object[0]);
        }
        IPersistenceManagerService iPersistenceManagerService = this.persistenceService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iPersistenceManagerService = iPersistenceManagerService;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "getPersistenceManagerService", iPersistenceManagerService);
        }
        return iPersistenceManagerService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setJobExecutionStartCallbackService(IJobExecutionStartCallbackService reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "setJobExecutionStartCallbackService", new Object[]{reference});
        }
        this.jobExecutionStartCallbacks.add(reference);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "setJobExecutionStartCallbackService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetJobExecutionStartCallbackService(IJobExecutionStartCallbackService reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "unsetJobExecutionStartCallbackService", new Object[]{reference});
        }
        this.jobExecutionStartCallbacks.remove(reference);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "unsetJobExecutionStartCallbackService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setJobExecutionEndCallbackService(IJobExecutionEndCallbackService reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "setJobExecutionEndCallbackService", new Object[]{reference});
        }
        this.jobExecutionEndCallbacks.add(reference);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "setJobExecutionEndCallbackService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetJobExecutionEndCallbackService(IJobExecutionEndCallbackService reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "unsetJobExecutionEndCallbackService", new Object[]{reference});
        }
        this.jobExecutionEndCallbacks.remove(reference);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "unsetJobExecutionEndCallbackService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEventsPublisher(BatchEventsPublisher publisher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "setEventsPublisher", new Object[]{publisher});
        }
        this.eventsPublisher = publisher;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "setEventsPublisher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetEventsPublisher(BatchEventsPublisher publisher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "unsetEventsPublisher", new Object[]{publisher});
        }
        if (this.eventsPublisher == publisher) {
            this.eventsPublisher = publisher;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "unsetEventsPublisher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchEventsPublisher getBatchEventsPublisher() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "getBatchEventsPublisher", new Object[0]);
        }
        BatchEventsPublisher batchEventsPublisher = this.eventsPublisher;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchEventsPublisher = batchEventsPublisher;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "getBatchEventsPublisher", batchEventsPublisher);
        }
        return batchEventsPublisher;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig pgcConfig) throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "init", new Object[]{pgcConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "shutdown", new Object[0]);
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            this.stopAllActiveJobs();
            this.stopAllActiveSubWorkUnits();
            this.waitForActiveJobsAndSubJobsToStop();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "shutdown");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance createJobInstanceIntraApplication(String jobXMLName, String submitter) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "createJobInstanceIntraApplication", new Object[]{jobXMLName, submitter});
        }
        String amc = this.metaDataIdentifierService.getMetaDataIdentifier((MetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData());
        int firstHash = amc.indexOf("#");
        String fixedAmc = amc.substring(firstHash + 1);
        WSJobInstance wSJobInstance = this.createJobInstance(fixedAmc, jobXMLName, submitter, null, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSJobInstance = wSJobInstance;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "createJobInstanceIntraApplication", wSJobInstance);
        }
        return wSJobInstance;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSJobInstance createJobInstance(String appName, String jobXMLName, String submitter, String jsl, String correlationId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "createJobInstance", new Object[]{appName, jobXMLName, submitter, jsl, correlationId});
        }
        JobInstanceEntity retMe = null;
        retMe = this.getPersistenceManagerService().createJobInstance(appName, jobXMLName, jsl, submitter, new Date());
        this.publishEvent(retMe, "batch/jobs/instance/submitted", correlationId);
        JobInstanceEntity jobInstanceEntity = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "createJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEvent(WSJobExecution objectToPublish, String eventToPublishTo, String correlationId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "publishEvent", new Object[]{objectToPublish, eventToPublishTo, correlationId});
        }
        if (this.eventsPublisher != null) {
            this.eventsPublisher.publishJobExecutionEvent(objectToPublish, eventToPublishTo, correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "publishEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEvent(WSJobInstance objectToPublish, String eventToPublishTo, String correlationId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "publishEvent", new Object[]{objectToPublish, eventToPublishTo, correlationId});
        }
        if (this.eventsPublisher != null) {
            this.eventsPublisher.publishJobInstanceEvent(objectToPublish, eventToPublishTo, correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "publishEvent");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map.Entry<Long, Future<?>> startJob(WSJobInstance jobInstance, IJobXMLSource jobXML, Properties jobParameters, long executionId) throws JobStartException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "startJob", new Object[]{jobInstance, jobXML, jobParameters, executionId});
        }
        this.traceJobXML(jobXML);
        JobInstanceEntity instanceEntity = this.getPersistenceManagerService().getJobInstance(jobInstance.getInstanceId());
        if (instanceEntity.getBatchStatus() == BatchStatus.STOPPED) {
            throw new JobStoppedOnStartException();
        }
        RuntimeJobExecution jobExecution = this.jobExecutionHelper.createJobStartExecution(jobInstance, jobXML, jobParameters, executionId);
        BatchJobWorkUnit batchWork = new BatchJobWorkUnit(this, jobExecution, this.jobExecutionStartCallbacks, this.jobExecutionEndCallbacks);
        this.registerExecutingJob(jobExecution.getTopLevelExecutionId(), batchWork);
        Future<?> futureWork = null;
        try {
            this.getPersistenceManagerService().updateJobExecutionServerIdAndRestUrl(jobExecution.getTopLevelExecutionId());
            futureWork = this.executorService.executeTask(batchWork, null);
        }
        catch (RuntimeException runtimeException) {
            void e;
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.jbatch.container.impl.BatchKernelImpl", (String)"304", (Object)this, (Object[])new Object[]{jobInstance, jobXML, jobParameters, executionId});
            this.workUnitCompleted(batchWork);
            throw e;
        }
        AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry(jobExecution.getTopLevelExecutionId(), futureWork);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            simpleEntry = simpleEntry;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "startJob", simpleEntry);
        }
        return simpleEntry;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map.Entry<Long, Future<?>> restartJob(long executionId, Properties jobOverrideProps) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "restartJob", new Object[]{executionId, jobOverrideProps});
        }
        long instanceId = this.getPersistenceManagerService().getJobInstanceIdFromExecutionId(executionId);
        JobInstanceEntity jobInstance = this.getPersistenceManagerService().getJobInstance(instanceId);
        Map.Entry<Long, Future<?>> entry = this.restartJobInstance(instanceId, new JobXMLSource(jobInstance.getJobXml()), jobOverrideProps, executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            entry = entry;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "restartJob", entry);
        }
        return entry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map.Entry<Long, Future<?>> restartJobInstance(long instanceId, IJobXMLSource jobXML, Properties jobOverrideProps, long executionId) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException, NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "restartJobInstance", new Object[]{instanceId, jobXML, jobOverrideProps, executionId});
        }
        RuntimeJobExecution jobExecution = this.jobExecutionHelper.createJobRestartExecution(instanceId, jobXML, jobOverrideProps, executionId);
        BatchJobWorkUnit batchWork = new BatchJobWorkUnit(this, jobExecution, this.jobExecutionStartCallbacks, this.jobExecutionEndCallbacks);
        this.registerExecutingJob(jobExecution.getTopLevelExecutionId(), batchWork);
        Future<?> futureExecution = null;
        try {
            this.getPersistenceManagerService().updateJobExecutionServerIdAndRestUrl(jobExecution.getTopLevelExecutionId());
            futureExecution = this.executorService.executeTask(batchWork, null);
        }
        catch (RuntimeException runtimeException) {
            void e;
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.jbatch.container.impl.BatchKernelImpl", (String)"338", (Object)this, (Object[])new Object[]{instanceId, jobXML, jobOverrideProps, executionId});
            this.workUnitCompleted(batchWork);
            throw e;
        }
        String correlationId = jobExecution.getCorrelationId();
        this.publishEvent(this.getPersistenceManagerService().getJobExecution(jobExecution.getTopLevelExecutionId()), "batch/jobs/execution/restarting", correlationId);
        AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry(jobExecution.getTopLevelExecutionId(), futureExecution);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            simpleEntry = simpleEntry;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "restartJobInstance", simpleEntry);
        }
        return simpleEntry;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchPartitionWorkUnit createPartitionWorkUnit(PartitionPlanConfig config, Step step, PartitionReplyQueue partitionReplyQueue, boolean isRemoteDispatch) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "createPartitionWorkUnit", new Object[]{config, step, partitionReplyQueue, isRemoteDispatch});
        }
        JSLJob partitionJobModel = ParallelStepBuilder.buildPartitionLevelJSLJob(config.getTopLevelExecutionId(), config.getJobProperties(), step, config.getPartitionNumber());
        RuntimePartitionExecution partitionExecution = this.jobExecutionHelper.createPartitionExecution(config, partitionJobModel, isRemoteDispatch);
        BatchPartitionWorkUnit batchWorkUnit = new BatchPartitionWorkUnit(this, partitionExecution, config, this.jobExecutionStartCallbacks, this.jobExecutionEndCallbacks, partitionReplyQueue);
        this.registerExecutingSubWorkUnit(partitionExecution.getTopLevelExecutionId(), batchWorkUnit);
        BatchPartitionWorkUnit batchPartitionWorkUnit = batchWorkUnit;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchPartitionWorkUnit = batchPartitionWorkUnit;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "createPartitionWorkUnit", batchPartitionWorkUnit);
        }
        return batchPartitionWorkUnit;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchSplitFlowWorkUnit createSplitFlowWorkUnit(SplitFlowConfig splitFlowConfig, JSLJob splitFlowJobModel, BlockingQueue<BatchSplitFlowWorkUnit> completedWorkQueue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "createSplitFlowWorkUnit", new Object[]{splitFlowConfig, splitFlowJobModel, completedWorkQueue});
        }
        RuntimeSplitFlowExecution execution = this.jobExecutionHelper.createSplitFlowExecution(splitFlowConfig, splitFlowJobModel);
        BatchSplitFlowWorkUnit batchWork = new BatchSplitFlowWorkUnit((IBatchKernelService)this, execution, completedWorkQueue, this.jobExecutionStartCallbacks, this.jobExecutionEndCallbacks);
        this.registerExecutingSubWorkUnit(execution.getTopLevelExecutionId(), batchWork);
        BatchSplitFlowWorkUnit batchSplitFlowWorkUnit = batchWork;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchSplitFlowWorkUnit = batchSplitFlowWorkUnit;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "createSplitFlowWorkUnit", batchSplitFlowWorkUnit);
        }
        return batchSplitFlowWorkUnit;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> runPartition(BatchPartitionWorkUnit batchWork) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "runPartition", new Object[]{batchWork});
        }
        Future<?> future = this.executorService.executeParallelTask(batchWork, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            future = future;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "runPartition", future);
        }
        return future;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void runSplitFlow(BatchSplitFlowWorkUnit batchWork) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "runSplitFlow", new Object[]{batchWork});
        }
        this.executorService.executeParallelTask(batchWork, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "runSplitFlow");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workUnitCompleted(BatchWorkUnit workUnit) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "workUnitCompleted", new Object[]{workUnit});
        }
        long jobExecutionId = workUnit.getRuntimeWorkUnitExecution().getTopLevelExecutionId();
        if (workUnit instanceof BatchJobWorkUnit) {
            if (this.executingJobs.containsKey(jobExecutionId)) {
                this.executingJobs.remove(jobExecutionId);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("job completed: For jobExecId = " + jobExecutionId + ", removed job work unit");
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("job completed: For jobExecId = " + jobExecutionId + ", but didn't find job work unit to remove");
            }
        } else {
            SubWorkUnitComparisonHelper comparisonHelper = new SubWorkUnitComparisonHelper(workUnit);
            if (this.executingSubWorkUnits.containsKey(comparisonHelper.comparisonKey)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("subjob completed: For jobExecId = " + jobExecutionId + ", removed subjob work unit");
                }
                this.executingSubWorkUnits.remove(comparisonHelper.comparisonKey);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("subjob completed: For jobExecId = " + jobExecutionId + ", but didn't find job work unit to remove");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "workUnitCompleted");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stopWorkUnit(BatchWorkUnit workUnit) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "stopWorkUnit", new Object[]{workUnit});
        }
        IThreadRootController controller = workUnit.getController();
        if (controller != null) {
            controller.stop();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "stopWorkUnit");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stopJob(long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "stopJob", new Object[]{jobExecutionId});
        }
        BatchJobWorkUnit jobWorkUnit = this.executingJobs.get(jobExecutionId);
        if (jobWorkUnit == null) {
            String msg = "JobExecution with execution id of " + jobExecutionId + " is not running.";
            throw new JobExecutionNotRunningException(msg);
        }
        this.stopWorkUnit(jobWorkUnit);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "stopJob");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void registerExecutingJob(long jobExecutionId, BatchJobWorkUnit workUnit) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "registerExecutingJob", new Object[]{jobExecutionId, workUnit});
        }
        if (this.executingJobs.containsKey(jobExecutionId)) {
            throw new IllegalStateException("Already have entry in executingJobs map for job exec id = " + jobExecutionId);
        }
        this.executingJobs.put(jobExecutionId, workUnit);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "registerExecutingJob");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void registerExecutingSubWorkUnit(long jobExecutionId, BatchWorkUnit workUnit) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "registerExecutingSubWorkUnit", new Object[]{jobExecutionId, workUnit});
        }
        SubWorkUnitComparisonHelper comparisonHelper = new SubWorkUnitComparisonHelper(workUnit);
        if (this.executingSubWorkUnits.containsKey(comparisonHelper.comparisonKey)) {
            throw new IllegalStateException("Already have entry in relatedSubWorkUnits set for job exec id = " + jobExecutionId + ", for subjob work unit: " + workUnit);
        }
        this.executingSubWorkUnits.put(comparisonHelper.comparisonKey, comparisonHelper);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "registerExecutingSubWorkUnit");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void stopAllActiveJobs() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "stopAllActiveJobs", new Object[0]);
        }
        for (Long jobExecutionId : this.executingJobs.keySet()) {
            try {
                logger.log(Level.INFO, "stopping.job.at.shutdown", jobExecutionId);
                this.stopJob(jobExecutionId);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.impl.BatchKernelImpl", (String)"507", (Object)this, (Object[])new Object[0]);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "stopAllActiveJobs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void stopAllActiveSubWorkUnits() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "stopAllActiveSubWorkUnits", new Object[0]);
        }
        for (String key : this.executingSubWorkUnits.keySet()) {
            try {
                logger.fine("Issuing stop for sub job : " + key + " because the batch component is deactivating.");
                this.stopWorkUnit(this.executingSubWorkUnits.get(key).batchWorkUnit);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.impl.BatchKernelImpl", (String)"526", (Object)this, (Object[])new Object[0]);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "stopAllActiveSubWorkUnits");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void waitForActiveJobsAndSubJobsToStop() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "waitForActiveJobsAndSubJobsToStop", new Object[0]);
        }
        if (this.executingSubWorkUnits.isEmpty() && this.executingJobs.isEmpty()) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "waitForActiveJobsAndSubJobsToStop");
            }
            return;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.jbatch.container.impl.BatchKernelImpl", (String)"556", (Object)this, (Object[])new Object[0]);
        }
        if (!this.executingJobs.isEmpty()) {
            logger.log(Level.INFO, "jobs.running.at.shutdown", this.executingJobs.keySet());
        }
        if (!this.executingSubWorkUnits.isEmpty()) {
            logger.fine("The following job executions were still running at the time of deactivation: " + this.executingSubWorkUnits.keySet().toString());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "waitForActiveJobsAndSubJobsToStop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void traceJobXML(IJobXMLSource source) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "traceJobXML", new Object[]{source});
        }
        if (logger.isLoggable(Level.FINE)) {
            String jobXML = source.getJSLString();
            int concatLen = jobXML.length() > 200 ? 200 : jobXML.length();
            logger.fine("Starting job with JSL: " + jobXML.substring(0, concatLen) + "... truncated ...");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "traceJobXML");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map.Entry<BatchPartitionWorkUnit, Future<?>> startPartition(PartitionPlanConfig partitionPlanConfig, Step step, PartitionReplyQueue partitionReplyQueue, boolean isRemoteDispatch) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "startPartition", new Object[]{partitionPlanConfig, step, partitionReplyQueue, isRemoteDispatch});
        }
        BatchPartitionWorkUnit workUnit = this.createPartitionWorkUnit(partitionPlanConfig, step, partitionReplyQueue, isRemoteDispatch);
        Future<?> futureWork = this.runPartition(workUnit);
        AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry(workUnit, futureWork);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            simpleEntry = simpleEntry;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "startPartition", simpleEntry);
        }
        return simpleEntry;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long getJobExecutionIdFromExecutingSubWorkUnitKey(String comparisonKey) {
        long l;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "getJobExecutionIdFromExecutingSubWorkUnitKey", new Object[]{comparisonKey});
        }
        try {
            l = Long.parseLong(comparisonKey.split("::")[0]);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.jbatch.container.impl.BatchKernelImpl", (String)"660", (Object)this, (Object[])new Object[]{comparisonKey});
            throw new IllegalStateException("Sub Work Unit found without a parent Execution Id");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "getJobExecutionIdFromExecutingSubWorkUnitKey", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void serverStopping() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "serverStopping", new Object[0]);
        }
        this.shutdown();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "serverStopping");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchStatus getBatchStatus(long jobExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.impl.BatchKernelImpl", "getBatchStatus", new Object[]{jobExecutionId});
        }
        BatchStatus retVal = null;
        BatchWorkUnit bwu = this.executingJobs.get(jobExecutionId);
        if (bwu != null) {
            retVal = bwu.getRuntimeWorkUnitExecution().getBatchStatus();
            logger.finer("Returning local BatchStatus of: " + retVal);
        } else {
            logger.finer("Local BatchStatus not found, returning <null>");
        }
        BatchStatus batchStatus = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchStatus = batchStatus;
            logger.exiting("com.ibm.jbatch.container.impl.BatchKernelImpl", "getBatchStatus", batchStatus);
        }
        return batchStatus;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class SubWorkUnitComparisonHelper {
        private final BatchWorkUnit batchWorkUnit;
        private final String comparisonKey;
        static final long serialVersionUID = 3479275269979601237L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public String toString() {
            return "SubWorkUnitComparisonHelper [comparisonKey=" + this.comparisonKey + "]";
        }

        public SubWorkUnitComparisonHelper(BatchWorkUnit workUnit) {
            this.batchWorkUnit = workUnit;
            if (this.batchWorkUnit.getRuntimeWorkUnitExecution() == null) {
                throw new IllegalStateException("Somehow got a not-fully initialized object.");
            }
            this.comparisonKey = this.getComparisonKey(this.batchWorkUnit.getRuntimeWorkUnitExecution());
        }

        private String getComparisonKey(RuntimeWorkUnitExecution rwue) {
            if (rwue instanceof RuntimeSplitFlowExecution) {
                return rwue.getTopLevelExecutionId() + "::" + ((RuntimeSplitFlowExecution)rwue).getFlowName();
            }
            if (rwue instanceof RuntimePartitionExecution) {
                return rwue.getTopLevelExecutionId() + "::" + ((RuntimePartitionExecution)rwue).getStepName() + "::" + ((RuntimePartitionExecution)rwue).getPartitionNumber();
            }
            throw new IllegalArgumentException("Unknown class in type hierarchy");
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof SubWorkUnitComparisonHelper) {
                return this.comparisonKey.equals(((SubWorkUnitComparisonHelper)o).comparisonKey);
            }
            return false;
        }

        public int hashCode() {
            return this.comparisonKey.hashCode();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SubWorkUnitComparisonHelper.class);
        }
    }
}

