/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.j2ee.mbeans.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.management.j2ee.mbeans.J2EEDomainMBeanImpl;
import com.ibm.ws.management.j2ee.mbeans.J2EEServerMBeanImpl;
import com.ibm.ws.management.j2ee.mbeans.JVMMBeanImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class SMActivator {
    public static final String TRACE_GROUP_SM_MBEANS = "management.j2ee.mbeans";
    public static final String TRACE_BUNDLE_SM_MBEANS = "com.ibm.ws.management.j2ee.mbeans.internal.resources.SMMessages";
    private static final TraceComponent tc = Tr.register(SMActivator.class, (String)"management.j2ee.mbeans", (String)"com.ibm.ws.management.j2ee.mbeans.internal.resources.SMMessages");
    private static final String KEY_JMX_OBJECTNAME = "jmx.objectname";
    private static final String KEY_SERVICE_VENDOR = "service.vendor";
    private static final int JVM_INDEX = 1;
    private static final int J2EEDOMAIN_INDEX = 2;
    private static final int J2EESERVER_INDEX = 3;
    private static final int JMR_INDEX = 4;
    private static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    static final long serialVersionUID = 6012210298290358257L;

    @Activate
    protected void activate(ComponentContext context) throws IOException {
        this.locationAdminRef.activate(context);
        BundleContext bundle = context.getBundleContext();
        this.registerService(1, bundle);
        this.registerService(2, bundle);
        this.registerService(3, bundle);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.locationAdminRef.deactivate(context);
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    protected WsLocationAdmin getWsLocationAdmin() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin == null) {
            this.throwMissingServiceError("WsLocationAdmin");
        }
        return locationAdmin;
    }

    private void throwMissingServiceError(String service) {
        throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{service}));
    }

    private void registerService(int index, BundleContext bundle) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(KEY_SERVICE_VENDOR, "IBM");
        switch (index) {
            case 1: {
                JVMMBeanImpl jvm = new JVMMBeanImpl(this.getServerName());
                ((Dictionary)props).put(KEY_JMX_OBJECTNAME, jvm.getobjectName());
                bundle.registerService(JVMMBeanImpl.class, (Object)jvm, props);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("jvm=" + jvm.toString() + " props=" + props), (Object[])new Object[0]);
                break;
            }
            case 2: {
                J2EEDomainMBeanImpl j2eeDomain = new J2EEDomainMBeanImpl();
                ((Dictionary)props).put(KEY_JMX_OBJECTNAME, j2eeDomain.getobjectName());
                bundle.registerService(J2EEDomainMBeanImpl.class, (Object)j2eeDomain, props);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("j2eeDomain=" + j2eeDomain.toString() + " props=" + props), (Object[])new Object[0]);
                break;
            }
            case 3: {
                J2EEServerMBeanImpl j2eeServer = new J2EEServerMBeanImpl(this.getServerName());
                ((Dictionary)props).put(KEY_JMX_OBJECTNAME, j2eeServer.getobjectName());
                bundle.registerService(J2EEServerMBeanImpl.class, (Object)j2eeServer, props);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("j2eeServer=" + j2eeServer.toString() + " props=" + props), (Object[])new Object[0]);
                break;
            }
        }
    }

    private String getServerName() {
        return this.getWsLocationAdmin().getServerName();
    }
}

