/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.monitor;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.monitor.SessionMonitor;
import com.ibm.ws.session.monitor.SessionStats;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class LegacyMonitor
extends StatisticActions {
    public static final int ACTIVE_SESSIONS = 6;
    public static final int LIVE_SESSIONS = 7;
    public static final int CREATE_SESSIONS = 1;
    public static final int INVALIDATED_SESSIONS = 2;
    public static final int INVALIDATED_SESSIONS_BYTIMEOUT = 16;
    private SPICountStatistic createCount;
    private SPIRangeStatistic activeCount;
    private SPIRangeStatistic liveCount;
    private SPICountStatistic invalidatedCount;
    private SPICountStatistic invalidatedCountbyTimeout;
    private StatsInstance si;

    public LegacyMonitor(String appName, StatsGroup grp) {
        if (grp != null) {
            try {
                this.si = StatsFactory.createStatsInstance((String)appName, (StatsGroup)grp, null, (StatisticActions)this);
            }
            catch (StatsFactoryException e) {
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"SessionMonitor");
            }
        }
    }

    public void statisticCreated(SPIStatistic s) {
        if (s.getId() == 6) {
            this.activeCount = (SPIRangeStatistic)s;
        } else if (s.getId() == 7) {
            this.liveCount = (SPIRangeStatistic)s;
        } else if (s.getId() == 1) {
            this.createCount = (SPICountStatistic)s;
        } else if (s.getId() == 2) {
            this.invalidatedCount = (SPICountStatistic)s;
        } else if (s.getId() == 16) {
            this.invalidatedCountbyTimeout = (SPICountStatistic)s;
        }
    }

    public void updateStatisticOnRequest(int dataId) {
        if (this.si != null) {
            SessionStats temp = SessionMonitor.getSessionStatsOB(this.si.getName());
            if (dataId == 6) {
                this.activeCount.set(temp.getActiveCount());
            }
            if (dataId == 7) {
                this.liveCount.set(temp.getLiveCount());
            }
            if (dataId == 1) {
                this.createCount.set(temp.getCreateCount(), 0L, temp.getCreateCount());
            }
            if (dataId == 2) {
                this.invalidatedCount.set(temp.getInvalidatedCount(), 0L, temp.getInvalidatedCount());
            }
            if (dataId == 16) {
                this.invalidatedCountbyTimeout.set(temp.getInvalidatedCountbyTimeout(), 0L, temp.getInvalidatedCountbyTimeout());
            }
        }
    }
}

