/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.metadata.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.metadata.ApplicationMetaDataListener;
import com.ibm.ws.container.service.metadata.ComponentMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.metadata.MethodMetaDataListener;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.metadata.extended.DeferredMetaDataFactory;
import com.ibm.ws.container.service.metadata.extended.IdentifiableComponentMetaData;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.container.service.metadata.internal.ApplicationMetaDataManager;
import com.ibm.ws.container.service.metadata.internal.ComponentMetaDataManager;
import com.ibm.ws.container.service.metadata.internal.MetaDataManager;
import com.ibm.ws.container.service.metadata.internal.MethodMetaDataManager;
import com.ibm.ws.container.service.metadata.internal.ModuleMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MethodMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MetaDataServiceImpl
implements MetaDataService,
MetaDataIdentifierService {
    private final ApplicationMetaDataManager applicationMetaDataManager = new ApplicationMetaDataManager("applicationMetaDataListeners");
    private final ModuleMetaDataManager moduleMetaDataManager = new ModuleMetaDataManager("moduleMetaDataListeners");
    private final ComponentMetaDataManager componentMetaDataManager = new ComponentMetaDataManager("componentMetaDataListeners");
    private final MethodMetaDataManager methodMetaDataManager = new MethodMetaDataManager("methodMetaDataListeners");
    private final ConcurrentHashMap<String, Container> appModuleNameToModuleContainer = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ComponentMetaData> jeeNameToComponentMetaData = new ConcurrentHashMap();
    private final ConcurrentServiceReferenceSet<DeferredMetaDataFactory> deferredMetaDataFactories = new ConcurrentServiceReferenceSet("deferredMetaDataFactory");
    private final ConcurrentServiceReferenceMap<String, DeferredMetaDataFactory> deferredMetaDataInitializers = new ConcurrentServiceReferenceMap("deferredMetaDataFactory");
    static final long serialVersionUID = -2494605732980966097L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(ComponentContext cc) {
        this.applicationMetaDataManager.activate(cc);
        this.moduleMetaDataManager.activate(cc);
        this.componentMetaDataManager.activate(cc);
        this.methodMetaDataManager.activate(cc);
        this.deferredMetaDataFactories.activate(cc);
        this.deferredMetaDataInitializers.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.applicationMetaDataManager.deactivate(cc);
        this.moduleMetaDataManager.deactivate(cc);
        this.componentMetaDataManager.deactivate(cc);
        this.methodMetaDataManager.deactivate(cc);
        this.deferredMetaDataFactories.deactivate(cc);
        this.deferredMetaDataInitializers.deactivate(cc);
    }

    <M extends MetaData> MetaDataManager<M, ?> getMetaDataManager(Class<M> metaDataClass) {
        if (metaDataClass == ApplicationMetaData.class) {
            return this.applicationMetaDataManager;
        }
        if (metaDataClass == ModuleMetaData.class) {
            return this.moduleMetaDataManager;
        }
        if (metaDataClass == ComponentMetaData.class) {
            return this.componentMetaDataManager;
        }
        if (metaDataClass == MethodMetaData.class) {
            return this.methodMetaDataManager;
        }
        throw new IllegalArgumentException(String.valueOf(metaDataClass));
    }

    public void addApplicationMetaDataListener(ServiceReference<ApplicationMetaDataListener> ref) {
        this.applicationMetaDataManager.addListener(ref);
    }

    public void removeApplicationMetaDataListener(ServiceReference<ApplicationMetaDataListener> ref) {
        this.applicationMetaDataManager.removeListener(ref);
    }

    @Override
    public void fireApplicationMetaDataCreated(ApplicationMetaData metaData, Container container) throws MetaDataException {
        if (container == null) {
            throw new IllegalArgumentException("container");
        }
        this.applicationMetaDataManager.fireMetaDataCreated(metaData, container);
    }

    @Override
    public void fireApplicationMetaDataDestroyed(ApplicationMetaData metaData) {
        this.applicationMetaDataManager.fireMetaDataDestroyed(metaData);
    }

    public void addModuleMetaDataListener(ServiceReference<ModuleMetaDataListener> ref) {
        this.moduleMetaDataManager.addListener(ref);
    }

    public void removeModuleMetaDataListener(ServiceReference<ModuleMetaDataListener> ref) {
        this.moduleMetaDataManager.removeListener(ref);
    }

    @Override
    public void fireModuleMetaDataCreated(ModuleMetaData metaData, Container container) throws MetaDataException {
        if (container == null) {
            throw new IllegalArgumentException("container");
        }
        J2EEName jeeName = metaData.getJ2EEName();
        if (jeeName != null) {
            this.appModuleNameToModuleContainer.put(jeeName.toString(), container);
        }
        this.moduleMetaDataManager.fireMetaDataCreated(metaData, container);
    }

    @Override
    public void fireModuleMetaDataDestroyed(ModuleMetaData metaData) {
        J2EEName jeeName = metaData.getJ2EEName();
        if (jeeName != null) {
            this.appModuleNameToModuleContainer.remove(jeeName.toString());
        }
        this.moduleMetaDataManager.fireMetaDataDestroyed(metaData);
    }

    public void addComponentMetaDataListener(ServiceReference<ComponentMetaDataListener> ref) {
        this.componentMetaDataManager.addListener(ref);
    }

    public void removeComponentMetaDataListener(ServiceReference<ComponentMetaDataListener> ref) {
        this.componentMetaDataManager.removeListener(ref);
    }

    @Override
    public void fireComponentMetaDataCreated(ComponentMetaData metaData) throws MetaDataException {
        J2EEName jeeName = metaData.getJ2EEName();
        if (jeeName != null) {
            this.jeeNameToComponentMetaData.put(jeeName.toString(), metaData);
        }
        this.componentMetaDataManager.fireMetaDataCreated(metaData, (Container)null);
    }

    @Override
    public void fireComponentMetaDataDestroyed(ComponentMetaData metaData) {
        J2EEName jeeName = metaData.getJ2EEName();
        if (jeeName != null) {
            this.jeeNameToComponentMetaData.remove(jeeName.toString());
        }
        this.componentMetaDataManager.fireMetaDataDestroyed(metaData);
    }

    public void addMethodMetaDataListener(ServiceReference<MethodMetaDataListener> ref) {
        this.methodMetaDataManager.addListener(ref);
    }

    public void removeMethodMetaDataListener(ServiceReference<MethodMetaDataListener> ref) {
        this.methodMetaDataManager.removeListener(ref);
    }

    @Override
    public void fireMethodMetaDataCreated(MethodMetaData metaData) throws MetaDataException {
        this.methodMetaDataManager.fireMetaDataCreated(metaData, (Container)null);
    }

    @Override
    public void fireMethodMetaDataDestroyed(MethodMetaData metaData) {
        this.methodMetaDataManager.fireMetaDataDestroyed(metaData);
    }

    @Override
    public String getMetaDataIdentifier(MetaData metaData) throws IllegalArgumentException {
        if (metaData instanceof IdentifiableComponentMetaData) {
            return ((IdentifiableComponentMetaData)((Object)metaData)).getPersistentIdentifier();
        }
        if (metaData == null) {
            return null;
        }
        throw new IllegalArgumentException(metaData.getClass().getCanonicalName());
    }

    protected void setDeferredMetaDataFactory(ServiceReference<DeferredMetaDataFactory> ref) {
        block2: {
            Object types;
            block4: {
                block3: {
                    this.deferredMetaDataFactories.addReference(ref);
                    if (!Boolean.TRUE.equals(ref.getProperty("supportsDeferredInit"))) break block2;
                    types = ref.getProperty("deferredMetaData");
                    if (!(types instanceof String)) break block3;
                    this.deferredMetaDataInitializers.putReference((Object)((String)types), ref);
                    break block2;
                }
                if (!(types instanceof String[])) break block4;
                for (String type : (String[])types) {
                    this.deferredMetaDataInitializers.putReference((Object)type, ref);
                }
                break block2;
            }
            if (!(types instanceof List)) break block2;
            for (Object type : (List)types) {
                this.deferredMetaDataInitializers.putReference((Object)((String)type), ref);
            }
        }
    }

    protected void unsetDeferredMetaDataFactory(ServiceReference<DeferredMetaDataFactory> ref) {
        block2: {
            Object types;
            block4: {
                block3: {
                    this.deferredMetaDataFactories.removeReference(ref);
                    if (!Boolean.TRUE.equals(ref.getProperty("supportsDeferredInit"))) break block2;
                    types = ref.getProperty("deferredMetaData");
                    if (!(types instanceof String)) break block3;
                    this.deferredMetaDataInitializers.removeReference((Object)((String)types), ref);
                    break block2;
                }
                if (!(types instanceof String[])) break block4;
                for (String type : (String[])types) {
                    this.deferredMetaDataInitializers.removeReference((Object)type, ref);
                }
                break block2;
            }
            if (!(types instanceof List)) break block2;
            for (Object type : (List)types) {
                this.deferredMetaDataInitializers.removeReference((Object)((String)type), ref);
            }
        }
    }

    @Override
    public MetaData getMetaData(String identifier) throws IllegalStateException {
        if (identifier == null) {
            return null;
        }
        int index = identifier.indexOf(35);
        String prefix = identifier.substring(0, index);
        String jeeName = identifier.substring(index + 1);
        ComponentMetaData cmd = this.jeeNameToComponentMetaData.get(jeeName);
        if (cmd == null) {
            Iterator iterator = this.deferredMetaDataFactories.getServicesWithReferences();
            while (cmd == null && iterator.hasNext()) {
                ServiceAndServiceReferencePair pair = (ServiceAndServiceReferencePair)iterator.next();
                Object type = pair.getServiceReference().getProperty("deferredMetaData");
                if (!prefix.equals(type) && (!(type instanceof String[]) || !Arrays.asList((String[])type).contains(prefix)) && (!(type instanceof List) || !((List)type).contains(prefix))) continue;
                DeferredMetaDataFactory factory = (DeferredMetaDataFactory)pair.getService();
                cmd = factory.createComponentMetaData(identifier);
            }
        }
        if (cmd == null) {
            throw new IllegalStateException(identifier);
        }
        DeferredMetaDataFactory deferredInitializer = (DeferredMetaDataFactory)this.deferredMetaDataInitializers.getService((Object)prefix);
        if (deferredInitializer != null) {
            deferredInitializer.initialize(cmd);
        }
        return cmd;
    }

    protected DeferredMetaDataFactory getDeferredMetaDataFactoryForPrefix(String prefix) {
        Iterator iterator = this.deferredMetaDataFactories.getServicesWithReferences();
        while (iterator.hasNext()) {
            ServiceAndServiceReferencePair pair = (ServiceAndServiceReferencePair)iterator.next();
            Object type = pair.getServiceReference().getProperty("deferredMetaData");
            if (!prefix.equals(type) && (!(type instanceof String[]) || !Arrays.asList((String[])type).contains(prefix)) && (!(type instanceof List) || !((List)type).contains(prefix))) continue;
            return (DeferredMetaDataFactory)pair.getService();
        }
        return null;
    }

    @Override
    public String getMetaDataIdentifier(String type, String appName, String moduleName, String componentName) throws IllegalArgumentException {
        DeferredMetaDataFactory factory = this.getDeferredMetaDataFactoryForPrefix(type);
        return factory != null ? factory.getMetaDataIdentifier(appName, moduleName, componentName) : null;
    }

    @Override
    public ClassLoader getClassLoader(String type, ComponentMetaData metadata) {
        DeferredMetaDataFactory factory = this.getDeferredMetaDataFactoryForPrefix(type);
        return factory != null ? factory.getClassLoader(metadata) : null;
    }

    @Override
    public boolean isMetaDataAvailable(String identifier) {
        if (identifier == null) {
            return false;
        }
        int index = identifier.indexOf(35);
        String prefix = identifier.substring(0, index);
        String jeeName = identifier.substring(index + 1);
        ComponentMetaData cmd = this.jeeNameToComponentMetaData.get(jeeName);
        if (cmd == null) {
            Iterator iterator = this.deferredMetaDataFactories.getServicesWithReferences();
            while (cmd == null && iterator.hasNext()) {
                ServiceAndServiceReferencePair pair = (ServiceAndServiceReferencePair)iterator.next();
                Object type = pair.getServiceReference().getProperty("deferredMetaData");
                if (!prefix.equals(type) && (!(type instanceof String[]) || !Arrays.asList((String[])type).contains(prefix)) && (!(type instanceof List) || !((List)type).contains(prefix))) continue;
                DeferredMetaDataFactory factory = (DeferredMetaDataFactory)pair.getService();
                cmd = factory.createComponentMetaData(identifier);
            }
        }
        return cmd != null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetaDataServiceImpl.class);
    }
}

