/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.cmdline;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.InstallProgressEvent;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.cmdline.InstallExecutor;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandTaskRegistry;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.product.utility.extension.ValidateCommandTask;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import wlp.lib.extract.SelfExtract;

public class ExeInstallAction
implements ActionHandler {
    private static final String UNSPECIFIED_LICENSE_TYPE = "UNSPECIFIED";
    private String[] featureIds;
    private Set<String> featureIdSetRaw;
    private Set<String> featureIdSet;
    private String repoType;
    private boolean acceptLicense;
    private boolean viewLicenseAgreement;
    private boolean viewLicenseInfo;
    private String eaString;
    private File localDir;
    private boolean download;
    private boolean noDirectory;
    private boolean offlineOnly = false;
    private InstallConstants.ExistsAction action = InstallConstants.ExistsAction.fail;
    private InstallConstants.DownloadOption downloadOption = InstallConstants.DownloadOption.required;
    private InstallKernel installKernel;
    private InstallEventListener ielistener;
    private Set<InstallLicense> featureLicense;
    private Logger logger;
    private int progressSteps = -1;
    private int progressCurrentStep = 0;
    private static int numOfRemoteFeatures = 0;
    private static int numOfLocalFeatures = 0;

    public ReturnCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        ReturnCode rc = this.initialize(args);
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        if (this.viewLicenseAgreement) {
            return this.viewLicense(true);
        }
        if (this.viewLicenseInfo) {
            return this.viewLicense(false);
        }
        return this.install();
    }

    private ReturnCode initialize(Arguments args) {
        this.featureIdSetRaw = new HashSet<String>(args.getPositionalArguments());
        this.featureIdSet = new HashSet<String>();
        for (String s : this.featureIdSetRaw) {
            String[] temp = s.split(",");
            this.featureIdSet.addAll(Arrays.asList(temp));
        }
        this.featureIds = this.featureIdSet.toArray(new String[this.featureIdSet.size()]);
        this.repoType = args.getOption("to");
        this.acceptLicense = args.getOption("acceptlicense") != null;
        this.viewLicenseAgreement = args.getOption("viewlicenseagreement") != null;
        this.viewLicenseInfo = args.getOption("viewlicenseinfo") != null;
        this.eaString = args.getOption("when-file-exists");
        String downloadOnly = args.getOption("downloadonly");
        this.download = downloadOnly != null;
        String directory = args.getOption("location");
        this.noDirectory = directory == null || directory.isEmpty();
        String esaLocation = this.getLocalEsaLocation(this.featureIdSet);
        this.logger = Logger.getLogger("com.ibm.ws.install");
        if (this.eaString == null && !this.download && this.noDirectory && esaLocation == null) {
            this.logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_STABILIZING_FEATUREMANAGER", "install") + "\n");
        }
        if (this.eaString != null) {
            try {
                this.action = InstallConstants.ExistsAction.valueOf(this.eaString);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, NLS.getMessage((String)"install.invalid.when.file.exists.value", (Object[])new Object[]{this.eaString}), e);
                return ReturnCode.BAD_ARGUMENT;
            }
        }
        if (this.download) {
            if (!downloadOnly.isEmpty()) {
                try {
                    this.downloadOption = InstallConstants.DownloadOption.valueOf(downloadOnly);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_INVALID_OPTION", downloadOnly), e);
                    return ReturnCode.BAD_ARGUMENT;
                }
            }
            if (this.noDirectory) {
                this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_MISSING_DIRECTORY", "--downloadOnly"));
                return ReturnCode.BAD_ARGUMENT;
            }
            this.localDir = this.getDownloadOnlyDirectory(directory);
            if (this.localDir == null) {
                return ReturnCode.IO_FAILURE;
            }
        }
        boolean bl = this.offlineOnly = args.getOption("offlineonly") != null;
        if (this.offlineOnly) {
            if (this.download) {
                this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_WITH_OFFLINEONLY", new Object[0]));
                return ReturnCode.BAD_ARGUMENT;
            }
            if (this.noDirectory) {
                this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_MISSING_DIRECTORY", "--offlineOnly"));
                return ReturnCode.BAD_ARGUMENT;
            }
        }
        if (!this.noDirectory && this.localDir == null) {
            this.localDir = new File(directory);
            if (!this.localDir.exists()) {
                this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_NOT_EXISTS", this.localDir.getAbsolutePath()));
                return ReturnCode.IO_FAILURE;
            }
        }
        this.installKernel = InstallKernelFactory.getInstance();
        this.installKernel.setUserAgent("featureManager");
        this.installKernel.addListener(this.getListener(), "PROGRESS");
        try {
            Properties repoProperties = RepositoryConfigUtils.loadRepoProperties();
            if (repoProperties != null) {
                this.installKernel.setRepositoryProperties(repoProperties);
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return InstallExecutor.returnCode(e.getRc());
        }
        try {
            if (esaLocation == null) {
                this.featureLicense = this.localDir != null && !this.download ? ((InstallKernelImpl)this.installKernel).getFeatureLicense(this.featureIdSet, this.localDir, this.repoType, this.offlineOnly, Locale.getDefault()) : this.installKernel.getFeatureLicense(this.featureIdSet, Locale.getDefault(), null, null);
            } else {
                if (this.download) {
                    this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_LOCAL_ESA", esaLocation));
                    this.removeEventListener();
                    return ReturnCode.BAD_ARGUMENT;
                }
                if (this.localDir != null) {
                    this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_LOCATION_WITH_ESA", esaLocation));
                    return ReturnCode.BAD_ARGUMENT;
                }
                this.featureLicense = ((InstallKernelImpl)this.installKernel).getLocalFeatureLicense(esaLocation, Locale.getDefault());
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.removeEventListener();
            return InstallExecutor.returnCode(e.getRc());
        }
        this.setTotalSteps();
        this.removeEventListener();
        return ReturnCode.OK;
    }

    private ReturnCode viewLicense(boolean showAgreement) {
        for (InstallLicense license : this.featureLicense) {
            if (showAgreement) {
                if (license.getAgreement() != null) {
                    this.logger.log(Level.INFO, license.getAgreement());
                }
            } else if (license.getInformation() != null) {
                this.logger.log(Level.INFO, license.getInformation());
            }
            this.logger.log(Level.INFO, "");
        }
        return ReturnCode.OK;
    }

    private String getLocalEsaLocation(Collection<String> featureIds) {
        if (featureIds.size() != 1) {
            return null;
        }
        String esa = featureIds.iterator().next();
        if (esa.indexOf(",") >= 0) {
            return null;
        }
        File esaToInstall = new File(esa);
        if (esaToInstall.exists() && esaToInstall.isFile()) {
            return esa;
        }
        try {
            new URL(esa);
            return esa;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private File getDownloadOnlyDirectory(String downloadDir) {
        File toDir = new File(downloadDir);
        if (toDir.exists()) {
            if (!toDir.isDirectory()) {
                this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_IS_FILE", toDir.getAbsolutePath()));
                return null;
            }
        } else if (!toDir.mkdirs()) {
            this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_UNABLE_TO_CREATE_DIR", toDir.getAbsolutePath()));
            return null;
        }
        return toDir;
    }

    private ReturnCode install() {
        Collection<String> installedFeatures = null;
        try {
            ReturnCode rc = this.handleLicenseAcknowledgmentAcceptance();
            if (!rc.equals((Object)ReturnCode.OK)) {
                return rc;
            }
            rc = this.handleLicenseAcceptance();
            if (!rc.equals((Object)ReturnCode.OK)) {
                return rc;
            }
            this.installKernel.addListener(this.getListener(), "PROGRESS");
            String esaLocation = this.getLocalEsaLocation(this.featureIdSet);
            if (esaLocation == null) {
                if (this.download) {
                    Collection<String> downloaded;
                    if (this.eaString == null) {
                        this.action = InstallConstants.ExistsAction.ignore;
                    }
                    this.logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage((downloaded = ((InstallKernelImpl)this.installKernel).downloadFeatureFeatureManager(this.featureIdSet, this.localDir, this.downloadOption, this.action, null, null)).size() > 1 ? "TOOL_DOWNLOAD_FEATURES_OK" : "TOOL_DOWNLOAD_FEATURE_OK", new Object[0]));
                    this.removeEventListener();
                    return ReturnCode.OK;
                }
                installedFeatures = this.localDir != null ? ((InstallKernelImpl)this.installKernel).installFeature(this.featureIdSet, this.localDir, this.repoType, true, this.action, this.offlineOnly) : this.installKernel.installFeature(this.featureIdSet, this.repoType, true, this.action, null, null);
            } else {
                if (this.download) {
                    this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_LOCAL_ESA", esaLocation));
                    this.removeEventListener();
                    return ReturnCode.BAD_ARGUMENT;
                }
                installedFeatures = ((InstallKernelImpl)this.installKernel).installLocalFeature(esaLocation, this.repoType, this.acceptLicense, this.action);
            }
        }
        catch (InstallException ie) {
            this.logger.log(ie.getRc() == 22 ? Level.INFO : Level.SEVERE, ie.getMessage(), ie);
            this.removeEventListener();
            return InstallExecutor.returnCode(ie.getRc());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.removeEventListener();
            return ReturnCode.RUNTIME_EXCEPTION;
        }
        if (installedFeatures != null && !installedFeatures.isEmpty()) {
            this.logger.log(Level.FINE, "");
            this.logger.log(Level.FINE, NLS.getMessage((String)"install.feature.ok", (Object[])new Object[]{installedFeatures.toString().replaceAll(",", " ")}));
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("TOOL_FEATURES_INSTALLATION_COMPLETED", new Object[0]));
        }
        this.validateProduct();
        this.removeEventListener();
        return ReturnCode.OK;
    }

    private void validateProduct() {
        this.logger.log(Level.INFO, "");
        BundleRepositoryRegistry.disposeAll();
        BundleRepositoryRegistry.initializeDefaults(null, (boolean)false);
        ValidateCommandTask vcTask = new ValidateCommandTask();
        vcTask.setPrintErrorOnly(true);
        vcTask.setPrintStartMessage(true);
        vcTask.doExecute(new ExecutionContext(){

            public CommandConsole getCommandConsole() {
                return new CommandConsole(){

                    public boolean isInputStreamAvailable() {
                        return false;
                    }

                    public String readMaskedText(String prompt) {
                        return null;
                    }

                    public String readText(String prompt) {
                        return null;
                    }

                    public void printInfoMessage(String message) {
                        ExeInstallAction.this.logger.log(Level.INFO, message);
                    }

                    public void printlnInfoMessage(String message) {
                        ExeInstallAction.this.logger.log(Level.INFO, message);
                    }

                    public void printErrorMessage(String errorMessage) {
                        ExeInstallAction.this.logger.log(Level.SEVERE, errorMessage);
                    }

                    public void printlnErrorMessage(String errorMessage) {
                        ExeInstallAction.this.logger.log(Level.SEVERE, errorMessage);
                    }
                };
            }

            public String[] getArguments() {
                return null;
            }

            public Set<String> getOptionNames() {
                return new HashSet<String>();
            }

            public String getOptionValue(String option) {
                return null;
            }

            public boolean optionExists(String option) {
                return false;
            }

            public CommandTaskRegistry getCommandTaskRegistry() {
                return null;
            }

            public <T> T getAttribute(String name, Class<T> cls) {
                return null;
            }

            public Object getAttribute(String name) {
                return null;
            }

            public void setAttribute(String name, Object value) {
            }

            public void setOverrideOutputStream(PrintStream outputStream) {
            }
        });
    }

    private Set<InstallLicense> getLicenseToAccept(Set<String> installedLicense, Set<InstallLicense> featureLicense) {
        HashSet<InstallLicense> licenseToAccept = new HashSet<InstallLicense>();
        if (featureLicense != null) {
            for (InstallLicense license : featureLicense) {
                if (this.isUnspecifiedType(license) || installedLicense.contains(license.getId())) continue;
                licenseToAccept.add(license);
            }
        }
        return licenseToAccept;
    }

    private boolean isUnspecifiedType(InstallLicense license) {
        return license.getType() != null && license.getType().equals(UNSPECIFIED_LICENSE_TYPE);
    }

    private String getLicenseAcknowledgment(Set<InstallLicense> featureLicense) {
        for (InstallLicense license : featureLicense) {
            if (!this.isUnspecifiedType(license)) continue;
            return license.getAgreement();
        }
        return null;
    }

    private ReturnCode handleLicenseAcknowledgmentAcceptance() {
        String licenseAcknowledgment = this.getLicenseAcknowledgment(this.featureLicense);
        if (licenseAcknowledgment != null && !licenseAcknowledgment.trim().equals("")) {
            if (this.acceptLicense) {
                SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseAccepted", (Object)"--acceptLicense"));
                this.logger.log(Level.INFO, "");
            } else {
                this.logger.log(Level.INFO, "");
                this.logger.log(Level.INFO, licenseAcknowledgment);
                this.logger.log(Level.INFO, "");
                boolean accept = SelfExtract.getResponse((String)SelfExtract.format((String)"licensePrompt", (Object[])new Object[]{"[1]", "[2]"}), (String)"1", (String)"2");
                this.logger.log(Level.INFO, "");
                if (!accept) {
                    return ReturnCode.RUNTIME_EXCEPTION;
                }
            }
        }
        return ReturnCode.OK;
    }

    private ReturnCode handleLicenseAcceptance() {
        Set<String> installedLicense = this.installKernel.getInstalledLicense();
        Set<InstallLicense> licenseToAccept = this.getLicenseToAccept(installedLicense, this.featureLicense);
        for (InstallLicense license : licenseToAccept) {
            if (this.handleLicenseAcceptance(license)) continue;
            return ReturnCode.RUNTIME_EXCEPTION;
        }
        return ReturnCode.OK;
    }

    private boolean handleLicenseAcceptance(InstallLicense licenseToAccept) {
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseStatement", (Object[])new Object[]{licenseToAccept.getProgramName(), licenseToAccept.getName()}));
        this.logger.log(Level.INFO, "");
        if (this.acceptLicense) {
            SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseAccepted", (Object)"--acceptLicense"));
            this.logger.log(Level.INFO, "");
        } else if (!this.obtainLicenseAgreement(licenseToAccept)) {
            return false;
        }
        return true;
    }

    private boolean obtainLicenseAgreement(InstallLicense license) {
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"showAgreement", (Object)"--viewLicenseAgreement"));
        boolean view = SelfExtract.getResponse((String)SelfExtract.format((String)"promptAgreement"), (String)"", (String)"xX");
        if (view) {
            this.logger.log(Level.INFO, license.getAgreement());
            this.logger.log(Level.INFO, "");
        }
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"showInformation", (Object)"--viewLicenseInfo"));
        view = SelfExtract.getResponse((String)SelfExtract.format((String)"promptInfo"), (String)"", (String)"xX");
        if (view) {
            this.logger.log(Level.INFO, license.getInformation());
            this.logger.log(Level.INFO, "");
        }
        this.logger.log(Level.INFO, "");
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseOptionDescription"));
        this.logger.log(Level.INFO, "");
        boolean accept = SelfExtract.getResponse((String)SelfExtract.format((String)"licensePrompt", (Object[])new Object[]{"[1]", "[2]"}), (String)"1", (String)"2");
        this.logger.log(Level.INFO, "");
        return accept;
    }

    private InstallEventListener getListener() {
        if (this.ielistener == null) {
            this.ielistener = new InstallEventListener(){

                @Override
                public void handleInstallEvent(InstallProgressEvent event) {
                    if (event.state != 176) {
                        if (ExeInstallAction.this.progressSteps > 0) {
                            ExeInstallAction.this.progressCurrentStep++;
                            if (ExeInstallAction.this.progressCurrentStep > ExeInstallAction.this.progressSteps) {
                                ExeInstallAction.this.progressSteps = ExeInstallAction.this.progressCurrentStep;
                            }
                            ExeInstallAction.this.logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("PROGRESS_STEP", ExeInstallAction.this.progressCurrentStep, ExeInstallAction.this.progressSteps) + ": " + event.message);
                        } else {
                            ExeInstallAction.this.logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CONTACTING_REPO", new Object[0]));
                        }
                    }
                }
            };
        }
        return this.ielistener;
    }

    public static void incrementNumOfRemoteFeatures() {
        ++numOfRemoteFeatures;
    }

    public static void incrementNumOfLocalFeatures() {
        ++numOfLocalFeatures;
    }

    private void setTotalSteps() {
        int downloadOnly;
        int constantSteps = !this.download && !this.noDirectory ? 3 : 5;
        int n = downloadOnly = this.download || !this.noDirectory ? 1 : 2;
        if (this.downloadOption.equals((Object)InstallConstants.DownloadOption.none)) {
            numOfLocalFeatures = 0;
            numOfRemoteFeatures = this.featureIds.length;
        }
        this.progressSteps = constantSteps + numOfLocalFeatures + downloadOnly * numOfRemoteFeatures;
    }

    private void removeEventListener() {
        this.logger.log(Level.INFO, "");
        this.installKernel.removeListener(this.getListener());
        this.ielistener = null;
    }
}

