/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.internal.asset.UninstallAsset;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import com.ibm.ws.product.utility.extension.ifix.xml.UpdatedFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FixDependencyChecker {
    private static final String S_DISABLE = "disable.fix.dependency.check";

    public static boolean isUninstallable(Set<IFixInfo> installedFixes, IFixInfo fixToBeUninstalled) {
        if (Boolean.valueOf(System.getenv(S_DISABLE)).booleanValue()) {
            return true;
        }
        if (fixToBeUninstalled != null) {
            for (IFixInfo fix : installedFixes) {
                if (fixToBeUninstalled.getId().equals(fix.getId()) || FixDependencyChecker.confirmNoFileConflicts(fixToBeUninstalled.getUpdates().getFiles(), fix.getUpdates().getFiles()) || FixDependencyChecker.isSupersededBy(fix.getResolves().getProblems(), fixToBeUninstalled.getResolves().getProblems())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isUninstallable(UninstallAsset uninstallAsset, Set<IFixInfo> installedFixes, List<UninstallAsset> uninstallAssets) {
        if (Boolean.valueOf(System.getenv(S_DISABLE)).booleanValue()) {
            return true;
        }
        IFixInfo fixToBeUninstalled = uninstallAsset.getIFixInfo();
        for (IFixInfo fix : installedFixes) {
            if (fixToBeUninstalled.getId().equals(fix.getId()) || FixDependencyChecker.confirmNoFileConflicts(fixToBeUninstalled.getUpdates().getFiles(), fix.getUpdates().getFiles()) || FixDependencyChecker.isSupersededBy(fix.getResolves().getProblems(), fixToBeUninstalled.getResolves().getProblems()) || this.isToBeUninstalled(fix.getId(), uninstallAssets)) continue;
            return false;
        }
        return true;
    }

    public boolean isToBeUninstalled(String name, List<UninstallAsset> list) {
        for (UninstallAsset asset : list) {
            String fixName = asset.getIFixInfo().getId();
            if (fixName == null || !fixName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean fixRequiredByFeature(String fixApar, Map<String, ProvisioningFeatureDefinition> installedFeatures) {
        for (ProvisioningFeatureDefinition fd : installedFeatures.values()) {
            String[] apars;
            String requireFixes = fd.getHeader("IBM-Require-Fix");
            if (requireFixes == null || requireFixes.length() <= 0) continue;
            for (String apar : apars = requireFixes.split(";")) {
                if (!apar.trim().equals(fixApar.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public List<UninstallAsset> determineOrder(List<UninstallAsset> list) {
        if (list != null) {
            ArrayList<FixDependencyComparator> fixCompareList = new ArrayList<FixDependencyComparator>();
            for (UninstallAsset asset : list) {
                fixCompareList.add(new FixDependencyComparator(asset.getIFixInfo()));
            }
            Collections.sort(fixCompareList, new FixDependencyComparator());
            ArrayList<UninstallAsset> newList = new ArrayList<UninstallAsset>();
            for (FixDependencyComparator f : fixCompareList) {
                newList.add(new UninstallAsset(f.getIfixInfo()));
            }
            return newList;
        }
        return list;
    }

    private static boolean isSupersededBy(List<Problem> apars1, List<Problem> apars2) {
        boolean result = true;
        Iterator<Problem> iter1 = apars1.iterator();
        while (iter1.hasNext()) {
            boolean currAparMatch = false;
            Problem currApar1 = iter1.next();
            for (Problem currApar2 : apars2) {
                if (!currApar1.getDisplayId().equals(currApar2.getDisplayId())) continue;
                currAparMatch = true;
            }
            if (currAparMatch) continue;
            result = false;
        }
        return result;
    }

    private static boolean confirmNoFileConflicts(Set<UpdatedFile> updatedFiles1, Set<UpdatedFile> updatedFiles2) {
        for (UpdatedFile currFile1 : updatedFiles1) {
            for (UpdatedFile currFile2 : updatedFiles2) {
                if (!currFile1.getId().equals(currFile2.getId())) continue;
                return false;
            }
        }
        return true;
    }

    static class FixDependencyComparator
    implements Comparator<FixDependencyComparator> {
        private IFixInfo fix;

        public FixDependencyComparator() {
        }

        public FixDependencyComparator(IFixInfo fix) {
            this.fix = fix;
        }

        @Override
        public int compare(FixDependencyComparator fix1, FixDependencyComparator fix2) {
            if (fix1.getIfixInfo().getId().equals(fix2.getIfixInfo().getId())) {
                return 0;
            }
            if (this.checkFixDependency(fix1.getIfixInfo(), fix2.getIfixInfo())) {
                return -1;
            }
            return 1;
        }

        public IFixInfo getIfixInfo() {
            return this.fix;
        }

        private boolean checkFixDependency(IFixInfo fix1, IFixInfo requiresFix2) {
            return FixDependencyChecker.confirmNoFileConflicts(fix1.getUpdates().getFiles(), requiresFix2.getUpdates().getFiles()) || FixDependencyChecker.isSupersededBy(requiresFix2.getResolves().getProblems(), fix1.getResolves().getProblems());
        }
    }
}

