/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.utility.cmdline.ReturnCode;
import com.ibm.ws.install.utility.internal.cmdline.InstallUtilityExecutor;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandTaskRegistry;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.product.utility.extension.ValidateCommandTask;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import wlp.lib.extract.SelfExtract;

public abstract class RequireAcceptLicenseAction
implements ActionHandler {
    private static final String UNSPECIFIED_LICENSE_TYPE = "UNSPECIFIED";
    protected static final Logger logger = InstallLogUtils.getInstallLogger();
    List<String> argList;
    boolean acceptLicense;
    boolean viewLicenseAgreement;
    boolean viewLicenseInfo;
    Properties repoProperties;
    InstallKernelInteractive installKernel;
    Set<InstallLicense> featureLicenses = Collections.emptySet();
    Collection<String> sampleLicenses = Collections.emptyList();

    public ReturnCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        ReturnCode rc = this.initialize(args);
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        if (this.viewLicenseAgreement) {
            return this.viewLicense(true);
        }
        if (this.viewLicenseInfo) {
            return this.viewLicense(false);
        }
        return this.execute();
    }

    ReturnCode execute() {
        ReturnCode rc = this.handleLicenseAcknowledgmentAcceptance();
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        rc = this.handleLicenseAcceptance();
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        return ReturnCode.OK;
    }

    ReturnCode initialize(Arguments args) {
        this.argList = args.getPositionalArguments();
        this.acceptLicense = args.getOption("acceptlicense") != null;
        this.viewLicenseAgreement = args.getOption("viewlicenseagreement") != null;
        this.viewLicenseInfo = args.getOption("viewlicenseinfo") != null;
        this.installKernel = InstallKernelFactory.getInteractiveInstance();
        this.installKernel.setUserAgent("installUtility");
        try {
            this.repoProperties = RepositoryConfigUtils.loadRepoProperties();
            if (this.repoProperties != null) {
                this.installKernel.setRepositoryProperties(this.repoProperties);
            }
        }
        catch (InstallException e) {
            System.out.println(e.getMessage());
            return InstallUtilityExecutor.returnCode(e.getRc());
        }
        return ReturnCode.OK;
    }

    protected ReturnCode viewLicense(boolean showAgreement) {
        for (InstallLicense license : this.featureLicenses) {
            if (showAgreement) {
                if (license.getAgreement() != null) {
                    System.out.println(license.getAgreement());
                }
            } else if (license.getInformation() != null) {
                System.out.println(license.getInformation());
            }
            System.out.println();
        }
        return ReturnCode.OK;
    }

    private Set<InstallLicense> getLicenseToAccept(Set<String> installedLicense, Set<InstallLicense> featureLicense) {
        HashSet<InstallLicense> licenseToAccept = new HashSet<InstallLicense>();
        if (featureLicense != null) {
            for (InstallLicense license : featureLicense) {
                if (this.isUnspecifiedType(license) || installedLicense.contains(license.getId())) continue;
                licenseToAccept.add(license);
            }
        }
        return licenseToAccept;
    }

    private boolean isUnspecifiedType(InstallLicense license) {
        return license.getType() != null && license.getType().equals(UNSPECIFIED_LICENSE_TYPE);
    }

    private String getLicenseAcknowledgment(Set<InstallLicense> featureLicense) {
        for (InstallLicense license : featureLicense) {
            if (!this.isUnspecifiedType(license)) continue;
            return license.getAgreement();
        }
        return null;
    }

    private ReturnCode handleLicenseAcknowledgmentAcceptance() {
        String licenseAcknowledgment = this.getLicenseAcknowledgment(this.featureLicenses);
        if (licenseAcknowledgment != null && !licenseAcknowledgment.trim().equals("")) {
            this.showMessagesForAdditionalFeatures();
            if (this.acceptLicense) {
                SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseAccepted", (Object)"--acceptLicense"));
                System.out.println();
            } else {
                System.out.println();
                System.out.println(licenseAcknowledgment);
                System.out.println();
                boolean accept = SelfExtract.getResponse((String)SelfExtract.format((String)"licensePrompt", (Object[])new Object[]{"[1]", "[2]"}), (String)"1", (String)"2");
                System.out.println();
                if (!accept) {
                    return ReturnCode.RUNTIME_EXCEPTION;
                }
            }
        }
        return ReturnCode.OK;
    }

    protected void showMessagesForAdditionalFeatures() {
    }

    protected ReturnCode handleLicenseAcceptance() {
        Set installedLicense = this.installKernel.getInstalledLicense();
        Set<InstallLicense> licenseToAccept = this.getLicenseToAccept(installedLicense, this.featureLicenses);
        if (!licenseToAccept.isEmpty()) {
            this.showMessagesForAdditionalFeatures();
        }
        for (InstallLicense license : licenseToAccept) {
            if (this.handleLicenseAcceptance(license)) continue;
            return ReturnCode.RUNTIME_EXCEPTION;
        }
        return ReturnCode.OK;
    }

    private boolean handleLicenseAcceptance(InstallLicense licenseToAccept) {
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseStatement", (Object[])new Object[]{licenseToAccept.getProgramName(), licenseToAccept.getName()}));
        System.out.println();
        if (this.acceptLicense) {
            SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseAccepted", (Object)"--acceptLicense"));
            System.out.println();
        } else if (!this.obtainLicenseAgreement(licenseToAccept)) {
            return false;
        }
        return true;
    }

    private boolean obtainLicenseAgreement(InstallLicense license) {
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"showAgreement", (Object)"--viewLicenseAgreement"));
        boolean view = SelfExtract.getResponse((String)SelfExtract.format((String)"promptAgreement"), (String)"", (String)"xX");
        if (view) {
            System.out.println(license.getAgreement());
            System.out.println();
        }
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"showInformation", (Object)"--viewLicenseInfo"));
        view = SelfExtract.getResponse((String)SelfExtract.format((String)"promptInfo"), (String)"", (String)"xX");
        if (view) {
            System.out.println(license.getInformation());
            System.out.println();
        }
        System.out.println();
        SelfExtract.wordWrappedOut((String)SelfExtract.format((String)"licenseOptionDescription"));
        System.out.println();
        boolean accept = SelfExtract.getResponse((String)SelfExtract.format((String)"licensePrompt", (Object[])new Object[]{"[1]", "[2]"}), (String)"1", (String)"2");
        System.out.println();
        return accept;
    }

    boolean validateProduct() {
        logger.log(Level.INFO, "");
        BundleRepositoryRegistry.disposeAll();
        BundleRepositoryRegistry.initializeDefaults(null, (boolean)false);
        ValidateCommandTask vcTask = new ValidateCommandTask();
        vcTask.setPrintErrorOnly(true);
        vcTask.setPrintStartMessage(true);
        vcTask.doExecute(new ExecutionContext(){

            public CommandConsole getCommandConsole() {
                return new CommandConsole(){

                    public boolean isInputStreamAvailable() {
                        return false;
                    }

                    public String readMaskedText(String prompt) {
                        return null;
                    }

                    public String readText(String prompt) {
                        return null;
                    }

                    public void printInfoMessage(String message) {
                        System.out.print(message);
                    }

                    public void printlnInfoMessage(String message) {
                        System.out.println(message);
                    }

                    public void printErrorMessage(String errorMessage) {
                        System.err.print(errorMessage);
                    }

                    public void printlnErrorMessage(String errorMessage) {
                        System.err.println(errorMessage);
                    }
                };
            }

            public String[] getArguments() {
                return null;
            }

            public Set<String> getOptionNames() {
                return new HashSet<String>();
            }

            public String getOptionValue(String option) {
                return null;
            }

            public boolean optionExists(String option) {
                return false;
            }

            public CommandTaskRegistry getCommandTaskRegistry() {
                return null;
            }

            public <T> T getAttribute(String name, Class<T> cls) {
                if (name.equals("WLP_INSTALLATION_LOCATION")) {
                    return (T)Utils.getInstallDir();
                }
                return null;
            }

            public Object getAttribute(String name) {
                return null;
            }

            public void setAttribute(String name, Object value) {
            }

            public void setOverrideOutputStream(PrintStream outputStream) {
            }
        });
        return vcTask.isSuccessful();
    }
}

