/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.pseudo.internal.PseudoContextFactory;
import com.ibm.ws.kernel.service.location.internal.VariableRegistryHelper;
import com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.lang.reflect.Field;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Activator
implements BundleActivator {
    private static final TraceComponent tc = Tr.register(Activator.class);
    protected BundleContext context = null;
    private PseudoContextFactory contextFactory;
    static final long serialVersionUID = -4492707902302007934L;

    @FFDCIgnore(value={IllegalStateException.class})
    public void start(BundleContext context) throws Exception {
        this.context = context;
        FrameworkState.isValid();
        try {
            WsLocationAdminImpl locServiceImpl = WsLocationAdminImpl.createLocations(context.getBundle(0L).getBundleContext());
            context.registerService(WsLocationAdmin.class.getName(), (Object)locServiceImpl, locServiceImpl.getServiceProps());
            VariableRegistryHelper variableRegistry = new VariableRegistryHelper();
            context.registerService(VariableRegistry.class.getName(), (Object)variableRegistry, null);
            try {
                PseudoContextFactory factory = new PseudoContextFactory();
                NamingManager.setInitialContextFactoryBuilder(factory);
                this.contextFactory = factory;
            }
            catch (IllegalStateException ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to install initialContextFactoryBuilder because it was already installed", (Object[])new Object[]{ex});
                }
            }
        }
        catch (Exception locServiceImpl) {
            FFDCFilter.processException((Throwable)locServiceImpl, (String)"com.ibm.ws.kernel.service.location.internal.Activator", (String)"68", (Object)this, (Object[])new Object[]{context});
            Tr.audit((TraceComponent)tc, (String)"frameworkShutdown", (Object[])new Object[0]);
            this.shutdownFramework();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void stop(BundleContext context) throws Exception {
        block5: {
            this.context = null;
            if (this.contextFactory != null) {
                try {
                    for (Field field : NamingManager.class.getDeclaredFields()) {
                        if (!InitialContextFactoryBuilder.class.equals(field.getType())) continue;
                        field.setAccessible(true);
                        if (field.get(null) == this.contextFactory) {
                            field.set(null, null);
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    void ex;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.location.internal.Activator", (String)"96", (Object)this, (Object[])new Object[]{context});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"Failed to uninstall initialContextFactoryBuilder", (Object[])new Object[]{ex});
                }
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    protected final void shutdownFramework() {
        try {
            Bundle bundle = this.context.getBundle("System Bundle");
            if (bundle != null) {
                bundle.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

