/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.ssh;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyPair;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyPairImpl;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SSHKeyGeneratorImpl
implements SSHKeyGenerator {
    private static final int N_RSA_KEY_LENGTH = 2048;
    public static final String ALGORITHM_RSA = "RSA";
    static final long serialVersionUID = -6910941816796650298L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private String getPublicKeyString(KeyPair keyPair, String publicKeyComment) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("ssh-rsa ");
        sb.append(new String(Base64Coder.base64Encode((byte[])this.convertPublicKeyToSSH_RSAFormat((RSAPublicKey)keyPair.getPublic())), "ASCII"));
        if (publicKeyComment != null) {
            sb.append("  ");
            sb.append(publicKeyComment);
        }
        sb.append("  ");
        sb.append("Generated on ");
        sb.append(new Date().toString());
        return sb.toString();
    }

    private byte[] addPEMLineBreaks(byte[] input) {
        int length = input.length + input.length / 76;
        byte[] b = new byte[length];
        int j = 0;
        for (int i = 0; i < input.length; ++i) {
            if (i % 76 == 0 && i != 0) {
                b[j++] = 10;
            }
            b[j++] = input[i];
        }
        return b;
    }

    private String getPrivateKeyString(KeyPair keyPair) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN RSA PRIVATE KEY-----\n");
        sb.append(new String(this.addPEMLineBreaks(Base64Coder.base64Encode((byte[])((RSAPrivateKey)keyPair.getPrivate()).getEncoded())), "ASCII"));
        sb.append("\n-----END RSA PRIVATE KEY-----");
        return sb.toString();
    }

    private byte[] convertPublicKeyToSSH_RSAFormat(RSAPublicKey rsaPublicKey) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(new byte[]{0, 0, 0, 7, 115, 115, 104, 45, 114, 115, 97});
        byte[] data = rsaPublicKey.getPublicExponent().toByteArray();
        out.write(ByteBuffer.allocate(4).putInt(data.length).array());
        out.write(data);
        data = rsaPublicKey.getModulus().toByteArray();
        out.write(ByteBuffer.allocate(4).putInt(data.length).array());
        out.write(data);
        return out.toByteArray();
    }

    @Override
    public SSHKeyPair generate(String publicKeyComment) throws NoSuchAlgorithmException, IOException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(ALGORITHM_RSA);
        generator.initialize(2048);
        KeyPair keypair = generator.genKeyPair();
        String publicKey = this.getPublicKeyString(keypair, publicKeyComment);
        String privateKey = this.getPrivateKeyString(keypair);
        return new SSHKeyPairImpl(keypair, publicKey, privateKey);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SSHKeyGeneratorImpl.class);
    }
}

