/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.security;

import com.ibm.websphere.collective.controller.CollectiveRegistrationMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.member.internal.security.HostNameResolver;
import com.ibm.ws.collective.member.security.SingletonAuthorizer;
import com.ibm.ws.collective.security.CollectiveServerCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={SingletonAuthorizer.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class SingletonAuthorizerImpl
implements SingletonAuthorizer {
    private static final TraceComponent tc = Tr.register(SingletonAuthorizerImpl.class);
    private static final String KEY_COLLECTIVE_REPOSITORY_MBEAN = "CollectiveRegistrationMBean";
    private final AtomicServiceReference<CollectiveRegistrationMBean> isCollectiveController = new AtomicServiceReference("CollectiveRegistrationMBean");
    private SubjectManager subjectManager = null;
    private HostNameResolver resolver = null;
    static final long serialVersionUID = -4581787392491047796L;

    public SingletonAuthorizerImpl() {
        this(new SubjectManager(), new HostNameResolver());
    }

    SingletonAuthorizerImpl(SubjectManager subjectManager, HostNameResolver hostNameResolver) {
        this.subjectManager = subjectManager;
        this.resolver = hostNameResolver;
    }

    @Reference(name="CollectiveRegistrationMBean", service=CollectiveRegistrationMBean.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCollectiveRepositoryMBean(ServiceReference<CollectiveRegistrationMBean> ref) {
        this.isCollectiveController.setReference(ref);
    }

    protected void unsetCollectiveRepositoryMBean(ServiceReference<CollectiveRegistrationMBean> ref) {
        this.isCollectiveController.unsetReference(ref);
    }

    @Activate
    protected void activate() {
    }

    @Deactivate
    protected void deactivate() {
    }

    public void isAuthorized(String operation) throws AccessControlException {
        Subject callerSubject = this.subjectManager.getCallerSubject();
        if (callerSubject == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Access granted.  Caller Subject is null: unauthenticated user, the server itself", (Object[])new Object[0]);
            }
            return;
        }
        Set<CollectiveServerCredential> privateCredentials = callerSubject.getPrivateCredentials(CollectiveServerCredential.class);
        CollectiveServerCredential collectiveServerCredential = null;
        if (privateCredentials.iterator().hasNext()) {
            collectiveServerCredential = privateCredentials.iterator().next();
        }
        if (privateCredentials.isEmpty() || collectiveServerCredential == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Access granted.  Caller Subject is not null, but has no collective server credential: an admin user.", (Object[])new Object[0]);
            }
            return;
        }
        boolean isCallerCollectiveController = collectiveServerCredential.isCollectiveController();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Collective member credential: isCollectiveController = " + isCallerCollectiveController), (Object[])new Object[0]);
        }
        if (isCallerCollectiveController) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Access granted. Caller Subject is not null and has a private credential of a collective controller.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.isCollectiveController.getReference() != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Access granted. Caller Subject is a member calling into a collective controller.", (Object[])new Object[0]);
            }
            return;
        }
        this.isLocalMember(collectiveServerCredential, operation);
    }

    /*
     * WARNING - void declaration
     */
    private void isLocalMember(CollectiveServerCredential collectiveServerCredential, String operation) throws AccessControlException {
        String callingHost = collectiveServerCredential.getHostName();
        if (callingHost.trim().equalsIgnoreCase("localhost") || callingHost.trim().equals("127.0.0.1")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Access granted. Caller is a member on localhost", (Object[])new Object[0]);
            }
        } else {
            try {
                String callingHostIP;
                Object targetHostObject = AccessController.doPrivileged(new PrivilegedAction<Object>(){
                    static final long serialVersionUID = -6126524167585079506L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    @FFDCIgnore(value={UnknownHostException.class})
                    public Object run() {
                        try {
                            return InetAddress.getLocalHost().getHostAddress();
                        }
                        catch (UnknownHostException e) {
                            return e;
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
                if (targetHostObject instanceof UnknownHostException) {
                    throw (UnknownHostException)targetHostObject;
                }
                String targetHost = (String)targetHostObject;
                String targetHostIP = this.resolver.getHostAddressByName(targetHost);
                if (targetHostIP.equals(callingHostIP = this.resolver.getHostAddressByName(callingHost))) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Access granted. Caller is a member on the same host as this member:  " + targetHost), (Object[])new Object[0]);
                    }
                    return;
                }
                String errorMessage = "Access is denied. The caller is a member from a different host [" + callingHost + "(" + callingHostIP + ")] than this member's host [" + targetHost + "(" + targetHostIP + ")]";
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)errorMessage, (Object[])new Object[0]);
                }
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"SINGLETON_ACCESS_DENIED", (Object[])new Object[]{operation, callingHost, targetHost});
                AccessControlException acl = new AccessControlException(msg);
                acl.fillInStackTrace();
                throw acl;
            }
            catch (UnknownHostException targetHostObject) {
                void e;
                FFDCFilter.processException((Throwable)targetHostObject, (String)"com.ibm.ws.collective.member.internal.security.SingletonAuthorizerImpl", (String)"222", (Object)this, (Object[])new Object[]{collectiveServerCredential, operation});
                String errorMessage = "Access is denied. Unable to confirm the members are on the same host due to unresolvable host: " + e.getMessage();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)errorMessage, (Object[])new Object[0]);
                }
                AccessControlException acl = new AccessControlException(errorMessage);
                acl.initCause((Throwable)e);
                acl.setStackTrace(e.getStackTrace());
                throw acl;
            }
        }
    }
}

