/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.publisher.RepositoryPublisher;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.DynamicMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EventHandler.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "event.topics=com/ibm/wsspi/collective/repository/publishStatus/mbean", "event.filter=(|(mbeanObjectName=WebSphere:feature=clusterMember,type=ClusterMember,name=ClusterMember) (mbeanAttributeName=Name))"})
public final class FeaturePublisher
implements EventHandler {
    public static final String SCALING_MEMBER_MBEAN_OBJECT_NAME = "WebSphere:feature=scalingMember,type=ScalingMember,name=ScalingMember";
    public static final String CLUSTER_MEMBER_MBEAN_OBJECT_NAME = "WebSphere:feature=clusterMember,type=ClusterMember,name=ClusterMember";
    public static final String CLUSTER_MEMBER_MBEAN_NAME_ATTRIBUTE_NAME = "Name";
    public static final String SCALING_MEMBER_CREATION_PATH = "sys.features/data/scalingMember/mode/child";
    public static final String SCALING_MEMBER_DELETION_PATH = "sys.features/data/scalingMember";
    public static final String CLUSTER_MEMBER_NAME_PATH = "sys.features/data/clusterMember/name";
    public static final String KEY_EVENT_ADMIN_REF = "eventAdmin";
    private static final TraceComponent tc = Tr.register(FeaturePublisher.class);
    private boolean serviceActivated = false;
    private boolean scalingMemberFeatureConfigured = false;
    private boolean clusterMemberFeatureConfigured = false;
    private String clusterName = "";
    private EventAdmin eventAdmin = null;
    static final String KEY_SCHEDULED_EXECUTOR_SERVICE_REF = "scheduledExecutorService";
    protected ScheduledExecutorService scheduledExecutorService;
    private FeatureProvisioner provisionerService;
    static final long serialVersionUID = -4096387294899132737L;

    @Reference(service=EventAdmin.class)
    protected void setEventAdminService(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unsetEventAdminService(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class)
    protected void setScheduledExecutorService(ScheduledExecutorService svc) {
        this.scheduledExecutorService = svc;
    }

    protected void unsetScheduledExecutorService(ScheduledExecutorService svc) {
        if (this.scheduledExecutorService == svc) {
            this.scheduledExecutorService = null;
        }
    }

    @Reference(service=RepositoryPublisher.class)
    protected void setRepositoryPublisher(ServiceReference<RepositoryPublisher> ref) {
    }

    protected void unsetRepositoryPublisher(ServiceReference<RepositoryPublisher> ref) {
    }

    @Reference(service=DynamicMBean.class, target="(jmx.objectname=WebSphere:feature=scalingMember,type=ScalingMember,name=ScalingMember)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setScalingMemberMBean(ServiceReference<DynamicMBean> ref) {
        this.scalingMemberFeatureConfigured = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The scalingMember feature was detected present in the config.", (Object[])new Object[0]);
        }
        if (this.serviceActivated && !FrameworkState.isStopping()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The scalingMember feature was detected present in the config.", (Object[])new Object[0]);
            }
            this.publishScalingMemberData(this.scalingMemberFeatureConfigured);
        }
    }

    protected void unsetScalingMemberMBean(ServiceReference<DynamicMBean> ref) {
        this.scalingMemberFeatureConfigured = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The scalingMember feature was detected absent from the config.", (Object[])new Object[0]);
        }
        if (this.serviceActivated && !FrameworkState.isStopping()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The scalingMember feature was detected present in the config.", (Object[])new Object[0]);
            }
            this.publishScalingMemberData(this.scalingMemberFeatureConfigured);
        }
    }

    @Reference(service=DynamicMBean.class, target="(jmx.objectname=WebSphere:feature=clusterMember,type=ClusterMember,name=ClusterMember)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setClusterMemberMBean(ServiceReference<DynamicMBean> ref) {
        this.clusterMemberFeatureConfigured = true;
        this.clusterName = (String)ref.getProperty(CLUSTER_MEMBER_MBEAN_NAME_ATTRIBUTE_NAME);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The clusterMember feature was detected present in the config.", (Object[])new Object[0]);
        }
        if (this.serviceActivated && !FrameworkState.isStopping()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The clusterMember feature was detected present in the config.", (Object[])new Object[0]);
            }
            this.publishClusterMemberData();
        }
    }

    protected void unsetClusterMemberMBean(ServiceReference<DynamicMBean> ref) {
        this.clusterMemberFeatureConfigured = false;
        this.clusterName = "";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The clusterMember feature was detected absent from the config.", (Object[])new Object[0]);
        }
        if (this.serviceActivated && !FrameworkState.isStopping()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The clusterMember feature was detected removed from the config.", (Object[])new Object[0]);
            }
            this.publishClusterMemberData();
        }
    }

    @Reference(service=FeatureProvisioner.class)
    protected void setKernelProvisioner(FeatureProvisioner provisionerService) {
        this.provisionerService = provisionerService;
    }

    protected void unsetKernelProvisioner(FeatureProvisioner provisionerService) {
        this.provisionerService = null;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.serviceActivated = true;
        if (this.scalingMemberFeatureConfigured) {
            this.publishScalingMemberData();
        }
        if (this.clusterMemberFeatureConfigured) {
            this.publishClusterMemberData();
        }
        Set installedFeatures = this.provisionerService.getInstalledFeatures();
        this.checkClusterMember(installedFeatures);
        this.checkScalingMember(installedFeatures);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The FeaturePublisher service is active.", (Object[])new Object[0]);
        }
    }

    private void checkClusterMember(Set<String> installedFeatures) {
        if (!this.clusterMemberFeatureConfigured && !installedFeatures.contains("clusterMember-1.0")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The clusterMember feature is not present", (Object[])new Object[0]);
            }
            this.publishClusterMemberData();
        }
    }

    private void checkScalingMember(Set<String> installedFeatures) {
        if (!this.scalingMemberFeatureConfigured && !installedFeatures.contains("scalingMember-1.0")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The scalingMember feature is not present", (Object[])new Object[0]);
            }
            this.publishScalingMemberData();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) throws Exception {
        this.serviceActivated = false;
    }

    private void publishScalingMemberData() {
        this.publishScalingMemberData(this.scalingMemberFeatureConfigured);
    }

    private void publishScalingMemberData(boolean publish) {
        String path;
        HashMap<String, String> eventProps = new HashMap<String, String>();
        if (publish) {
            eventProps.put("operation", "UPDATE");
            eventProps.put("dataValue", null);
            path = SCALING_MEMBER_CREATION_PATH;
        } else {
            eventProps.put("operation", "DELETE");
            path = SCALING_MEMBER_DELETION_PATH;
        }
        eventProps.put("sendStatusEvent", "true");
        eventProps.put("dataName", path);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Publish scalingMember data. Event properties=" + eventProps), (Object[])new Object[0]);
        }
        this.eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
    }

    private void publishClusterMemberData() {
        this.publishClusterMemberData(this.clusterMemberFeatureConfigured);
    }

    private void publishClusterMemberData(boolean publish) {
        if (publish) {
            int interval = 2;
            if ("defaultCluster".equals(this.clusterName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The clusterName is defaultCluster, delay the cluster name change publishing.", (Object[])new Object[0]);
                }
                this.scheduledExecutorService.schedule(new PublishDefaultClusterName(), 2L, TimeUnit.SECONDS);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Publish the cluster name change for clusterName = " + this.clusterName), (Object[])new Object[0]);
                }
                this.publishClusterNameChange();
            }
        } else {
            this.publishClusterNameRemove();
        }
    }

    private void doPublishDefaultClusterName() {
        Set installedFeatures = this.provisionerService.getInstalledFeatures();
        if (this.serviceActivated && !FrameworkState.isStopping()) {
            if (this.clusterMemberFeatureConfigured && installedFeatures.contains("clusterMember-1.0")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The clusterMember feature is present and publish the cluster name", (Object[])new Object[0]);
                }
                this.publishClusterNameChange();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The clusterMember feature is not present and no cluster name is published", (Object[])new Object[0]);
            }
        }
    }

    private void publishClusterNameChange() {
        HashMap<String, String> eventProps = new HashMap<String, String>();
        eventProps.put("operation", "UPDATE");
        eventProps.put("dataValue", this.clusterName);
        this.postPublishClusterMemberFeatureEvent(eventProps);
    }

    private void publishClusterNameRemove() {
        HashMap<String, String> eventProps = new HashMap<String, String>();
        eventProps.put("operation", "DELETE");
        this.postPublishClusterMemberFeatureEvent(eventProps);
    }

    private void postPublishClusterMemberFeatureEvent(Map<String, String> eventProps) {
        eventProps.put("sendStatusEvent", "true");
        eventProps.put("dataName", CLUSTER_MEMBER_NAME_PATH);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Publish clusterMember data. Event properties=" + eventProps), (Object[])new Object[0]);
        }
        this.eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
    }

    public void handleEvent(Event event) {
        if (event == null) {
            return;
        }
        Object attributeValue = event.getProperty("mbeanAttributeValue");
        String newClusterName = (String)attributeValue;
        if (!this.clusterName.equals(newClusterName)) {
            this.clusterName = newClusterName;
            if (tc.isDebugEnabled()) {
                Object objectName = event.getProperty("mbeanObjectName");
                Object attributeName = event.getProperty("mbeanAttributeName");
                Tr.debug((TraceComponent)tc, (String)("Event received, topic=" + event.getTopic() + ", objectName=" + objectName + ", attributeName=" + attributeName + ", attributeValue=" + attributeValue), (Object[])new Object[0]);
            }
            if (this.serviceActivated && !FrameworkState.isStopping()) {
                this.publishClusterMemberData(this.clusterMemberFeatureConfigured);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    final class PublishDefaultClusterName
    implements Runnable {
        static final long serialVersionUID = 2535656507521269655L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public synchronized void run() {
            FeaturePublisher.this.doPublishDefaultClusterName();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PublishDefaultClusterName.class);
        }
    }
}

