/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaspi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.JaspiService;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaspiCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(JaspiCallbackHandler.class, (String)"Security", null);
    private JaspiService jaspiService;
    static final long serialVersionUID = -5194404487149163479L;

    JaspiCallbackHandler() {
    }

    public JaspiCallbackHandler(JaspiService jaspiService) {
        this();
        this.jaspiService = jaspiService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"handle", (Object[])new Object[]{"No Callbacks received, do nothing."});
            }
            return;
        }
        try {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    this.handleCallerPrincipalCallback((CallerPrincipalCallback)callback);
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    this.handleGroupPrincipalCallback((GroupPrincipalCallback)callback);
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    this.handlePasswordValidationCallback((PasswordValidationCallback)callback);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedCallbackException, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"100", (Object)this, (Object[])new Object[]{callbacks});
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".handle"), (String)"97");
            throw e;
        }
        catch (Exception e) {
            void t;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"103", (Object)this, (Object[])new Object[]{callbacks});
            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".handle"), (String)"100");
            throw new IOException((Throwable)t);
        }
    }

    protected void handlePasswordValidationCallback(PasswordValidationCallback callback) throws RemoteException, EntryNotFoundException, CustomRegistryException {
        UserRegistry registry;
        Subject clientSubject = callback.getSubject();
        String userName = callback.getUsername();
        String password = new String(callback.getPassword());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handlePasswordValidationCallback", (Object[])new Object[]{callback, userName});
        }
        if (clientSubject != null && (registry = this.getUserRegistry()) != null) {
            if (this.checkUserPassword(userName, password, registry, registry.getRealm(), clientSubject)) {
                callback.setResult(true);
            } else {
                callback.setResult(false);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handlePasswordValidationCallback", (Object[])new Object[]{"valid password? " + callback.getResult()});
        }
    }

    protected void handleCallerPrincipalCallback(CallerPrincipalCallback callback) throws WSSecurityException {
        Subject clientSubject = callback.getSubject();
        String userName = callback.getName();
        Principal userPrincipal = callback.getPrincipal();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleCallerPrincipalCallback", (Object[])new Object[]{"user=" + userName, "principal=" + userPrincipal});
        }
        Hashtable<String, Object> credData = null;
        if (clientSubject != null) {
            credData = this.getSubjectCustomData(clientSubject);
            String securityName = null;
            if (userName == null && userPrincipal == null) {
                securityName = "UNAUTHENTICATED";
                credData.put("com.ibm.wsspi.security.cred.securityName", securityName);
            } else if (userPrincipal != null) {
                securityName = userPrincipal.getName();
                this.addUseridAndGroupsKeys(securityName, credData);
                credData.put("com.ibm.wsspi.security.cred.jaspi.principal", userPrincipal);
            } else {
                securityName = userName;
                this.addUseridAndGroupsKeys(securityName, credData);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added securityName: " + securityName), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleCallerPrincipalCallback", (Object[])new Object[]{credData});
        }
    }

    protected void handleGroupPrincipalCallback(GroupPrincipalCallback callback) throws CustomRegistryException, EntryNotFoundException, RemoteException {
        Subject clientSubject = callback.getSubject();
        Hashtable<String, Object> credData = null;
        if (clientSubject != null) {
            String[] groups = callback.getGroups();
            if (groups != null && groups.length > 0) {
                ArrayList<String> groupNames;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Group names in Callback: ", (Object[])new Object[]{Arrays.asList(groups)});
                }
                if ((groupNames = (ArrayList<String>)(credData = this.getSubjectCustomData(clientSubject)).get("com.ibm.wsspi.security.cred.groups")) == null) {
                    groupNames = new ArrayList<String>();
                    credData.put("com.ibm.wsspi.security.cred.groups", groupNames);
                }
                UserRegistry registry = this.getUserRegistry();
                for (int i = 0; i < groups.length; ++i) {
                    String group = groups[i];
                    if (group == null || group.isEmpty()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Group is null or an empty string, it has been ignored.", (Object[])new Object[0]);
                        continue;
                    }
                    String groupName = null;
                    groupName = registry != null && registry.isValidGroup(group) ? registry.getUniqueGroupId(group) : group;
                    if (!groupNames.contains(groupName)) {
                        groupNames.add(groupName);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Added groupId: " + groupName), (Object[])new Object[0]);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(groupName + " already exists in custom credential data, avoid duplicates."), (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Callback has no groups.", (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleGroupPrincipalCallback", (Object[])new Object[]{credData});
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addUseridAndGroupsKeys(String securityName, Hashtable<String, Object> credData) {
        try {
            UserRegistry registry = this.getUserRegistry();
            if (registry != null && registry.isValidUser(securityName)) {
                credData.put("com.ibm.wsspi.security.cred.userId", securityName);
                credData.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
                List groups = registry.getUniqueGroupIds(securityName);
                credData.put("com.ibm.wsspi.security.cred.groups", groups);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added userid: " + securityName + "  and groups: " + groups), (Object[])new Object[0]);
                }
            } else {
                if (registry == null) {
                    credData.put("com.ibm.wsspi.security.cred.uniqueId", "user:defaultRealm/" + securityName);
                } else {
                    credData.put("com.ibm.wsspi.security.cred.uniqueId", registry.getRealm() + "/" + securityName);
                }
                credData.put("com.ibm.wsspi.security.cred.securityName", securityName);
            }
        }
        catch (Exception registry) {
            void e;
            FFDCFilter.processException((Throwable)registry, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"267", (Object)this, (Object[])new Object[]{securityName, credData});
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".handleCallerPrincipalCallback"), (String)"245");
        }
    }

    @FFDCIgnore(value={PasswordCheckFailedException.class})
    protected boolean checkUserPassword(String user, @Sensitive String password, UserRegistry registry, String realmName, Subject clientSubject) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            String userSecurityName = registry.checkPassword(user, password);
            List groupNames = registry.getGroupsForUser(userSecurityName);
            ArrayList<String> uniqueGroups = new ArrayList<String>();
            if (groupNames != null) {
                for (String group : groupNames) {
                    uniqueGroups.add(registry.getUniqueGroupId(group));
                }
            }
            this.newCustomCredential(clientSubject, realmName, userSecurityName, uniqueGroups);
        }
        catch (PasswordCheckFailedException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkUserPassword - password is not valid.", (Object[])new Object[0]);
            }
            return false;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[5];
            objectArray[0] = user;
            objectArray[1] = "<sensitive java.lang.String>";
            objectArray[2] = registry;
            objectArray[3] = realmName;
            objectArray[4] = clientSubject;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"289", (Object)this, (Object[])objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkUserPassword - registry exception: " + e), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected Hashtable<String, Object> newCustomCredential(Subject clientSubject, String realmName, String securityName, List<?> groupList) {
        Hashtable<String, Object> credData = this.getSubjectCustomData(clientSubject);
        credData.put("com.ibm.wsspi.security.cred.realm", realmName);
        credData.put("com.ibm.wsspi.security.cred.userId", securityName);
        credData.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        if (groupList != null && !groupList.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding groups found in registry", (Object[])new Object[]{groupList});
            }
            credData.put("com.ibm.wsspi.security.cred.groups", groupList);
        } else {
            credData.put("com.ibm.wsspi.security.cred.groups", new ArrayList());
        }
        return credData;
    }

    protected Hashtable<String, Object> getSubjectCustomData(final Subject clientSubject) {
        Hashtable<String, Object> cred = this.jaspiService.getCustomCredentials(clientSubject);
        if (cred == null) {
            PrivilegedAction<Hashtable<String, Object>> action = new PrivilegedAction<Hashtable<String, Object>>(){
                static final long serialVersionUID = 7983645503625486425L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Hashtable<String, Object> run() {
                    Hashtable<String, Object> newCred = new Hashtable<String, Object>();
                    clientSubject.getPrivateCredentials().add(newCred);
                    return newCred;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            cred = AccessController.doPrivileged(action);
        }
        return cred;
    }

    /*
     * WARNING - void declaration
     */
    UserRegistry getUserRegistry() {
        UserRegistry registry;
        block2: {
            registry = null;
            try {
                registry = RegistryHelper.getUserRegistry(null);
            }
            catch (WSSecurityException wSSecurityException) {
                void e;
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.jaspi.JaspiCallbackHandler", (String)"336", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Internal error getting the user registry", (Object[])new Object[]{e});
            }
        }
        return registry;
    }
}

