/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.LogRepositoryManager;
import com.ibm.ws.logging.hpel.LogRepositoryWriter;
import java.util.LinkedList;

public class LogRepositoryWriterCBuffImpl
implements LogRepositoryWriter {
    private long maxSize = 0L;
    private long currentSize = 0L;
    private final LinkedList<CBuffRecord> buffer = new LinkedList();
    private byte[] headerBytes = null;
    private final LogRepositoryWriter dumpWriter;

    public LogRepositoryWriterCBuffImpl(LogRepositoryWriter writer) {
        this.dumpWriter = writer;
    }

    public LogRepositoryWriter getWriter() {
        return this.dumpWriter;
    }

    @Override
    public LogRepositoryManager getLogRepositoryManager() {
        return this.dumpWriter.getLogRepositoryManager();
    }

    public synchronized long getCurrentSize() {
        return this.currentSize;
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        this.currentSize = this.adjustItems(this.currentSize);
    }

    private long adjustItems(long size) {
        while (size > this.maxSize && this.buffer.size() > 0) {
            CBuffRecord old = this.buffer.removeFirst();
            size -= (long)old.bytes.length;
        }
        return size;
    }

    @Override
    public synchronized void logRecord(long timestamp, byte[] bytes) {
        this.buffer.addLast(new CBuffRecord(timestamp, bytes));
        this.currentSize = this.adjustItems(this.currentSize + (long)bytes.length);
    }

    @Override
    public synchronized void setHeader(byte[] headerBytes) {
        if (this.headerBytes == null) {
            this.headerBytes = headerBytes;
        }
    }

    @Override
    public synchronized void stop() {
        this.dumpWriter.stop();
        this.buffer.clear();
        this.currentSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpItems() {
        LinkedList<CBuffRecord> copy = new LinkedList<CBuffRecord>();
        LogRepositoryWriterCBuffImpl logRepositoryWriterCBuffImpl = this;
        synchronized (logRepositoryWriterCBuffImpl) {
            copy.addAll(this.buffer);
            this.buffer.clear();
            this.currentSize = 0L;
            if (this.headerBytes == null) {
                return;
            }
        }
        this.dumpWriter.setHeader(this.headerBytes);
        for (CBuffRecord record : copy) {
            this.dumpWriter.logRecord(record.timestamp, record.bytes);
        }
    }

    private static class CBuffRecord {
        final long timestamp;
        final byte[] bytes;

        CBuffRecord(long timestamp, byte[] bytes) {
            this.timestamp = timestamp;
            this.bytes = bytes;
        }
    }
}

