/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.utility;

import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DDLGenerationUtility {
    private static final String SCRIPT_NAME = "ddlGen";
    private static final ResourceBundle messages = ResourceBundle.getBundle("com.ibm.ws.persistence.utility.resources.UtilityMessages");
    private final PrintStream stdout;
    private final PrintStream stderr;
    private static final int RC_INVALID_OPTION = 20;
    private static final int RC_SERVER_NOT_FOUND = 21;
    private static final int RC_LOCAL_CONNECTOR_URL_NOT_FOUND = 22;
    private static final int RC_MBEAN_NOT_FOUND = 23;
    private static final int RC_MBEAN_INVALID_RESULT = 24;
    private static final int RC_UNEXPECTED_ERROR = 255;

    protected DDLGenerationUtility() {
        this(System.out, System.err);
    }

    private DDLGenerationUtility(PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    private String getMessage(String key, Object ... args) {
        String message = messages.getString(key);
        return args.length == 0 ? message : MessageFormat.format(message, args);
    }

    private File getPersistenceUtilityJar() {
        File launchHome = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ws.persistence.utility.DDLGenerationUtility");
        }
        catch (Exception e) {
            return null;
        }
        URL home = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (!home.getProtocol().equals("file")) {
            return null;
        }
        String path = PathUtils.normalize((String)home.getPath());
        launchHome = new File(path);
        return launchHome;
    }

    private String getInstallDir() {
        String installDir = System.getenv("WLP_INSTALL_DIR");
        if (installDir == null) {
            File persistenceUtilityJarFile = this.getPersistenceUtilityJar();
            installDir = persistenceUtilityJarFile == null ? System.getProperty("user.dir") + File.separator : persistenceUtilityJarFile.getParentFile().getParentFile().getAbsolutePath() + File.separator;
        } else if (!installDir.endsWith("/") && !installDir.endsWith("\\")) {
            installDir = installDir + File.separator;
        }
        return installDir;
    }

    private String getUserDir() {
        String usrDir = System.getenv("WLP_USER_DIR");
        if (usrDir == null) {
            usrDir = this.getInstallDir() + "usr" + File.separator;
        } else if (!usrDir.endsWith("/") && !usrDir.endsWith("\\")) {
            usrDir = usrDir + File.separator;
        }
        return usrDir;
    }

    private String getOutputDir() {
        String outputDir = System.getenv("WLP_OUTPUT_DIR");
        if (outputDir == null) {
            outputDir = this.getUserDir() + "servers" + File.separator;
        } else if (!outputDir.endsWith("/") && !outputDir.endsWith("\\")) {
            outputDir = outputDir + File.separator;
        }
        return outputDir;
    }

    private String getScriptUsage() {
        return this.getMessage("usage", SCRIPT_NAME, this.getMessage("action.all", new Object[0]));
    }

    private String getActions() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage("actions", new Object[0]));
        sb.append(this.getMessage("action-key.generate", new Object[0]));
        sb.append(this.getMessage("action-desc.generate", new Object[0]));
        sb.append(this.getMessage("action-key.help", new Object[0]));
        sb.append(this.getMessage("action-desc.help", new Object[0]));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected int runProgram(String[] args) {
        block55: {
            block53: {
                block54: {
                    block51: {
                        block52: {
                            block49: {
                                block50: {
                                    block47: {
                                        block48: {
                                            block45: {
                                                block46: {
                                                    block43: {
                                                        block44: {
                                                            block41: {
                                                                block42: {
                                                                    if (args == null || args.length == 0) {
                                                                        this.stdout.println(this.getScriptUsage());
                                                                        return 0;
                                                                    }
                                                                    action = args[0];
                                                                    v0 = actionTarget = args.length >= 2 ? args[1] : "";
                                                                    if (action == null || action.isEmpty() || action.toLowerCase().equals("help")) {
                                                                        if (actionTarget.isEmpty() || "help".equalsIgnoreCase(actionTarget)) {
                                                                            this.stdout.println(this.getScriptUsage());
                                                                            this.stdout.println(this.getActions());
                                                                            return 0;
                                                                        }
                                                                        if ("generate".equalsIgnoreCase(actionTarget)) {
                                                                            this.stderr.println(this.getMessage("generate.help", new Object[0]));
                                                                            return 0;
                                                                        }
                                                                        this.stderr.println(this.getMessage("action.unrecognized", new Object[]{actionTarget}));
                                                                        this.stdout.println(this.getScriptUsage());
                                                                        return 20;
                                                                    }
                                                                    if (!"generate".equalsIgnoreCase(action)) {
                                                                        this.stderr.println(this.getMessage("action.unrecognized", new Object[]{action}));
                                                                        this.stdout.println(this.getScriptUsage());
                                                                        return 20;
                                                                    }
                                                                    userDir = this.getUserDir();
                                                                    serverName = actionTarget;
                                                                    serverDirectory = new File(userDir + File.separator + "servers" + File.separator + serverName);
                                                                    if (serverName.isEmpty() || !serverDirectory.exists() || !serverDirectory.isDirectory()) {
                                                                        this.stderr.println(this.getMessage("server.not.found", new Object[]{serverName, serverDirectory.getAbsolutePath()}));
                                                                        this.stdout.println(this.getScriptUsage());
                                                                        return 21;
                                                                    }
                                                                    jmxLocalConnectorUrlFile = new File(this.getOutputDir() + serverName + File.separator + "logs" + File.separator + "state" + File.separator + "/com.ibm.ws.jmx.local.address");
                                                                    if (!jmxLocalConnectorUrlFile.exists()) {
                                                                        this.stderr.println(this.getMessage("local.connector.not.found", new Object[]{serverName}));
                                                                        return 22;
                                                                    }
                                                                    connector = null;
                                                                    br = new BufferedReader(new FileReader(jmxLocalConnectorUrlFile));
                                                                    urlString = br.readLine();
                                                                    br.close();
                                                                    if (urlString != null) break block41;
                                                                    this.stderr.println(this.getMessage("local.connector.url.empty", new Object[]{serverName}));
                                                                    var11_14 = 255;
                                                                    if (connector == null) break block42;
                                                                    try {
                                                                        connector.close();
                                                                        connector = null;
                                                                    }
                                                                    catch (Throwable var12_17) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                return var11_14;
                                                            }
                                                            url = new JMXServiceURL(urlString);
                                                            connector = JMXConnectorFactory.connect(url);
                                                            con = connector.getMBeanServerConnection();
                                                            name = new ObjectName("WebSphere:feature=persistence,type=DDLGenerationMBean,name=DDLGenerationMBean");
                                                            objects = con.queryMBeans(name, null);
                                                            if (objects == null || objects.size() <= 0) ** GOTO lbl140
                                                            i = objects.iterator();
                                                            o = i.next();
                                                            instanceName = o.getObjectName();
                                                            generateResults = (Map)con.invoke(instanceName, "generateDDL", new Object[0], new String[0]);
                                                            if (generateResults != null) break block43;
                                                            this.stderr.println(this.getMessage("mbean.null.result", new Object[0]));
                                                            var19_27 = 24;
                                                            if (connector == null) break block44;
                                                            try {
                                                                connector.close();
                                                                connector = null;
                                                            }
                                                            catch (Throwable var20_30) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        return var19_27;
                                                    }
                                                    if (!generateResults.containsKey("success")) ** GOTO lbl92
                                                    success = (Boolean)generateResults.get("success");
                                                    if (success != null && success.booleanValue()) break block45;
                                                    this.stderr.println(this.getMessage("mbean.bad.result", new Object[0]));
                                                    var20_31 = 24;
                                                    if (connector == null) break block46;
                                                    try {
                                                        connector.close();
                                                        connector = null;
                                                    }
                                                    catch (Throwable var21_36) {
                                                        // empty catch block
                                                    }
                                                }
                                                return var20_31;
                                            }
                                            break block47;
lbl92:
                                            // 1 sources

                                            this.stderr.println(this.getMessage("mbean.missing.result", new Object[0]));
                                            success = 24;
                                            if (connector == null) break block48;
                                            try {
                                                connector.close();
                                                connector = null;
                                            }
                                            catch (Throwable var20_32) {
                                                // empty catch block
                                            }
                                        }
                                        return success;
                                    }
                                    outputDirectory = null;
                                    if (!generateResults.containsKey("output.directory")) ** GOTO lbl126
                                    outputDirectory = (String)generateResults.get("output.directory");
                                    if (outputDirectory != null && outputDirectory.length() > 0) break block49;
                                    this.stderr.println(this.getMessage("mbean.missing.output.dir", new Object[0]));
                                    var20_33 = 24;
                                    if (connector == null) break block50;
                                    try {
                                        connector.close();
                                        connector = null;
                                    }
                                    catch (Throwable var21_37) {
                                        // empty catch block
                                    }
                                }
                                return var20_33;
                            }
                            this.stdout.println(this.getMessage("mbean.output.dir", new Object[]{outputDirectory}));
                            if (generateResults.containsKey("file.count") && (fileCount = (Integer)generateResults.get("file.count")) != null && fileCount == 0) {
                                this.stdout.println(this.getMessage("no.output.generated", new Object[]{serverName}));
                            }
                            break block51;
lbl126:
                            // 1 sources

                            this.stderr.println(this.getMessage("mbean.missing.output.dir", new Object[0]));
                            var20_35 = 24;
                            if (connector == null) break block52;
                            try {
                                connector.close();
                                connector = null;
                            }
                            catch (Throwable var21_38) {
                                // empty catch block
                            }
                        }
                        return var20_35;
                    }
                    break block53;
lbl140:
                    // 1 sources

                    this.stderr.println(this.getMessage("mbean.not.found", new Object[]{serverName}));
                    var15_22 = 23;
                    if (connector == null) break block54;
                    try {
                        connector.close();
                        connector = null;
                    }
                    catch (Throwable var16_24) {
                        // empty catch block
                    }
                }
                return var15_22;
            }
            if (connector != null) {
                try {
                    connector.close();
                    connector = null;
                }
                catch (Throwable br) {}
            }
            break block55;
            catch (Throwable t) {
                try {
                    this.stderr.println(this.getMessage("exception.catch", new Object[]{t.toString()}));
                    t.printStackTrace(this.stderr);
                    var10_13 = 255;
                    return var10_13;
                }
                catch (Throwable var22_39) {
                    throw var22_39;
                }
                finally {
                    if (connector != null) {
                        try {
                            connector.close();
                            connector = null;
                        }
                        catch (Throwable var11_16) {}
                    }
                }
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        DDLGenerationUtility util = new DDLGenerationUtility();
        int rc = util.runProgram(args);
        System.exit(rc);
    }
}

