/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.resource;

import com.ibm.ws.repository.resolver.internal.namespace.InstallableEntityIdentityConstants;
import com.ibm.ws.repository.resolver.internal.resource.InstallableEntityRequirement;
import com.ibm.ws.repository.resolver.internal.resource.ResourceImpl;
import java.util.Collections;
import java.util.List;
import org.osgi.resource.Requirement;

public class LpmResource
extends ResourceImpl {
    private final String resource;

    public static LpmResource createInstance(String resourceString, InstallableEntityIdentityConstants.NameAttributes attributeToMatch, String type) {
        String[] parts = resourceString.split("/");
        if (parts.length > 2) {
            throw new IllegalArgumentException("Only one \"/\" symbol is allowed in the resourceString but it was " + resourceString);
        }
        String version = null;
        if (parts.length == 2) {
            version = parts[1];
        }
        return new LpmResource(Collections.singletonList(new InstallableEntityRequirement(attributeToMatch, parts[0], version, type)), "install", resourceString);
    }

    public LpmResource(List<Requirement> requirements, String location, String resourceString) {
        super(null, requirements, location, null);
        this.resource = resourceString;
    }

    public String toString() {
        return "LpmResource [resource=" + this.resource + "]";
    }
}

