/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.resource;

import com.ibm.ws.repository.resolver.internal.namespace.InstallableEntityIdentityConstants;
import com.ibm.ws.repository.resolver.internal.resource.RequirementImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class InstallableEntityRequirement
extends RequirementImpl {
    private final Map<String, String> directives;
    private final String type;
    private final InstallableEntityIdentityConstants.NameAttributes nameAttribute;

    public InstallableEntityRequirement(String symbolicName, String type) {
        super(symbolicName);
        if (symbolicName == null) {
            throw new NullPointerException("symbolicName must not be null");
        }
        if (type == null) {
            throw new NullPointerException("Type must not be null");
        }
        this.type = type;
        this.nameAttribute = InstallableEntityIdentityConstants.NameAttributes.SYMBOLIC_NAME;
        HashMap<String, String> directives = new HashMap<String, String>();
        StringBuilder filterBuilder = new StringBuilder("(&");
        filterBuilder.append(this.createEqualityFilter("osgi.identity", symbolicName));
        filterBuilder.append(this.createEqualityFilter("type", type));
        filterBuilder.append(")");
        directives.put("filter", filterBuilder.toString());
        this.directives = Collections.unmodifiableMap(directives);
    }

    public InstallableEntityRequirement(InstallableEntityIdentityConstants.NameAttributes nameType, String nameValue, String version, String type) {
        super(nameValue);
        if (nameValue == null || nameValue.isEmpty()) {
            throw new IllegalArgumentException("The name must be set");
        }
        if (type == null) {
            throw new NullPointerException("Type must not be null");
        }
        this.type = type;
        this.nameAttribute = nameType;
        HashSet<String> filterParts = new HashSet<String>();
        nameValue = nameType == InstallableEntityIdentityConstants.NameAttributes.CASE_INSENSITIVE_SHORT_NAME ? nameValue.toLowerCase() : nameValue;
        filterParts.add(this.createEqualityFilter(nameType.getFilterAttributeName(), nameValue));
        if (version != null && !version.isEmpty()) {
            filterParts.add(this.createEqualityFilter("version", version));
        }
        filterParts.add(this.createEqualityFilter("type", type));
        StringBuilder filterBuilder = new StringBuilder();
        if (filterParts.size() > 1) {
            filterBuilder.append("(&");
        }
        for (String filterPart : filterParts) {
            filterBuilder.append(filterPart);
        }
        if (filterParts.size() > 1) {
            filterBuilder.append(")");
        }
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.put("filter", filterBuilder.toString());
        this.directives = Collections.unmodifiableMap(directives);
    }

    private String createEqualityFilter(String attributeName, String attributeValue) {
        String filter = null;
        if (attributeValue != null && !attributeValue.isEmpty()) {
            filter = "(" + attributeName + "=" + attributeValue + ")";
        }
        return filter;
    }

    public String getNamespace() {
        return "osgi.identity";
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public Object getType() {
        return this.type;
    }

    public InstallableEntityIdentityConstants.NameAttributes getNameAttribute() {
        return this.nameAttribute;
    }
}

