/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.soap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SOAPMessageContextImpl
extends WrappedMessageContext
implements SOAPMessageContext {
    private static final SAAJInInterceptor SAAJ_IN;
    private Set<String> roles = new HashSet<String>();
    static final long serialVersionUID = -6750101893384137590L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SOAPMessageContextImpl(Message m) {
        super(m, MessageContext.Scope.HANDLER);
        this.roles.add(this.getWrappedSoapMessage().getVersion().getNextRole());
    }

    public void setMessage(SOAPMessage message) {
        if (this.getWrappedMessage().getContent(Object.class) instanceof SOAPMessage) {
            this.getWrappedMessage().setContent(Object.class, (Object)message);
        } else {
            this.getWrappedMessage().setContent(SOAPMessage.class, (Object)message);
        }
    }

    public SOAPMessage getMessage() {
        Boolean outboundProperty;
        SOAPMessage message = null;
        message = this.getWrappedMessage().getContent(Object.class) instanceof SOAPMessage ? (SOAPMessage)this.getWrappedMessage().getContent(Object.class) : (SOAPMessage)this.getWrappedMessage().getContent(SOAPMessage.class);
        if (!(null != message || (outboundProperty = (Boolean)this.get("javax.xml.ws.handler.message.outbound")) != null && outboundProperty.booleanValue())) {
            SAAJ_IN.handleMessage(this.getWrappedSoapMessage());
            message = (SOAPMessage)this.getWrappedSoapMessage().getContent(SOAPMessage.class);
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getHeaders(QName name, JAXBContext context, boolean allRoles) {
        SOAPMessage msg = this.getMessage();
        try {
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            if (header == null || !header.hasChildNodes()) {
                return new Object[0];
            }
            ArrayList<Object> ret = new ArrayList<Object>();
            Iterator it = CastUtils.cast((Iterator)header.examineAllHeaderElements());
            while (it.hasNext()) {
                SOAPHeaderElement she = (SOAPHeaderElement)it.next();
                if (!allRoles && !this.roles.contains(she.getActor()) || !name.equals(she.getElementQName())) continue;
                ret.add(context.createUnmarshaller().unmarshal((Node)she));
            }
            return ret.toArray(new Object[ret.size()]);
        }
        catch (SOAPException ret) {
            void e;
            FFDCFilter.processException((Throwable)ret, (String)"org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl", (String)"106", (Object)this, (Object[])new Object[]{name, context, allRoles});
            throw new WebServiceException((Throwable)e);
        }
        catch (JAXBException e) {
            FFDCFilter.processException((Throwable)e, (String)"org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl", (String)"108", (Object)this, (Object[])new Object[]{name, context, allRoles});
            throw new WebServiceException((Throwable)e);
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    private SoapMessage getWrappedSoapMessage() {
        return (SoapMessage)this.getWrappedMessage();
    }

    @Override
    public Object get(Object key) {
        Map mp;
        Object o = super.get(key);
        if (("javax.xml.ws.http.response.headers".equals(key) || "javax.xml.ws.http.request.headers".equals(key)) && (mp = (Map)o) != null) {
            if (mp.isEmpty()) {
                return null;
            }
            if (!this.isRequestor() && this.isOutbound() && "javax.xml.ws.http.response.headers".equals(key)) {
                return null;
            }
            if (this.isRequestor() && !this.isOutbound() && "javax.xml.ws.http.request.headers".equals(key)) {
                return null;
            }
        }
        return o;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SOAPMessageContextImpl.class);
        SAAJ_IN = new SAAJInInterceptor();
    }
}

