/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.BaseCallback;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WsocReadCallback
extends BaseCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(WsocReadCallback.class);
    static final long serialVersionUID = 3832887180984324499L;

    public void complete(VirtualConnection vc, final TCPReadRequestContext rrc) {
        if (this.connLink != null) {
            this.connLink.signalReadComplete();
            ParametersOfInterest things = this.connLink.getParametersOfInterest();
            Executor executor = things.getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){
                    static final long serialVersionUID = -5755408655548079008L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        WsocReadCallback.this.completeLogic(rrc);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            } else {
                this.completeLogic(rrc);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No connection link found", (Object[])new Object[0]);
        }
    }

    protected void completeLogic(TCPReadRequestContext rrc) {
        ClassLoader originalCL = this.pushContexts();
        try {
            this.connLink.processRead(rrc);
        }
        finally {
            this.popContexts(originalCL);
        }
    }

    public void error(VirtualConnection vc, final TCPReadRequestContext rrc, final IOException ioe) {
        if (this.connLink != null) {
            ParametersOfInterest things = this.connLink.getParametersOfInterest();
            Executor executor = things.getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){
                    static final long serialVersionUID = 2215178875664751209L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        WsocReadCallback.this.errorLogic(rrc, ioe);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                });
            } else {
                this.errorLogic(rrc, ioe);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No connection link found", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void errorLogic(TCPReadRequestContext rrc, IOException ioe) {
        ClassLoader origCL;
        ClassLoader originalCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -5363634746218761797L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return WsocReadCallback.this.pushContexts();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
        boolean startAsyncRead = false;
        try {
            startAsyncRead = this.connLink.processReadErrorComplete(ioe);
            origCL = originalCL;
        }
        catch (Throwable throwable) {
            ClassLoader origCL2 = originalCL;
            AccessController.doPrivileged(new PrivilegedAction<Void>(origCL2){
                final /* synthetic */ ClassLoader val$origCL;
                static final long serialVersionUID = 3597887495265881371L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;
                {
                    this.val$origCL = classLoader;
                }

                @Override
                public Void run() {
                    WsocReadCallback.this.popContexts(this.val$origCL);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            });
            WsByteBuffer buf = rrc.getBuffer();
            if (buf != null) {
                buf.release();
            }
            throw throwable;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        WsByteBuffer buf = rrc.getBuffer();
        if (buf != null) {
            buf.release();
        }
        if (startAsyncRead) {
            this.connLink.startAsyncRead(rrc);
        }
    }

    @Override
    protected ClassLoader pushContexts() {
        this.connLink.waitReadPush();
        return super.pushContexts();
    }

    @Override
    protected void popContexts(ClassLoader originalCL) {
        super.popContexts(originalCL);
        this.connLink.notifyReadPush();
    }
}

