/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.WebSocketFactoryImpl;
import com.ibm.ws.wsoc.external.WebSocketFactory;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebSocketVersionServiceManager {
    private static final AtomicServiceReference<CHFWBundle> cfwBundleRef;
    private static final AtomicServiceReference<WebSocketFactory> websocketFactoryServiceRef;
    private static final WebSocketFactory DEFAULT_WEBSOCKET_FACTORY;
    static final long serialVersionUID = -9076721506405158784L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected synchronized void activate(ComponentContext context) {
        cfwBundleRef.activate(context);
        websocketFactoryServiceRef.activate(context);
    }

    protected synchronized void deactivate(ComponentContext context) {
        cfwBundleRef.deactivate(context);
        websocketFactoryServiceRef.deactivate(context);
    }

    protected void setChfwBundle(ServiceReference<CHFWBundle> service) {
        cfwBundleRef.setReference(service);
    }

    protected void unsetChfwBundle(ServiceReference<CHFWBundle> service) {
        cfwBundleRef.unsetReference(service);
    }

    public static ChannelFramework getCfw() {
        return ((CHFWBundle)cfwBundleRef.getServiceWithException()).getFramework();
    }

    public static WsByteBufferPoolManager getBufferPoolManager() {
        if (cfwBundleRef.getService() != null) {
            return ((CHFWBundle)cfwBundleRef.getService()).getBufferManager();
        }
        return ChannelFrameworkFactory.getBufferManager();
    }

    public static WebSocketFactory getWebSocketFactory() {
        WebSocketFactory webSocketFactory = (WebSocketFactory)websocketFactoryServiceRef.getService();
        if (webSocketFactory == null) {
            return DEFAULT_WEBSOCKET_FACTORY;
        }
        return webSocketFactory;
    }

    protected void setWebsocketFactoryService(ServiceReference<WebSocketFactory> ref) {
        websocketFactoryServiceRef.setReference(ref);
    }

    protected void unsetWebsocketFactoryService(ServiceReference<WebSocketFactory> ref) {
        websocketFactoryServiceRef.unsetReference(ref);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WebSocketVersionServiceManager.class);
        cfwBundleRef = new AtomicServiceReference("chfwBundle");
        websocketFactoryServiceRef = new AtomicServiceReference("websocketFactoryService");
        DEFAULT_WEBSOCKET_FACTORY = new WebSocketFactoryImpl();
    }
}

