/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.WsocConnLink;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SendFuture
implements Future<Void> {
    private static final TraceComponent tc = Tr.register(SendFuture.class);
    private WsocConnLink connLink = null;
    private ExecutionException executionException = null;
    private FUTURE_STATUS status = FUTURE_STATUS.INIT;
    static final long serialVersionUID = 4578099085388137900L;

    public void initialize(WsocConnLink link, FUTURE_STATUS _status) {
        this.connLink = link;
        this.status = _status;
    }

    public synchronized void notifyAllNow() {
        this.notifyAll();
    }

    public synchronized void setStatus(FUTURE_STATUS newValue) {
        this.status = newValue;
    }

    public synchronized void setStatus(FUTURE_STATUS newValue, ExecutionException _ex) {
        this.status = newValue;
        this.executionException = _ex;
    }

    public synchronized FUTURE_STATUS getStatus() {
        return this.status;
    }

    public synchronized boolean changeStatus(FUTURE_STATUS oldState, FUTURE_STATUS newState) {
        if (this.status == oldState) {
            this.status = newState;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={InterruptedException.class})
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean changed = this.changeStatus(FUTURE_STATUS.STARTED, FUTURE_STATUS.CANCEL_PENDING);
        if (!changed) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"not in right state to cancel", (Object[])new Object[0]);
            }
            return false;
        }
        boolean worked = this.connLink.cancelWriteBufferAsync();
        if (worked) {
            SendFuture sendFuture = this;
            synchronized (sendFuture) {
                try {
                    if (this.getStatus() == FUTURE_STATUS.CANCEL_PENDING) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.getStatus() == FUTURE_STATUS.CANCELLED) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized Void get() throws InterruptedException, ExecutionException {
        if (this.status == FUTURE_STATUS.DONE) {
            return null;
        }
        if (this.status == FUTURE_STATUS.CANCELLED) {
            CancellationException ce = new CancellationException();
            throw ce;
        }
        if (this.status == FUTURE_STATUS.ERROR && this.executionException != null) {
            throw this.executionException;
        }
        this.wait();
        if (this.status == FUTURE_STATUS.CANCELLED) {
            CancellationException ce = new CancellationException();
            throw ce;
        }
        if (this.executionException != null) {
            throw this.executionException;
        }
        if (this.status == FUTURE_STATUS.DONE) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"status has not DONE value", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    @FFDCIgnore(value={InterruptedException.class})
    public synchronized Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.status == FUTURE_STATUS.DONE) {
            return null;
        }
        if (this.status == FUTURE_STATUS.CANCELLED) {
            CancellationException ce = new CancellationException();
            throw ce;
        }
        if (this.status == FUTURE_STATUS.ERROR && this.executionException != null) {
            throw this.executionException;
        }
        long timeoutInMillis = unit.convert(timeout, TimeUnit.MILLISECONDS);
        this.wait(timeoutInMillis);
        if (this.status == FUTURE_STATUS.CANCELLED) {
            CancellationException ce = new CancellationException();
            throw ce;
        }
        if (this.executionException != null) {
            throw this.executionException;
        }
        if (this.status != FUTURE_STATUS.DONE && this.status != FUTURE_STATUS.ERROR) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Timeout has expired", (Object[])new Object[0]);
            }
            TimeoutException te = new TimeoutException();
            throw te;
        }
        if (this.status == FUTURE_STATUS.DONE) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("status is done enough (though not DONE) with value of: " + (Object)((Object)this.status)), (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.status == FUTURE_STATUS.CANCELLED;
    }

    @Override
    public synchronized boolean isDone() {
        return this.status == FUTURE_STATUS.DONE || this.status == FUTURE_STATUS.CANCELLED || this.status == FUTURE_STATUS.ERROR;
    }

    @Trivial
    public static enum FUTURE_STATUS {
        INIT,
        STARTED,
        CANCEL_PENDING,
        CANCELLED,
        ERROR,
        DONE;

    }
}

