/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal;

import com.ibm.websphere.application.ApplicationMBean;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.management.NotificationBroadcasterSupport;

@Trivial
public final class ApplicationConfig {
    private final String _configPid;
    private final Dictionary<String, ?> _config;
    private final String _location;
    private final String _type;
    private final String _name;
    private NotificationBroadcasterSupport _notificationBroadcasterSupport;

    public ApplicationConfig(String configPid, Dictionary<String, ?> config) {
        int index;
        this._configPid = configPid;
        this._config = config;
        this._location = (String)config.get("location");
        String type = (String)config.get("type");
        if (type == null && this._location != null && (index = this._location.lastIndexOf(46)) != -1) {
            type = this._location.substring(index + 1);
        }
        this._type = type;
        String name = (String)config.get("name");
        if ((name == null || "".equals(name)) && this._location != null) {
            int endIndex;
            int startIndex = this._location.lastIndexOf(47);
            if (startIndex == -1) {
                startIndex = this._location.lastIndexOf(92);
            }
            name = (endIndex = this._location.lastIndexOf(46)) > ++startIndex ? this._location.substring(startIndex, endIndex) : this._location.substring(startIndex);
        }
        this._name = name;
    }

    public void setMBeanNotifier(NotificationBroadcasterSupport broadcaster) {
        this._notificationBroadcasterSupport = broadcaster;
    }

    public NotificationBroadcasterSupport getMBeanNotifier() {
        return this._notificationBroadcasterSupport;
    }

    public String getLocation() {
        return this._location;
    }

    public String getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getLabel() {
        return ("rar".equals(this._type) ? "resource adapter" : "app") + " " + this._name;
    }

    public String getConfigPid() {
        return this._configPid;
    }

    public Object getConfigProperty(String propName) {
        return this._config.get(propName);
    }

    public boolean isValid() {
        String location = this.getLocation();
        String type = this.getType();
        String name = this.getName();
        return location != null && type != null && name != null;
    }

    public Hashtable<String, Object> getServiceProperties() {
        Dictionary<String, ?> config = this._config;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        for (String key : Collections.list(config.keys())) {
            result.put(key, config.get(key));
        }
        result.put("type", this.getType());
        result.put("name", this.getName());
        return result;
    }

    public String getMBeanName() {
        StringBuilder builder = new StringBuilder("WebSphere:service=");
        builder.append(ApplicationMBean.class.getName());
        builder.append(",name=");
        builder.append(this.getName());
        return builder.toString();
    }

    public boolean isAutoStarted() {
        Object result;
        Dictionary<String, ?> config = this._config;
        if (config != null && (result = config.get("autoStart")) instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }

    void describe(StringBuilder sb) {
        sb.append("app[" + this.getName() + "," + this.getType() + "]");
    }
}

