/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.internal.AbstractTask;
import com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl;
import com.ibm.ws.concurrent.internal.Utils;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.concurrent.AbortedException;
import javax.enterprise.concurrent.ManagedExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SubmittedTask<T>
extends AbstractTask<T>
implements Runnable {
    private static final TraceComponent tc = Tr.register(SubmittedTask.class);
    private Thread executionThread;
    private final Integer executionThreadLock = new Integer(0);
    private final AtomicReference<Throwable> failureRef = new AtomicReference();
    final FutureImpl future = new FutureImpl();
    private volatile boolean isResultPopulated;
    private final ManagedExecutorServiceImpl managedExecSvc;
    private final AtomicReference<T> resultRef = new AtomicReference();
    private final T runnableResult;
    final AtomicReference<State> state = new AtomicReference<State>(State.NONE);
    static final long serialVersionUID = -3826282870441014131L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubmittedTask(ManagedExecutorServiceImpl managedExecSvc, Object task, ThreadContextDescriptor threadContextDescriptor, T result) {
        super(task);
        this.managedExecSvc = managedExecSvc;
        this.runnableResult = result;
        this.threadContextDescriptor = threadContextDescriptor;
        if (this.listener != null) {
            ThreadContext suspendTranContext;
            ThreadContextProvider tranContextProvider = AccessController.doPrivileged(managedExecSvc.tranContextProviderAccessor);
            ThreadContext threadContext = suspendTranContext = tranContextProvider == null ? null : tranContextProvider.captureThreadContext(XPROPS_SUSPEND_TRAN, null);
            if (suspendTranContext != null) {
                suspendTranContext.taskStarting();
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskSubmitted", (Object[])new Object[]{managedExecSvc, task});
                }
                this.listener.taskSubmitted((Future)this.future, (ManagedExecutorService)managedExecSvc, task);
            }
            finally {
                if (suspendTranContext != null) {
                    suspendTranContext.taskStopping();
                }
            }
        }
        this.state.compareAndSet(State.NONE, State.SUBMITTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @FFDCIgnore(value={Error.class, Exception.class, RuntimeException.class, Throwable.class})
    public T call() throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.future.futureRef.get() == null) {
            Integer n = this.executionThreadLock;
            synchronized (n) {
                this.executionThread = Thread.currentThread();
            }
        }
        ArrayList contextAppliedToThread = null;
        try {
            boolean aborted;
            block69: {
                State newState;
                block67: {
                    Object f;
                    Object v;
                    block71: {
                        State newState2;
                        if (!this.state.compareAndSet(State.SUBMITTED, State.STARTING)) {
                            throw new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                        }
                        aborted = true;
                        contextAppliedToThread = this.threadContextDescriptor.taskStarting();
                        if (this.listener != null) {
                            if (trace && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)"taskStarting", (Object[])new Object[]{this.managedExecSvc, this.task});
                            }
                            this.listener.taskStarting((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task);
                        }
                        if (!State.STARTING.equals((Object)this.state.get())) break block67;
                        aborted = false;
                        Object result = ((Callable)this.task).call();
                        this.resultRef.set(result);
                        this.isResultPopulated = true;
                        v = result;
                        f = (Future)this.future.futureRef.get();
                        State state = f != null && f.isCancelled() ? State.CANCELLED : (newState2 = aborted ? State.ABORTED : State.DONE);
                        if ((this.state.compareAndSet(State.STARTING, newState2) || State.CANCELLED.equals((Object)this.state.get())) && this.listener != null) {
                            block68: {
                                boolean canceled = State.CANCELLED.equals((Object)this.state.get());
                                if (!aborted && !canceled) break block68;
                                Throwable x = this.failureRef.get();
                                if (canceled || x == null) {
                                    x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                                } else if (!(x instanceof CancellationException) && !(x instanceof AbortedException)) {
                                    x = new AbortedException(x);
                                }
                                if (trace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecSvc, this.task, x});
                                }
                                this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x);
                            }
                            try {
                                if (trace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                                }
                                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                            }
                            catch (Throwable x) {
                                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                            }
                            break block71;
                            catch (Error x) {
                                try {
                                    Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                                    this.failureRef.compareAndSet(null, x);
                                    throw x;
                                    catch (RuntimeException x2) {
                                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x2});
                                        this.failureRef.compareAndSet(null, x2);
                                        throw x2;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (trace && tc.isEventEnabled()) {
                                            Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                                        }
                                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                                        throw throwable;
                                    }
                                    catch (Throwable x3) {
                                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x3});
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                    if (contextAppliedToThread != null) {
                        this.threadContextDescriptor.taskStopping(contextAppliedToThread);
                    }
                    f = this.executionThreadLock;
                    synchronized (f) {
                        this.executionThread = null;
                        return (T)v;
                    }
                }
                Future f = (Future)this.future.futureRef.get();
                State state = f != null && f.isCancelled() ? State.CANCELLED : (newState = aborted ? State.ABORTED : State.DONE);
                if (!this.state.compareAndSet(State.STARTING, newState) && !State.CANCELLED.equals((Object)this.state.get()) || this.listener == null) throw new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                boolean canceled = State.CANCELLED.equals((Object)this.state.get());
                if (!aborted && !canceled) break block69;
                Throwable x = this.failureRef.get();
                if (canceled || x == null) {
                    x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                } else if (!(x instanceof CancellationException) && !(x instanceof AbortedException)) {
                    x = new AbortedException(x);
                }
                if (trace && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecSvc, this.task, x});
                }
                this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x);
            }
            try {
                if (trace && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                }
                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                throw new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
            }
            catch (Throwable x) {
                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
            }
            throw new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
            catch (Error x) {
                try {
                    Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                    this.failureRef.compareAndSet(null, x);
                    throw x;
                    catch (RuntimeException x4) {
                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x4});
                        this.failureRef.compareAndSet(null, x4);
                        throw x4;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (trace && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                        }
                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                        throw throwable;
                    }
                    catch (Throwable x5) {
                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x5});
                    }
                    throw throwable;
                }
            }
            catch (Exception x) {
                try {
                    Tr.error((TraceComponent)tc, (String)"CWWKC1101.task.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                    this.failureRef.compareAndSet(null, x);
                    throw x;
                    catch (Error x6) {
                        Tr.error((TraceComponent)tc, (String)"CWWKC1101.task.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x6});
                        this.failureRef.compareAndSet(null, x6);
                        throw x6;
                    }
                }
                catch (Throwable throwable) {
                    block70: {
                        State newState;
                        Future f = (Future)this.future.futureRef.get();
                        State state = f != null && f.isCancelled() ? State.CANCELLED : (newState = aborted ? State.ABORTED : State.DONE);
                        if (!this.state.compareAndSet(State.STARTING, newState)) {
                            if (!State.CANCELLED.equals((Object)this.state.get())) throw throwable;
                        }
                        if (this.listener == null) throw throwable;
                        boolean canceled = State.CANCELLED.equals((Object)this.state.get());
                        if (!aborted && !canceled) break block70;
                        Throwable x7 = this.failureRef.get();
                        if (canceled || x7 == null) {
                            x7 = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                        } else if (!(x7 instanceof CancellationException) && !(x7 instanceof AbortedException)) {
                            x7 = new AbortedException(x7);
                        }
                        if (trace && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecSvc, this.task, x7});
                        }
                        this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x7);
                    }
                    try {
                        if (trace && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                        }
                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                        throw throwable;
                    }
                    catch (Throwable x8) {
                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x8});
                        throw throwable;
                    }
                    catch (Error x9) {
                        try {
                            Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x9});
                            this.failureRef.compareAndSet(null, x9);
                            throw x9;
                            catch (RuntimeException x10) {
                                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x10});
                                this.failureRef.compareAndSet(null, x10);
                                throw x10;
                            }
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (trace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                                }
                                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                                throw throwable2;
                            }
                            catch (Throwable x11) {
                                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x11});
                            }
                            throw throwable2;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (contextAppliedToThread != null) {
                this.threadContextDescriptor.taskStopping(contextAppliedToThread);
            }
            Integer n = this.executionThreadLock;
            synchronized (n) {
                this.executionThread = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @FFDCIgnore(value={Error.class, RuntimeException.class, Throwable.class})
    public void run() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.future.futureRef.get() == null) {
            Integer n = this.executionThreadLock;
            synchronized (n) {
                this.executionThread = Thread.currentThread();
            }
        }
        ArrayList contextAppliedToThread = null;
        try {
            boolean aborted;
            block69: {
                State newState;
                block67: {
                    Object f;
                    block71: {
                        State newState2;
                        if (!this.state.compareAndSet(State.SUBMITTED, State.STARTING)) {
                            throw new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                        }
                        aborted = true;
                        contextAppliedToThread = this.threadContextDescriptor.taskStarting();
                        if (this.listener != null) {
                            if (trace && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)"taskStarting", (Object[])new Object[]{this.managedExecSvc, this.task});
                            }
                            this.listener.taskStarting((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task);
                        }
                        if (!State.STARTING.equals((Object)this.state.get())) break block67;
                        aborted = false;
                        ((Runnable)this.task).run();
                        this.resultRef.set(this.runnableResult);
                        this.isResultPopulated = true;
                        f = (Future)this.future.futureRef.get();
                        State state = f != null && f.isCancelled() ? State.CANCELLED : (newState2 = aborted ? State.ABORTED : State.DONE);
                        if ((this.state.compareAndSet(State.STARTING, newState2) || State.CANCELLED.equals((Object)this.state.get())) && this.listener != null) {
                            block68: {
                                boolean canceled = State.CANCELLED.equals((Object)this.state.get());
                                if (!aborted && !canceled) break block68;
                                Throwable x = this.failureRef.get();
                                if (canceled || x == null) {
                                    x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                                } else if (!(x instanceof CancellationException) && !(x instanceof AbortedException)) {
                                    x = new AbortedException(x);
                                }
                                if (trace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecSvc, this.task, x});
                                }
                                this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x);
                            }
                            try {
                                if (trace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                                }
                                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                            }
                            catch (Throwable x) {
                                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                            }
                            break block71;
                            catch (Error x) {
                                try {
                                    Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                                    this.failureRef.compareAndSet(null, x);
                                    throw x;
                                    catch (RuntimeException x2) {
                                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x2});
                                        this.failureRef.compareAndSet(null, x2);
                                        throw x2;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (trace && tc.isEventEnabled()) {
                                            Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                                        }
                                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                                        throw throwable;
                                    }
                                    catch (Throwable x3) {
                                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x3});
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                    if (contextAppliedToThread != null) {
                        this.threadContextDescriptor.taskStopping(contextAppliedToThread);
                    }
                    f = this.executionThreadLock;
                    synchronized (f) {
                        this.executionThread = null;
                        return;
                    }
                }
                Future f = (Future)this.future.futureRef.get();
                State state = f != null && f.isCancelled() ? State.CANCELLED : (newState = aborted ? State.ABORTED : State.DONE);
                if (!this.state.compareAndSet(State.STARTING, newState) && !State.CANCELLED.equals((Object)this.state.get()) || this.listener == null) throw new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                boolean canceled = State.CANCELLED.equals((Object)this.state.get());
                if (!aborted && !canceled) break block69;
                Throwable x = this.failureRef.get();
                if (canceled || x == null) {
                    x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                } else if (!(x instanceof CancellationException) && !(x instanceof AbortedException)) {
                    x = new AbortedException(x);
                }
                if (trace && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecSvc, this.task, x});
                }
                this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x);
            }
            try {
                if (trace && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                }
                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                throw new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
            }
            catch (Throwable x) {
                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
            }
            throw new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
            catch (Error x) {
                try {
                    Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                    this.failureRef.compareAndSet(null, x);
                    throw x;
                    catch (RuntimeException x4) {
                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x4});
                        this.failureRef.compareAndSet(null, x4);
                        throw x4;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (trace && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                        }
                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                        throw throwable;
                    }
                    catch (Throwable x5) {
                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x5});
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException x) {
                try {
                    Tr.error((TraceComponent)tc, (String)"CWWKC1101.task.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                    this.failureRef.compareAndSet(null, x);
                    throw x;
                    catch (Error x6) {
                        Tr.error((TraceComponent)tc, (String)"CWWKC1101.task.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x6});
                        this.failureRef.compareAndSet(null, x6);
                        throw x6;
                    }
                }
                catch (Throwable throwable) {
                    block70: {
                        State newState;
                        Future f = (Future)this.future.futureRef.get();
                        State state = f != null && f.isCancelled() ? State.CANCELLED : (newState = aborted ? State.ABORTED : State.DONE);
                        if (!this.state.compareAndSet(State.STARTING, newState)) {
                            if (!State.CANCELLED.equals((Object)this.state.get())) throw throwable;
                        }
                        if (this.listener == null) throw throwable;
                        boolean canceled = State.CANCELLED.equals((Object)this.state.get());
                        if (!aborted && !canceled) break block70;
                        Throwable x7 = this.failureRef.get();
                        if (canceled || x7 == null) {
                            x7 = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                        } else if (!(x7 instanceof CancellationException) && !(x7 instanceof AbortedException)) {
                            x7 = new AbortedException(x7);
                        }
                        if (trace && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecSvc, this.task, x7});
                        }
                        this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x7);
                    }
                    try {
                        if (trace && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                        }
                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                        throw throwable;
                    }
                    catch (Throwable x8) {
                        Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x8});
                        throw throwable;
                    }
                    catch (Error x9) {
                        try {
                            Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x9});
                            this.failureRef.compareAndSet(null, x9);
                            throw x9;
                            catch (RuntimeException x10) {
                                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x10});
                                this.failureRef.compareAndSet(null, x10);
                                throw x10;
                            }
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (trace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, this.failureRef});
                                }
                                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, this.failureRef.get());
                                throw throwable2;
                            }
                            catch (Throwable x11) {
                                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x11});
                            }
                            throw throwable2;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (contextAppliedToThread != null) {
                this.threadContextDescriptor.taskStopping(contextAppliedToThread);
            }
            Integer n = this.executionThreadLock;
            synchronized (n) {
                this.executionThread = null;
                throw throwable;
            }
        }
    }

    @Trivial
    class FutureImpl
    implements Future<T> {
        private final AtomicReference<Future<T>> futureRef = new AtomicReference();

        FutureImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled;
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)SubmittedTask.this, (TraceComponent)tc, (String)"cancel", (Object[])new Object[]{mayInterruptIfRunning});
            }
            boolean cancelStartedTask = false;
            if (!(SubmittedTask.this.state.compareAndSet(State.NONE, State.CANCELLED) || SubmittedTask.this.state.compareAndSet(State.SUBMITTED, State.CANCELLED) || (cancelStartedTask = SubmittedTask.this.state.compareAndSet(State.STARTING, State.CANCELLED)))) {
                canceled = false;
            } else {
                try {
                    Future future = this.futureRef.get();
                    if (future != null) {
                        future.cancel(mayInterruptIfRunning);
                    } else if (mayInterruptIfRunning) {
                        Integer n = SubmittedTask.this.executionThreadLock;
                        synchronized (n) {
                            if (SubmittedTask.this.executionThread != null) {
                                Thread threadToInterrupt = SubmittedTask.this.executionThread;
                                if (!SubmittedTask.this.executionThread.equals(Thread.currentThread())) {
                                    SubmittedTask.this.executionThread = null;
                                }
                                AccessController.doPrivileged(new InterruptAction(threadToInterrupt));
                            }
                        }
                    }
                    if (!cancelStartedTask && SubmittedTask.this.listener != null) {
                        ThreadContext suspendTranContext;
                        ThreadContextProvider tranContextProvider = AccessController.doPrivileged(((SubmittedTask)SubmittedTask.this).managedExecSvc.tranContextProviderAccessor);
                        ThreadContext threadContext = suspendTranContext = tranContextProvider == null ? null : tranContextProvider.captureThreadContext(AbstractTask.XPROPS_SUSPEND_TRAN, null);
                        if (suspendTranContext != null) {
                            suspendTranContext.taskStarting();
                        }
                        try {
                            CancellationException x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{SubmittedTask.this.getName(), ((SubmittedTask)SubmittedTask.this).managedExecSvc.name}));
                            if (trace && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{SubmittedTask.this.managedExecSvc, SubmittedTask.this.task, x});
                            }
                            SubmittedTask.this.listener.taskAborted((Future)this, (ManagedExecutorService)SubmittedTask.this.managedExecSvc, SubmittedTask.this.task, (Throwable)x);
                        }
                        catch (RuntimeException failure) {
                            try {
                                SubmittedTask.this.failureRef.compareAndSet(null, failure);
                                throw failure;
                                catch (Error failure2) {
                                    SubmittedTask.this.failureRef.compareAndSet(null, failure2);
                                    throw failure2;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (trace && tc.isEventEnabled()) {
                                        Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{SubmittedTask.this.managedExecSvc, SubmittedTask.this.task, SubmittedTask.this.failureRef});
                                    }
                                    SubmittedTask.this.listener.taskDone((Future)this, (ManagedExecutorService)SubmittedTask.this.managedExecSvc, SubmittedTask.this.task, (Throwable)SubmittedTask.this.failureRef.get());
                                    throw throwable;
                                }
                                finally {
                                    if (suspendTranContext != null) {
                                        suspendTranContext.taskStopping();
                                    }
                                }
                            }
                        }
                        try {
                            if (trace && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{SubmittedTask.this.managedExecSvc, SubmittedTask.this.task, SubmittedTask.this.failureRef});
                            }
                            SubmittedTask.this.listener.taskDone((Future)this, (ManagedExecutorService)SubmittedTask.this.managedExecSvc, SubmittedTask.this.task, (Throwable)SubmittedTask.this.failureRef.get());
                        }
                        finally {
                            if (suspendTranContext != null) {
                                suspendTranContext.taskStopping();
                            }
                        }
                    }
                    canceled = true;
                }
                catch (Error x) {
                    if (!trace) throw x;
                    if (!tc.isEntryEnabled()) throw x;
                    Tr.exit((Object)SubmittedTask.this, (TraceComponent)tc, (String)"cancel", (Object)Utils.toString(x));
                    throw x;
                }
                catch (RuntimeException x) {
                    if (!trace) throw x;
                    if (!tc.isEntryEnabled()) throw x;
                    Tr.exit((Object)SubmittedTask.this, (TraceComponent)tc, (String)"cancel", (Object)Utils.toString(x));
                    throw x;
                }
            }
            if (!trace) return canceled;
            if (!tc.isEntryEnabled()) return canceled;
            Tr.exit((Object)SubmittedTask.this, (TraceComponent)tc, (String)"cancel", (Object)canceled);
            return canceled;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)SubmittedTask.this, (TraceComponent)tc, (String)"get", (Object[])new Object[0]);
            }
            Throwable x = (Throwable)SubmittedTask.this.failureRef.get();
            State s = SubmittedTask.this.state.get();
            if (s == State.CANCELLED) {
                x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{SubmittedTask.this.getName(), ((SubmittedTask)SubmittedTask.this).managedExecSvc.name}));
            } else if (s == State.ABORTED && x != null) {
                x = new AbortedException(x);
            } else if (x == null) {
                try {
                    Future future = this.futureRef.get();
                    Object result = null;
                    if (SubmittedTask.this.isResultPopulated) {
                        result = SubmittedTask.this.resultRef.get();
                    } else if (future != null) {
                        result = future.get();
                    } else {
                        x = new InterruptedException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1120.future.get.rejected", (Object[])new Object[0]));
                    }
                    if (x == null) {
                        if (trace && tc.isEntryEnabled()) {
                            Tr.exit((Object)SubmittedTask.this, (TraceComponent)tc, (String)"get", result);
                        }
                        return result;
                    }
                }
                catch (ExecutionException xx) {
                    x = SubmittedTask.this.state.get() == State.ABORTED ? new AbortedException(xx.getCause()) : xx;
                }
                catch (Throwable t) {
                    x = t;
                }
            } else if (x instanceof InterruptedException) {
                x = new ExecutionException(x);
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)SubmittedTask.this, (TraceComponent)tc, (String)"get", (Object)Utils.toString(x));
            }
            if (x instanceof CancellationException) {
                throw (CancellationException)x;
            }
            if (x instanceof ExecutionException) {
                throw (ExecutionException)x;
            }
            if (x instanceof InterruptedException) {
                throw (InterruptedException)x;
            }
            throw new ExecutionException(x);
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)SubmittedTask.this, (TraceComponent)tc, (String)"get", (Object[])new Object[]{timeout, unit});
            }
            Throwable x = (Throwable)SubmittedTask.this.failureRef.get();
            State s = SubmittedTask.this.state.get();
            if (s == State.CANCELLED) {
                x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{SubmittedTask.this.getName(), ((SubmittedTask)SubmittedTask.this).managedExecSvc.name}));
            } else if (s == State.ABORTED && x != null) {
                x = new AbortedException(x);
            } else if (x == null) {
                try {
                    Future future = this.futureRef.get();
                    Object result = null;
                    if (SubmittedTask.this.isResultPopulated) {
                        result = SubmittedTask.this.resultRef.get();
                    } else if (future != null) {
                        result = future.get(timeout, unit);
                    } else {
                        x = new InterruptedException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1120.future.get.rejected", (Object[])new Object[0]));
                    }
                    if (x == null) {
                        if (trace && tc.isEntryEnabled()) {
                            Tr.exit((Object)SubmittedTask.this, (TraceComponent)tc, (String)"get", result);
                        }
                        return result;
                    }
                }
                catch (ExecutionException xx) {
                    x = SubmittedTask.this.state.get() == State.ABORTED ? new AbortedException(xx.getCause()) : xx;
                }
                catch (Throwable t) {
                    x = t;
                }
            } else if (x instanceof InterruptedException) {
                x = new ExecutionException(x);
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)SubmittedTask.this, (TraceComponent)tc, (String)"get", (Object)Utils.toString(x));
            }
            if (x instanceof CancellationException) {
                throw (CancellationException)x;
            }
            if (x instanceof ExecutionException) {
                throw (ExecutionException)x;
            }
            if (x instanceof InterruptedException) {
                throw (InterruptedException)x;
            }
            if (x instanceof TimeoutException) {
                throw (TimeoutException)x;
            }
            throw new ExecutionException(x);
        }

        public final int hashCode() {
            return SubmittedTask.this.hashCode();
        }

        @Override
        public boolean isCancelled() {
            switch (SubmittedTask.this.state.get()) {
                case CANCELLED: {
                    return true;
                }
                case DONE: 
                case ABORTED: {
                    return false;
                }
            }
            Future future = this.futureRef.get();
            return future != null && future.isCancelled() && (this.cancel(false) || SubmittedTask.this.state.get() == State.CANCELLED);
        }

        @Override
        public boolean isDone() {
            State s = SubmittedTask.this.state.get();
            return s == State.DONE || s == State.ABORTED || this.isCancelled();
        }

        void set(Future<T> future) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)SubmittedTask.this, (TraceComponent)tc, (String)"set", (Object[])new Object[]{future});
            }
            this.futureRef.set(future);
        }
    }

    @Trivial
    private static class InterruptAction
    implements PrivilegedAction<Void> {
        private final Thread executionThread;

        private InterruptAction(Thread executionThread) {
            this.executionThread = executionThread;
        }

        @Override
        public Void run() {
            this.executionThread.interrupt();
            return null;
        }
    }

    @Trivial
    private static enum State {
        NONE,
        SUBMITTED,
        STARTING,
        CANCELLED,
        ABORTED,
        DONE;

    }
}

