/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.monitor.meters;

import com.ibm.websphere.monitor.meters.CounterMXBean;
import com.ibm.websphere.monitor.meters.CounterReading;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

@Trivial
public final class Counter
extends com.ibm.websphere.monitor.jmx.Counter
implements CounterMXBean {
    private final AtomicLong terminatedThreadOffset = new AtomicLong();
    private final Set<ValueReference> allReferences = Collections.synchronizedSet(new HashSet());
    private final ReferenceQueue<Value> valueReferenceQueue = new ReferenceQueue();
    private final ThreadLocal<Value> threadValue = new ThreadLocal<Value>(){
        static final long serialVersionUID = -1056881348043509516L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Value initialValue() {
            Value v = new Value();
            Counter.this.allReferences.add(new ValueReference(v));
            Counter.this.cleanup();
            return v;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getCurrentValue() {
        long currentValue = this.terminatedThreadOffset.get();
        Set<ValueReference> set = this.allReferences;
        synchronized (set) {
            for (ValueReference vr : this.allReferences) {
                if ((currentValue += vr.getValue()) >= 0L) continue;
                currentValue += Long.MIN_VALUE;
            }
        }
        this.cleanup();
        return currentValue;
    }

    public long getDifference(long oldValue) {
        long difference = this.getCurrentValue() - oldValue;
        if (difference < 0L) {
            difference += Long.MIN_VALUE;
        }
        this.cleanup();
        return difference;
    }

    public void incrementBy(long increment) {
        if (increment < 0L) {
            throw new IllegalArgumentException("Counters must be monotonically increasing");
        }
        this.threadValue.get().longValue.value += increment;
    }

    private void cleanup() {
        ValueReference vr = null;
        while ((vr = (ValueReference)this.valueReferenceQueue.poll()) != null) {
            this.terminatedThreadOffset.addAndGet(vr.getValue());
            this.allReferences.remove(vr);
        }
    }

    @Override
    public CounterReading getReading() {
        return new CounterReading(this.getCurrentValue(), this.getUnit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("current value = ").append(this.getCurrentValue());
        return sb.toString();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    private static final class Value {
        LongValue longValue = new LongValue();
        static final long serialVersionUID = 5411693790446593618L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Value() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Value.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    private final class ValueReference
    extends WeakReference<Value> {
        final LongValue valueObject;
        static final long serialVersionUID = -7114543657782538273L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ValueReference(Value value) {
            super(value, Counter.this.valueReferenceQueue);
            this.valueObject = value.longValue;
        }

        long getValue() {
            return this.valueObject.value;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ValueReference.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    private static final class LongValue {
        long value;
        static final long serialVersionUID = 4020843691939588079L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private LongValue() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LongValue.class);
        }
    }
}

