/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.ras;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ThreadLocalStack;
import com.ibm.ws.sib.utils.ras.AllAfterFirstSimilarInsertsSuppressor;
import com.ibm.ws.sib.utils.ras.AllAfterFirstSuppressor;
import com.ibm.ws.sib.utils.ras.AllForAWhileSimilarInsertsSuppressor;
import com.ibm.ws.sib.utils.ras.AllForAWhileSuppressor;
import com.ibm.ws.sib.utils.ras.SibMessage;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.List;

public class SibTr {
    private static ThreadLocalStack<String> threadLocalStack = new ThreadLocalStack();
    private static final String DEFAULT_ME_NAME = ":";
    public static final int MAX_TO_FORMAT = 0x100000;
    private static final String ls = System.getProperty("line.separator");
    private static final String DEAD_CHAR = ".";

    public static String getMEName(Object o) {
        if (!threadLocalStack.isEmpty()) {
            String meName = threadLocalStack.peek();
        } else {
            String meName = DEFAULT_ME_NAME;
        }
        String str = "";
        if (o != null) {
            str = "/" + Integer.toHexString(System.identityHashCode(o));
        }
        return "";
    }

    private static String getFullClassName(TraceComponent tc) {
        return "(" + tc.getName() + ")";
    }

    public static void push(Object jsme) {
        Class<?> klass = jsme.getClass();
        try {
            Method getBusName = klass.getMethod("getBusName", new Class[0]);
            Method getName = klass.getMethod("getName", new Class[0]);
            String bus = (String)getBusName.invoke(jsme, new Object[0]);
            String name = (String)getName.invoke(jsme, new Object[0]);
            threadLocalStack.push(bus + DEFAULT_ME_NAME + name);
        }
        catch (Exception e) {
            SibTr.exception(Tr.register(SibTr.class, (String)"", (String)""), e);
        }
    }

    public static void pop() {
        threadLocalStack.pop();
    }

    public static TraceComponent register(Class<?> aClass, String group, String resourceBundleName) {
        return Tr.register(aClass, (String)group, (String)resourceBundleName);
    }

    public static final void audit(TraceComponent tc, String msgKey) {
        SibTr.audit(tc, msgKey, null);
    }

    public static final void audit(TraceComponent tc, String msgKey, Object objs) {
        SibMessage.audit(SibTr.getMEName(null), tc, msgKey, objs);
    }

    public static final void debug(TraceComponent tc, String msg) {
        SibTr.debug(null, tc, msg);
    }

    public static final void debug(TraceComponent tc, String msg, Object objs) {
        SibTr.debug(null, tc, msg, objs);
    }

    public static final void debug(Object o, TraceComponent tc, String msg) {
        Tr.debug((TraceComponent)tc, (String)(SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o) + " " + msg), (Object[])new Object[0]);
    }

    public static final void debug(Object o, TraceComponent tc, String msg, Object objs) {
        Tr.debug((TraceComponent)tc, (String)(SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o) + " " + msg), (Object[])new Object[]{objs});
    }

    public static final void dump(TraceComponent tc, String msg) {
        SibTr.dump(null, tc, msg);
    }

    public static final void dump(TraceComponent tc, String msg, Object objs) {
        SibTr.dump(null, tc, msg, objs);
    }

    public static final void dump(Object o, TraceComponent tc, String msg) {
        Tr.dump((TraceComponent)tc, (String)(SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o) + " " + msg), (Object[])new Object[0]);
    }

    public static final void dump(Object o, TraceComponent tc, String msg, Object objs) {
        Tr.dump((TraceComponent)tc, (String)(SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o) + " " + msg), (Object[])new Object[]{objs});
    }

    public static final void error(TraceComponent tc, String msgKey) {
        SibTr.error(tc, msgKey, null);
    }

    public static final void error(TraceComponent tc, String msgKey, Object objs) {
        SibMessage.error(SibTr.getMEName(null), tc, msgKey, objs);
    }

    public static final void error(TraceComponent tc, Suppressor s, String msgKey) {
        SibTr.error(tc, s, msgKey, null);
    }

    public static final void error(TraceComponent tc, Suppressor s, String msgKey, Object objs) {
        SibMessage.SuppressableError(s, SibTr.getMEName(null), tc, msgKey, objs);
    }

    public static final void event(TraceComponent tc, String msg) {
        SibTr.event(null, tc, msg);
    }

    public static final void event(TraceComponent tc, String msg, Object objs) {
        SibTr.event(null, tc, msg, objs);
    }

    public static final void event(Object o, TraceComponent tc, String msg) {
        Tr.event((TraceComponent)tc, (String)(SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o) + " " + msg), (Object[])new Object[0]);
    }

    public static final void event(Object o, TraceComponent tc, String msg, Object objs) {
        Tr.event((TraceComponent)tc, (String)(SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o) + " " + msg), (Object[])new Object[]{objs});
    }

    public static final void entry(TraceComponent tc, String methodName) {
        SibTr.entry(null, tc, methodName);
    }

    public static final void entry(TraceComponent tc, String methodName, Object obj) {
        SibTr.entry(null, tc, methodName, obj);
    }

    public static final void entry(Object o, TraceComponent tc, String methodName) {
        Tr.entry((TraceComponent)tc, (String)(methodName + " " + SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o)), (Object[])new Object[0]);
    }

    public static final void entry(Object o, TraceComponent tc, String methodName, Object obj) {
        Tr.entry((TraceComponent)tc, (String)(methodName + " " + SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o)), (Object[])new Object[]{obj});
    }

    public static final void exit(TraceComponent tc, String methodName) {
        SibTr.exit(null, tc, methodName);
    }

    public static final void exit(TraceComponent tc, String methodName, Object objs) {
        SibTr.exit(null, tc, methodName, objs);
    }

    public static final void exit(Object o, TraceComponent tc, String methodName) {
        Tr.exit((TraceComponent)tc, (String)(methodName + " " + SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o)));
    }

    public static final void exit(Object o, TraceComponent tc, String methodName, Object objs) {
        Tr.exit((TraceComponent)tc, (String)(methodName + " " + SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o)), (Object)objs);
    }

    public static final void fatal(TraceComponent tc, String msgKey) {
        SibTr.fatal(tc, msgKey, null);
    }

    public static final void fatal(TraceComponent tc, String msgKey, Object objs) {
        SibMessage.fatal(SibTr.getMEName(null), tc, msgKey, objs);
    }

    public static final void info(TraceComponent tc, String msgKey) {
        SibTr.info(tc, msgKey, null);
    }

    public static final void info(TraceComponent tc, String msgKey, Object objs) {
        SibMessage.info(SibTr.getMEName(null), tc, msgKey, objs);
    }

    public static final void info(TraceComponent tc, Suppressor s, String msgKey) {
        SibTr.info(tc, s, msgKey, null);
    }

    public static final void info(TraceComponent tc, Suppressor s, String msgKey, Object objs) {
        SibMessage.SuppressableInfo(s, SibTr.getMEName(null), tc, msgKey, objs);
    }

    public static final void service(TraceComponent tc, String msgKey) {
        SibTr.service(tc, msgKey, null);
    }

    public static final void service(TraceComponent tc, String msgKey, Object objs) {
        SibMessage.service(SibTr.getMEName(null), tc, msgKey, objs);
    }

    public static final void warning(TraceComponent tc, String msgKey) {
        SibTr.warning(tc, msgKey, null);
    }

    public static final void warning(TraceComponent tc, String msgKey, Object objs) {
        SibMessage.warning(SibTr.getMEName(null), tc, msgKey, objs);
    }

    public static final void warning(TraceComponent tc, Suppressor s, String msgKey) {
        SibTr.warning(tc, s, msgKey, null);
    }

    public static final void warning(TraceComponent tc, Suppressor s, String msgKey, Object objs) {
        SibMessage.SuppressableWarning(s, SibTr.getMEName(null), tc, msgKey, objs);
    }

    private static String pad(String s, int l) {
        return SibTr.pad(s, l, null);
    }

    private static String pad(String s, int l, String p) {
        String rc;
        if (p == null) {
            p = "0";
        }
        if (s.length() < l) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < l - s.length(); ++i) {
                sb.append(p);
            }
            rc = sb.toString() + s;
        } else {
            rc = s.substring(s.length() - l);
        }
        return rc;
    }

    private static String dup(int i) {
        return "                          " + i + " duplicate line(s) suppressed" + ls;
    }

    public static void bytes(TraceComponent tc, byte[] data) {
        int length = 0;
        if (data != null) {
            length = data.length;
        }
        SibTr.bytes(null, tc, data, 0, length, "");
    }

    public static void bytes(Object o, TraceComponent tc, byte[] data) {
        int length = 0;
        if (data != null) {
            length = data.length;
        }
        SibTr.bytes(o, tc, data, 0, length, "");
    }

    public static void bytes(TraceComponent tc, byte[] data, int start) {
        int length = 0;
        if (data != null) {
            length = data.length;
        }
        SibTr.bytes(null, tc, data, start, length, "");
    }

    public static void bytes(Object o, TraceComponent tc, byte[] data, int start) {
        int length = 0;
        if (data != null) {
            length = data.length;
        }
        SibTr.bytes(o, tc, data, start, length, "");
    }

    public static void bytes(TraceComponent tc, byte[] data, int start, int count) {
        SibTr.bytes(null, tc, data, start, count, "");
    }

    public static void bytes(Object o, TraceComponent tc, byte[] data, int start, int count) {
        SibTr.bytes(o, tc, data, start, count, "");
    }

    public static void bytes(TraceComponent tc, byte[] data, int start, int count, String comment) {
        SibTr.bytes(null, tc, data, start, count, comment);
    }

    public static void bytes(Object o, TraceComponent tc, byte[] data, int start, int count, String comment) {
        StringBuffer sb = new StringBuffer();
        if (comment == null) {
            comment = "";
        }
        sb.append(SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o) + " " + comment + ls);
        if (data != null) {
            sb.append(SibTr.formatBytes(data, start, count));
        } else {
            sb.append("data is null");
        }
        Tr.debug((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
    }

    public static String formatSlice(DataSlice slice) {
        StringBuilder sb = new StringBuilder(256);
        SibTr.formatSliceToSB(sb, slice, Integer.MAX_VALUE);
        return sb.toString();
    }

    private static void formatSliceToSB(StringBuilder sb, DataSlice slice, int max) {
        if (slice != null) {
            if (slice.getBytes() != null) {
                SibTr.formatBytesToSB(sb, slice.getBytes(), slice.getOffset(), slice.getLength(), true, max);
            } else {
                sb.append("empty slice" + ls);
            }
        } else {
            sb.append("slice is null" + ls);
        }
    }

    public static String formatSlices(List<DataSlice> slices) {
        return SibTr.formatSlices(slices, 0x100000);
    }

    public static String formatSlices(List<DataSlice> slices, int max) {
        if (slices != null) {
            StringBuilder builder = new StringBuilder();
            if (slices.size() != 0) {
                int number = 1;
                int sliceCount = slices.size();
                for (DataSlice slice : slices) {
                    builder.append("List<DataSlice>@");
                    builder.append(Integer.toHexString(System.identityHashCode(slices)));
                    builder.append(" Slice ");
                    builder.append(number++);
                    builder.append(" of ");
                    builder.append(sliceCount);
                    builder.append(" :" + ls + "  ");
                    SibTr.formatSliceToSB(builder, slice, max);
                    builder.append(ls);
                }
            } else {
                builder.append("List<DataSlice>@");
                builder.append(Integer.toHexString(System.identityHashCode(slices)));
                builder.append(" has no slices");
            }
            return builder.toString();
        }
        return "List<DataSlice> is null";
    }

    public static String formatBytes(byte[] data) {
        if (data != null) {
            return SibTr.formatBytes(data, 0, data.length, true);
        }
        return "";
    }

    public static String formatBytes(byte[] data, int start, int count) {
        return SibTr.formatBytes(data, start, count, true);
    }

    public static String formatBytes(byte[] data, int start, int count, int max) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(ls);
        SibTr.formatBytesToSB(sb, data, start, count, true, max);
        return sb.toString();
    }

    public static String formatBytes(byte[] data, int start, int count, boolean displayCharRepresentations) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(ls);
        SibTr.formatBytesToSB(sb, data, start, count, true, count);
        return sb.toString();
    }

    private static void formatBytesToSB(StringBuilder sb, byte[] data, int start, int countRequested, boolean displayCharRepresentations, int max) {
        int count;
        if (max > 0x100000) {
            max = 0x100000;
        }
        int n = count = countRequested <= max + 16 ? countRequested : max;
        if (data != null) {
            int len = data.length;
            sb.append("Array length = 0x" + Integer.toHexString(len) + " (" + len + "), displaying bytes from " + start + " for " + count);
            if (count < countRequested) {
                sb.append(" (" + countRequested + " bytes requested)");
            }
            sb.append(ls + ls);
            if (displayCharRepresentations) {
                sb.append("        offset        : 0 1 2 3  4 5 6 7  8 9 A B  C D E F     0 2 4 6 8 A C E " + ls);
            } else {
                sb.append("        offset        : 0 1 2 3  4 5 6 7  8 9 A B  C D E F" + ls);
            }
            int suppress = 0;
            int end = start + count;
            String[] c = new String[16];
            String[] p = new String[16];
            String[] str = new String[16];
            for (int j = 0; j < 16; ++j) {
                c[j] = null;
                str[j] = null;
            }
            for (int i = 0; i < len; i += 16) {
                int j;
                boolean skip = true;
                for (j = 0; j < 16; ++j) {
                    int t = i + j;
                    if (t >= start && t < end && t < len) {
                        c[j] = SibTr.pad(Integer.toHexString(data[t]), 2);
                        str[j] = c[j].equalsIgnoreCase("00") || c[j].equalsIgnoreCase("09") || c[j].equalsIgnoreCase("0a") || c[j].equalsIgnoreCase("0b") || c[j].equalsIgnoreCase("0c") || c[j].equalsIgnoreCase("0d") || c[j].equalsIgnoreCase("07") ? DEAD_CHAR : new String(data, t, 1);
                        skip = false;
                        continue;
                    }
                    c[j] = "  ";
                    str[j] = DEAD_CHAR;
                }
                if (skip) {
                    if (suppress > 0) {
                        sb.append(SibTr.dup(suppress));
                    }
                    suppress = 0;
                    c[0] = null;
                    continue;
                }
                if (c[0].equals(p[0]) && c[1].equals(p[1]) && c[2].equals(p[2]) && c[3].equals(p[3]) && c[4].equals(p[4]) && c[5].equals(p[5]) && c[6].equals(p[6]) && c[7].equals(p[7]) && c[8].equals(p[8]) && c[9].equals(p[9]) && c[10].equals(p[10]) && c[11].equals(p[11]) && c[12].equals(p[12]) && c[13].equals(p[13]) && c[14].equals(p[14]) && c[15].equals(p[15])) {
                    ++suppress;
                    continue;
                }
                if (suppress > 0) {
                    sb.append(SibTr.dup(suppress));
                }
                sb.append("0x" + SibTr.pad(Integer.toHexString(i), 8) + " (" + SibTr.pad(Integer.valueOf(i).toString(), 8, " ") + ") : ");
                sb.append(c[0] + c[1] + c[2] + c[3] + " " + c[4] + c[5] + c[6] + c[7] + " " + c[8] + c[9] + c[10] + c[11] + " " + c[12] + c[13] + c[14] + c[15]);
                if (displayCharRepresentations) {
                    sb.append("  | ");
                    sb.append(str[0] + str[1] + str[2] + str[3] + str[4] + str[5] + str[6] + str[7] + str[8] + str[9] + str[10] + str[11] + str[12] + str[13] + str[14] + str[15]);
                }
                sb.append(ls);
                for (j = 0; j < 16; ++j) {
                    p[j] = c[j];
                }
                suppress = 0;
            }
            if (suppress > 0) {
                sb.append(SibTr.dup(suppress));
            }
        }
        if (count < countRequested) {
            sb.append("Suppressed remaining " + (countRequested - count) + " bytes." + ls);
        }
    }

    public static void exception(TraceComponent tc, Exception e) {
        SibTr.exception(null, tc, (Throwable)e);
    }

    public static void exception(Object o, TraceComponent tc, Exception e) {
        SibTr.exception(o, tc, (Throwable)e);
    }

    public static void exception(TraceComponent tc, Throwable t) {
        SibTr.exception(null, tc, t);
    }

    public static void exception(Object o, TraceComponent tc, Throwable t) {
        StringBuffer sb = new StringBuffer();
        sb.append(SibTr.getFullClassName(tc) + " " + SibTr.getMEName(o) + " Tracing exception:" + ls);
        if (t != null) {
            CharArrayWriter caw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(caw);
            t.printStackTrace(pw);
            pw.flush();
            sb.append(caw.toString());
        } else {
            sb.append("exception argument was null");
        }
        Tr.event((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
    }

    public static interface Suppressor {
        public static final Suppressor ALL_AFTER_FIRST = new AllAfterFirstSuppressor();
        public static final Suppressor ALL_AFTER_FIRST_SIMILAR_INSERTS = new AllAfterFirstSimilarInsertsSuppressor();
        public static final Suppressor ALL_FOR_A_WHILE = new AllForAWhileSuppressor();
        public static final Suppressor ALL_FOR_A_WHILE_SIMILAR_INSERTS = new AllForAWhileSimilarInsertsSuppressor();

        public Decision suppress(String var1, String var2);

        public static class Decision {
            private final String _number;
            private final String _variant;
            private boolean _suppressThisMessage;
            private boolean _reportEarlierSuppressedMessages;
            private boolean _suppressFutureMessages;
            private int _suppressed;
            private long _firstSuppressed;
            private long _lastSuppressed;
            private int _suppressionMinutes;
            public static final int INFINITE = -1;

            private Decision(String number, String variant) {
                this._number = number;
                this._variant = variant;
                this._suppressThisMessage = false;
                this._reportEarlierSuppressedMessages = false;
                this._suppressFutureMessages = false;
                this._suppressed = 0;
                this._firstSuppressed = 0L;
                this._lastSuppressed = 0L;
                this._suppressionMinutes = 0;
            }

            public static Decision makeDecision(String messageNumber) {
                return new Decision(messageNumber, null);
            }

            public static Decision makeDecision(String messageNumber, String variant) {
                return new Decision(messageNumber, variant);
            }

            public void suppressThisMessage() {
                this._suppressThisMessage = true;
            }

            public void reportEarlierSuppressedMessages(int numberSuppressed, long first, long last) {
                this._reportEarlierSuppressedMessages = true;
                this._suppressed = numberSuppressed;
                this._firstSuppressed = first;
                this._lastSuppressed = last;
            }

            public void suppressFutureMesages(int minutes) {
                this._suppressFutureMessages = true;
                this._suppressionMinutes = minutes;
            }

            public void emitSuppressedMessagesMessageIfNecessary(TraceComponent tc) {
                if (this._reportEarlierSuppressedMessages) {
                    DateFormat format = DateFormat.getDateTimeInstance();
                    if (this._variant == null) {
                        if (this._suppressed == 1) {
                            Tr.info((TraceComponent)tc, (String)"A_MESSAGE_SUPPRESSED_EARLIER_CWSIU0101", (Object[])new Object[]{this._number, format.format(this._lastSuppressed)});
                        } else {
                            Tr.info((TraceComponent)tc, (String)"MESSAGES_SUPPRESSED_EARLIER_CWSIU0102", (Object[])new Object[]{this._number, this._suppressed, format.format(this._firstSuppressed), format.format(this._lastSuppressed)});
                        }
                    } else if (this._suppressed == 1) {
                        Tr.info((TraceComponent)tc, (String)"SOME_A_MESSAGE_SUPPRESSED_EARLIER_CWSIU0103", (Object[])new Object[]{this._variant, format.format(this._lastSuppressed)});
                    } else {
                        Tr.info((TraceComponent)tc, (String)"SOME_MESSAGES_SUPPRESSED_EARLIER_CWSIU0104", (Object[])new Object[]{this._variant, this._suppressed, format.format(this._firstSuppressed), format.format(this._lastSuppressed)});
                    }
                }
            }

            public boolean isSuppressThisMessage() {
                return this._suppressThisMessage;
            }

            public void emitSuppressingFollowingMessagesMessageIfNecessary(TraceComponent tc) {
                if (this._suppressFutureMessages) {
                    if (this._variant == null) {
                        if (this._suppressionMinutes != -1) {
                            Tr.info((TraceComponent)tc, (String)"FUTURE_MESSAGES_SUPPRESSED_CWSIU0002", (Object[])new Object[]{this._number, this._suppressionMinutes});
                        } else {
                            Tr.info((TraceComponent)tc, (String)"ALL_MESSAGES_SUPPRESSED_CWSIU0003", (Object[])new Object[]{this._number});
                        }
                    } else if (this._suppressionMinutes != -1) {
                        Tr.info((TraceComponent)tc, (String)"SOME_FUTURE_MESSAGES_SUPPRESSED_CWSIU0005", (Object[])new Object[]{this._variant, this._suppressionMinutes});
                    } else {
                        Tr.info((TraceComponent)tc, (String)"SOME_ALL_MESSAGES_SUPPRESSED_CWSIU0006", (Object[])new Object[]{this._variant});
                    }
                }
            }
        }
    }
}

