/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.collections.linkedlist;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.collections.linkedlist.Link;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LinkedList {
    private static TraceComponent tc = SibTr.register(LinkedList.class, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    private final Link _dummyHead = new Link();
    private final Link _dummyTail = new Link();

    public LinkedList() {
        this._dummyHead._setAsHead(this, this._dummyTail);
        this._dummyTail._setAsTail(this, this._dummyHead);
    }

    final String _debugString() {
        StringBuffer buf = new StringBuffer();
        Link link = this._dummyHead;
        link._shortDebugString(buf);
        int limit = 10;
        for (link = link._getNextLink(); null != link && 0 < limit--; link = link._getNextLink()) {
            buf.append(",");
            link._shortDebugString(buf);
        }
        return buf.toString();
    }

    public final void append(Link link) {
        this.insertLinkBefore(link, this._dummyTail);
    }

    public final int countLinks() {
        int count = 0;
        for (Link look = this._dummyHead._getNextLink(); null != look && this._dummyTail != look; look = look._getNextLink()) {
            ++count;
        }
        return count;
    }

    public final Link getDummyHead() {
        return this._dummyHead;
    }

    public final Link getHead() {
        return this.getNextLink(null);
    }

    public final synchronized Link getNextLink(Link after) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getNextLink", after);
        }
        Link replyLink = null;
        for (replyLink = null == after ? this._dummyHead.getNextPhysicalLink() : after.getNextPhysicalLink(); null != replyLink && replyLink.isLogicallyUnlinked(); replyLink = replyLink.getNextPhysicalLink()) {
        }
        if (this._dummyTail == replyLink) {
            replyLink = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getNextLink", replyLink);
        }
        return replyLink;
    }

    public final synchronized void insertLinkBefore(Link insertLink, Link followingLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "insertLinkBefore", new long[]{insertLink.getSequence(), followingLink.getSequence()});
        }
        Link prev = followingLink._getPreviousLink();
        insertLink._link(prev, followingLink, this);
        prev._setNextLink(insertLink);
        followingLink._setPreviousLink(insertLink);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "insertLinkBefore", this._debugString());
        }
    }
}

