/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EventLocalMap<K, V> {
    private static final int SIZE_ROW = 16;
    private static final int SIZE_TABLE = 1;
    private static final Object NO_VALUE;
    private EventLocalMap<K, V> parentMap;
    private K[] keys = null;
    private V[][] values = null;
    static final long serialVersionUID = 2834162412476080287L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public EventLocalMap() {
        this.parentMap = null;
    }

    public EventLocalMap(EventLocalMap<K, V> parent) {
        this.parentMap = parent;
    }

    public void clear() {
        this.parentMap = null;
        if (null != this.values) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = null;
            }
            this.values = null;
        }
    }

    public V get(String name) {
        V rc = null;
        K key = this.getKey(name);
        if (null != key) {
            rc = this.get(key);
        }
        return rc;
    }

    private K getKey(String name) {
        if (null != this.keys) {
            K[] temp = this.keys;
            for (int i = 0; i < temp.length; ++i) {
                K key = temp[i];
                if (null == key || !name.equals(key.toString())) continue;
                return key;
            }
        }
        if (null != this.parentMap) {
            return super.getKey(name);
        }
        return null;
    }

    public V get(K key) {
        return this.get(key.hashCode() / 16, key.hashCode() % 16);
    }

    private V get(int row, int column) {
        if (null == this.values || row >= this.values.length || null == this.values[row] || NO_VALUE == this.values[row][column]) {
            if (null != this.parentMap) {
                return super.get(row, column);
            }
            return null;
        }
        return this.values[row][column];
    }

    public void put(K key, V value) {
        int hash = key.hashCode();
        int row = hash / 16;
        int column = hash & 0xF;
        this.validateKey(hash);
        this.validateTable(row);
        this.values[row][column] = value;
        this.keys[hash] = key;
    }

    public V remove(K key) {
        int hash = key.hashCode();
        int row = hash / 16;
        int column = hash & 0xF;
        V rc = this.get(row, column);
        this.validateKey(hash);
        this.validateTable(row);
        this.values[row][column] = null;
        this.keys[hash] = null;
        return rc;
    }

    private void validateKey(int index) {
        int size = index + 1;
        if (null == this.keys) {
            this.keys = new Object[size];
        } else if (index >= this.keys.length) {
            Object[] newKeys = new Object[size];
            System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
            this.keys = newKeys;
        }
    }

    private void validateTable(int targetRow) {
        int size;
        if (null == this.values) {
            size = targetRow + 1;
            if (1 > size) {
                size = 1;
            }
            this.values = new Object[size][];
        } else if (targetRow >= this.values.length) {
            size = targetRow + 1;
            Object[][] newTable = new Object[size][];
            System.arraycopy(this.values, 0, newTable, 0, this.values.length);
            this.values = newTable;
        } else if (null != this.values[targetRow]) {
            return;
        }
        this.values[targetRow] = new Object[16];
        for (int i = 0; i < 16; ++i) {
            this.values[targetRow][i] = NO_VALUE;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(EventLocalMap.class);
        NO_VALUE = new Object();
    }
}

