/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.compression;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.http.channel.compression.CompressionHandler;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class GzipOutputHandler
implements CompressionHandler {
    private static final TraceComponent tc = Tr.register(GzipOutputHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final byte[] GZIP_Header = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private Deflater deflater = null;
    private boolean haveWrittenHeader = false;
    private boolean bIsXGzip = false;
    private CRC32 checksum = new CRC32();
    private byte[] buf = new byte[32768];

    public GzipOutputHandler(boolean isXGzip) {
        this.deflater = new Deflater(-1, true);
        this.bIsXGzip = isXGzip;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created " + (isXGzip ? "x-gzip" : "gzip") + " output handler; " + this), (Object[])new Object[0]);
        }
    }

    private List<WsByteBuffer> writeHeader(List<WsByteBuffer> list) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Writing gzip header information", (Object[])new Object[0]);
        }
        WsByteBuffer hdr = HttpDispatcher.getBufferManager().allocateDirect(GZIP_Header.length);
        hdr.put(GZIP_Header);
        hdr.flip();
        list.add(hdr);
        this.haveWrittenHeader = true;
        return list;
    }

    @Override
    public List<WsByteBuffer> compress(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("compress, input=" + buffer), (Object[])new Object[0]);
        }
        List<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        if (!this.haveWrittenHeader) {
            list = this.writeHeader(list);
        }
        list = this.compress(list, buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("compress, return list of size " + list.size()));
        }
        return list;
    }

    @Override
    public List<WsByteBuffer> compress(WsByteBuffer[] buffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("compress, input=" + buffers), (Object[])new Object[0]);
        }
        List<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        if (!this.haveWrittenHeader) {
            list = this.writeHeader(list);
        }
        if (null != buffers) {
            for (int i = 0; i < buffers.length; ++i) {
                list = this.compress(list, buffers[i]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("compress, return list of size " + list.size()));
        }
        return list;
    }

    protected List<WsByteBuffer> compress(List<WsByteBuffer> list, WsByteBuffer buffer) {
        if (null == buffer) {
            return list;
        }
        int dataSize = buffer.remaining();
        if (0 == dataSize) {
            return list;
        }
        byte[] input = null;
        int initOffset = 0;
        if (buffer.hasArray()) {
            input = buffer.array();
            initOffset = buffer.arrayOffset() + buffer.position();
            buffer.position(buffer.limit());
        } else {
            input = new byte[dataSize];
            buffer.get(input);
        }
        this.checksum.update(input, initOffset, dataSize);
        this.deflater.setInput(input, initOffset, dataSize);
        int offset = 0;
        while (!this.deflater.needsInput()) {
            int len = this.deflater.deflate(this.buf, offset, this.buf.length - offset);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Compressed amount=" + len + " read=" + this.deflater.getBytesRead() + " written=" + this.deflater.getBytesWritten()), (Object[])new Object[0]);
            }
            if (0 == len) break;
            if ((offset += len) != this.buf.length) continue;
            list.add(this.makeBuffer(offset));
            offset = 0;
        }
        if (0 < offset) {
            list.add(this.makeBuffer(offset));
        }
        return list;
    }

    private WsByteBuffer makeBuffer(int len) {
        WsByteBuffer buffer = HttpDispatcher.getBufferManager().allocateDirect(len);
        buffer.put(this.buf, 0, len);
        buffer.flip();
        return buffer;
    }

    @Override
    public ContentEncodingValues getContentEncoding() {
        if (this.bIsXGzip) {
            return ContentEncodingValues.XGZIP;
        }
        return ContentEncodingValues.GZIP;
    }

    @Override
    public List<WsByteBuffer> finish() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finish", (Object[])new Object[0]);
        }
        LinkedList<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        if (this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"finish, previously finished");
            }
            return list;
        }
        WsByteBuffer buffer = null;
        this.deflater.finish();
        while (!this.deflater.finished()) {
            int num = this.deflater.deflate(this.buf, 0, this.buf.length);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Compressed amount=" + num + " read=" + this.deflater.getBytesRead() + " written=" + this.deflater.getBytesWritten()), (Object[])new Object[0]);
            }
            if (0 >= num) continue;
            buffer = this.makeBuffer(num);
            list.add(buffer);
        }
        this.writeInt((int)this.checksum.getValue(), this.buf, 0);
        this.writeInt((int)this.deflater.getBytesRead(), this.buf, 4);
        this.deflater.end();
        if (null != buffer && buffer.capacity() - buffer.limit() >= 8) {
            buffer.position(buffer.limit());
            buffer.limit(buffer.capacity());
            buffer.put(this.buf, 0, 8);
            buffer.flip();
        } else {
            WsByteBuffer trailer = HttpDispatcher.getBufferManager().allocateDirect(8);
            trailer.put(this.buf, 0, 8);
            trailer.flip();
            list.add(trailer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finish, return list of size " + list.size()));
        }
        return list;
    }

    @Override
    public boolean isFinished() {
        return this.deflater.finished();
    }

    @Override
    public long getBytesRead() {
        return this.deflater.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.deflater.getBytesWritten();
    }

    private void writeInt(int value, byte[] data, int offset) {
        int index = offset;
        data[index++] = (byte)(value & 0xFF);
        data[index++] = (byte)(value >> 8 & 0xFF);
        data[index++] = (byte)(value >> 16 & 0xFF);
        data[index++] = (byte)(value >> 24 & 0xFF);
    }
}

