/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.internal.values.AccessLogData;
import com.ibm.ws.http.channel.internal.values.AccessLogElapsedRequestTime;
import com.ibm.ws.http.channel.internal.values.AccessLogLocalIP;
import com.ibm.ws.http.channel.internal.values.AccessLogLocalPort;
import com.ibm.ws.http.channel.internal.values.AccessLogStartTime;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.logging.internal.LoggerOffThread;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.logging.AccessLog;
import com.ibm.wsspi.http.logging.AccessLogForwarder;
import com.ibm.wsspi.http.logging.AccessLogRecordData;
import com.ibm.wsspi.http.logging.LogForwarderManager;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.ibm.ws.http.log.access"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={AccessLogger.class}, property={"service.vendor=IBM"})
public class AccessLogger
extends LoggerOffThread
implements AccessLog {
    private static final String PROP_MAXFILES = "maxFiles";
    private static final String PROP_MAXFILESIZE = "maxFileSize";
    private static final String PROP_LOGFORMAT = "logFormat";
    private static final String PROP_FILEPATH = "filePath";
    private static final String PROP_ENABLED = "enabled";
    private static final TraceComponent tc = Tr.register(AccessLogger.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int LOGSIZE_MODIFIER = 0x100000;
    private static final String newLine = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    private volatile Map<String, Object> config;
    private AccessLog.Format myFormat = AccessLog.Format.COMMON;
    private String stringFormat = null;
    private FormatSegment[] parsedFormat;

    public AccessLogger() {
    }

    public AccessLogger(String filename) throws FileNotFoundException {
        super(filename);
    }

    @Activate
    protected void activate(ComponentContext ctx, Map<String, Object> config) {
        this.modified(config);
        this.start();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        this.stop();
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.config = config;
        this.configure();
    }

    private synchronized void configure() {
        Map<String, Object> config = this.config;
        if (config == null) {
            return;
        }
        boolean enabled = Boolean.valueOf(config.get(PROP_ENABLED).toString());
        String filename = config.get(PROP_FILEPATH).toString();
        try {
            String value;
            block13: {
                String logFormat;
                if (!filename.equals(this.getFilePathName())) {
                    this.setFilename(filename);
                }
                if (!(logFormat = config.get(PROP_LOGFORMAT).toString()).equals(this.getFormatString())) {
                    this.setFormatString(logFormat);
                }
                value = config.get(PROP_MAXFILESIZE).toString();
                try {
                    long maximumSize = Long.valueOf(value);
                    this.setMaximumSize(maximumSize * 0x100000L);
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".modified"), (String)PROP_MAXFILESIZE);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block13;
                    Tr.event((TraceComponent)tc, (String)("Config: invalid access size: " + value), (Object[])new Object[0]);
                }
            }
            value = config.get(PROP_MAXFILES).toString();
            try {
                int maximumBackups = Integer.valueOf(value);
                this.setMaximumBackupFiles(maximumBackups);
            }
            catch (NumberFormatException nfe) {
                FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".modified"), (String)PROP_MAXFILES);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Config: invalid access max files: " + value), (Object[])new Object[0]);
                }
            }
        }
        catch (FileNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".modified"), (String)"name", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: invalid access log name [" + filename + "]"), (Object[])new Object[0]);
            }
            enabled = false;
        }
        if (enabled) {
            this.start();
        } else {
            this.stop();
        }
    }

    @Override
    @Trivial
    public AccessLog.Format getFormat() {
        return this.myFormat;
    }

    @Trivial
    public String getFormatString() {
        return this.stringFormat;
    }

    @Override
    @Trivial
    public void setFormat(AccessLog.Format format) {
        this.myFormat = format;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set access format to " + (Object)((Object)format)), (Object[])new Object[0]);
        }
    }

    @Trivial
    public void setFormatString(String format) {
        this.stringFormat = format;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set access format to " + format), (Object[])new Object[0]);
        }
        this.parseFormat();
    }

    private void parseFormat() {
        if (this.stringFormat == null) {
            this.parsedFormat = null;
            return;
        }
        ArrayList<FormatSegment> list = new ArrayList<FormatSegment>();
        boolean formatSpecifier = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.stringFormat.length(); ++i) {
            char ch = this.stringFormat.charAt(i);
            if (formatSpecifier) {
                if ('{' == ch) {
                    int j;
                    StringBuilder name = new StringBuilder();
                    for (j = i + 1; j < this.stringFormat.length() && '}' != this.stringFormat.charAt(j); ++j) {
                        name.append(this.stringFormat.charAt(j));
                    }
                    if (j + 1 < this.stringFormat.length()) {
                        FormatSegment segment;
                        if ((segment = this.createAccessLogData(this.stringFormat.charAt(++j), name.toString())) != null) {
                            list.add(segment);
                        } else {
                            String specifier = "%{" + name.toString() + "}" + this.stringFormat.charAt(j);
                            list.add(this.createStringData(specifier));
                            String msg = "Config: invalid format segment: " + specifier;
                            FFDCFilter.processException((Throwable)new IllegalArgumentException(msg), (String)this.getClass().getName(), (String)"parseFormat");
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                            }
                        }
                        i = j;
                    } else {
                        String specifier = "%{";
                        String msg = "Config: incomplete format segment: " + specifier;
                        list.add(this.createStringData(specifier));
                        FFDCFilter.processException((Throwable)new IllegalArgumentException(msg), (String)this.getClass().getName(), (String)"parseFormat");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                        }
                    }
                } else if (ch == '%') {
                    buf.append('%');
                } else {
                    FormatSegment segment = this.createAccessLogData(ch, null);
                    if (segment != null) {
                        list.add(segment);
                    } else {
                        String specifier = "%" + ch;
                        String msg = "Config: invalid format segment: " + specifier;
                        list.add(this.createStringData(specifier));
                        FFDCFilter.processException((Throwable)new IllegalArgumentException(msg), (String)this.getClass().getName(), (String)"parseFormat");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                        }
                    }
                }
                formatSpecifier = false;
                continue;
            }
            if (ch == '%') {
                formatSpecifier = true;
                if (buf.length() > 0) {
                    list.add(this.createStringData(buf.toString()));
                }
                buf = new StringBuilder();
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            list.add(this.createStringData(buf.toString()));
        }
        this.parsedFormat = list.toArray(new FormatSegment[list.size()]);
    }

    private FormatSegment createStringData(String string) {
        FormatSegment formatSegment = new FormatSegment();
        formatSegment.string = string;
        return formatSegment;
    }

    private FormatSegment createAccessLogData(char ch, String modifier) {
        AccessLogData accessLogData = null;
        if ('W' == ch) {
            StringBuilder matchString = new StringBuilder("%{");
            matchString.append(modifier);
            matchString.append("}");
            matchString.append(ch);
            accessLogData = AccessLogData.match(matchString.toString(), 0, matchString.length());
        } else {
            byte[] bs = new byte[]{37, (byte)ch};
            accessLogData = AccessLogData.match(bs, 0, bs.length);
        }
        if (accessLogData == null) {
            return null;
        }
        FormatSegment formatSegment = new FormatSegment();
        formatSegment.log = accessLogData;
        if (modifier != null) {
            formatSegment.data = accessLogData.init(modifier);
        }
        return formatSegment;
    }

    @Override
    public void log(HttpRequestMessage request, HttpResponseMessage response, String version, String userId, String remoteAddr, long numBytes) {
        block24: {
            if (!this.isStarted()) {
                return;
            }
            try {
                StringBuilder accessLogLine;
                if (this.parsedFormat != null) {
                    accessLogLine = new StringBuilder();
                    for (FormatSegment s : this.parsedFormat) {
                        if (s.string != null) {
                            accessLogLine.append(s.string);
                        }
                        if (s.log == null) continue;
                        s.log.set(accessLogLine, response, request, s.data);
                    }
                } else {
                    accessLogLine = new StringBuilder(128);
                    accessLogLine.append(remoteAddr);
                    if (null == userId) {
                        accessLogLine.append(" - - [");
                    } else {
                        accessLogLine.append(" - ");
                        accessLogLine.append(userId);
                        accessLogLine.append(" [");
                    }
                    accessLogLine.append(HttpDispatcher.getDateFormatter().getNCSATime());
                    accessLogLine.append("] \"");
                    accessLogLine.append(request.getMethodValue().getName());
                    accessLogLine.append(' ');
                    accessLogLine.append(request.getRequestURI());
                    String query = request.getQueryString();
                    if (null != query) {
                        accessLogLine.append('?');
                        accessLogLine.append(GenericUtils.nullOutPasswords(query, (byte)38));
                    }
                    accessLogLine.append(' ');
                    accessLogLine.append(version);
                    accessLogLine.append("\" ");
                    accessLogLine.append(response.getStatusCodeAsInt());
                    accessLogLine.append(' ');
                    if (-1L != response.getContentLength()) {
                        accessLogLine.append(response.getContentLength());
                    } else {
                        accessLogLine.append(numBytes);
                    }
                    if (AccessLog.Format.COMBINED.equals((Object)this.getFormat())) {
                        String val = request.getHeader(HttpHeaderKeys.HDR_REFERER).asString();
                        if (null == val) {
                            accessLogLine.append(" -");
                        } else {
                            accessLogLine.append(" \"");
                            accessLogLine.append(val);
                            accessLogLine.append("\"");
                        }
                        val = request.getHeader(HttpHeaderKeys.HDR_USER_AGENT).asString();
                        if (null == val) {
                            accessLogLine.append(" -");
                        } else {
                            accessLogLine.append(" \"");
                            accessLogLine.append(val);
                            accessLogLine.append('\"');
                        }
                        int count = request.getNumberOfHeaderInstances(HttpHeaderKeys.HDR_COOKIE);
                        if (0 == count) {
                            accessLogLine.append(" -");
                        } else {
                            accessLogLine.append(" \"");
                            Iterator<HeaderField> it = request.getHeaders(HttpHeaderKeys.HDR_COOKIE).iterator();
                            accessLogLine.append(it.next().asString());
                            while (it.hasNext()) {
                                accessLogLine.append(", ");
                                accessLogLine.append(it.next().asString());
                            }
                            accessLogLine.append('\"');
                        }
                    }
                }
                accessLogLine.append(newLine);
                if (!LogForwarderManager.getAccessLogForwarders().isEmpty()) {
                    AccessLogRecordData recordData = this.toAccessLogRecordData(request, response, version, userId, remoteAddr, numBytes);
                    for (AccessLogForwarder forwarder : LogForwarderManager.getAccessLogForwarders()) {
                        try {
                            forwarder.process(recordData);
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".log"), (String)"136", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                            Tr.event((TraceComponent)tc, (String)("Exception while forwarder log to " + forwarder + " ; " + t), (Object[])new Object[0]);
                        }
                    }
                }
                WsByteBuffer wsbb = HttpDispatcher.getBufferManager().allocate(accessLogLine.length());
                wsbb.put(HttpChannelUtils.getBytes(accessLogLine));
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".log"), (String)"136", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block24;
                Tr.event((TraceComponent)tc, (String)("Exception while writing log msg; " + t), (Object[])new Object[0]);
            }
        }
    }

    private AccessLogRecordData toAccessLogRecordData(HttpRequestMessage request, HttpResponseMessage response, final String version, final String userId, final String remoteAddr, final long numBytes) {
        final HttpRequestMessage request2 = request;
        final HttpResponseMessage response2 = response;
        final long timestamp = System.currentTimeMillis();
        final long startTime = AccessLogStartTime.getStartTime(response2, request2, null);
        final long elapsedTime = AccessLogElapsedRequestTime.getElapsedRequestTime(response2, request2, null);
        final String localIP = AccessLogLocalIP.getLocalIP(response2, request2, null);
        final String localPort = AccessLogLocalPort.getLocalPort(response2, request2, null);
        AccessLogRecordData recordData = new AccessLogRecordData(){

            @Override
            public long getTimestamp() {
                return timestamp;
            }

            @Override
            public String getVersion() {
                return version;
            }

            @Override
            public String getUserId() {
                return userId;
            }

            @Override
            public HttpResponseMessage getResponse() {
                return response2;
            }

            @Override
            public HttpRequestMessage getRequest() {
                return request2;
            }

            @Override
            public String getRemoteAddress() {
                return remoteAddr;
            }

            @Override
            public long getBytesWritten() {
                return numBytes;
            }

            @Override
            public long getStartTime() {
                return startTime;
            }

            @Override
            public long getElapsedTime() {
                return elapsedTime;
            }

            @Override
            public String getLocalIP() {
                return localIP;
            }

            @Override
            public String getLocalPort() {
                return localPort;
            }
        };
        return recordData;
    }

    @Override
    public void log(byte[] message) {
        block3: {
            if (!this.isStarted()) {
                return;
            }
            try {
                WsByteBuffer wsbb = HttpDispatcher.getBufferManager().allocate(message.length + 2);
                wsbb.put(message);
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".log"), (String)"156", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)("Error writing to log; " + t), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void log(String message) {
        if (this.isStarted()) {
            this.log(GenericUtils.getEnglishBytes(message));
        }
    }

    @Override
    @Trivial
    public String toString() {
        return super.toString() + "\n Format: " + this.getFormatString();
    }

    static class FormatSegment {
        public String string;
        public Object data;
        public AccessLogData log;

        FormatSegment() {
        }
    }
}

