/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal.channel;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.internal.outbound.HttpOutputStreamImpl;
import com.ibm.ws.http.dispatcher.classify.DecoratedExecutorThread;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherChannel;
import com.ibm.ws.http.dispatcher.internal.channel.HttpRequestImpl;
import com.ibm.ws.http.dispatcher.internal.channel.HttpResponseImpl;
import com.ibm.ws.http.dispatcher.internal.channel.SSLContextImpl;
import com.ibm.ws.http.internal.VirtualHostImpl;
import com.ibm.ws.http.internal.VirtualHostMap;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.access.TransportConnectionAccess;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.base.InboundApplicationLink;
import com.ibm.wsspi.http.EncodingUtils;
import com.ibm.wsspi.http.HttpDateFormat;
import com.ibm.wsspi.http.HttpOutputStream;
import com.ibm.wsspi.http.HttpRequest;
import com.ibm.wsspi.http.HttpResponse;
import com.ibm.wsspi.http.SSLContext;
import com.ibm.wsspi.http.URLEscapingUtils;
import com.ibm.wsspi.http.WorkClassifier;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.ee7.HttpInboundConnectionExtended;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpDispatcherLink
extends InboundApplicationLink
implements HttpInboundConnectionExtended,
VirtualHostMap.RequestHelper {
    private static final TraceComponent tc = Tr.register(HttpDispatcherLink.class);
    public static final String LINK_ID = "HttpDispatcherLink";
    private HttpDispatcherChannel myChannel = null;
    private HttpRequestImpl request = null;
    private HttpResponseImpl response = null;
    private SSLContext sslinfo = null;
    private HttpInboundServiceContextImpl isc = null;
    private String localCanonicalHostName = null;
    private String localHostAlias = null;
    private String remoteContextAddress;
    private volatile boolean linkIsReady = false;
    private volatile UsePrivateHeaders usePrivateHeaders = UsePrivateHeaders.unknown;
    private volatile int configUpdate = 0;
    static final long serialVersionUID = -5157012125161796251L;

    public void init(VirtualConnection inVC, HttpDispatcherChannel channel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New conn: vc=" + inVC), (Object[])new Object[0]);
        }
        super.init(inVC);
        inVC.getStateMap().put(LINK_ID, this);
        this.myChannel = channel;
        boolean useEE7Streams = HttpDispatcher.useEE7Streams();
        this.request = new HttpRequestImpl(useEE7Streams);
        this.response = new HttpResponseImpl(this, useEE7Streams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(VirtualConnection conn, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Close called , vc ->" + this.vc), (Object[])new Object[0]);
        }
        if (this.vc != null) {
            String closeNonUpgraded = (String)this.vc.getStateMap().get("CloseNonUpgradedStreams");
            if (closeNonUpgraded != null && closeNonUpgraded.equalsIgnoreCase("true")) {
                Exception errorinClosing = this.closeStreams();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error closing in strems" + errorinClosing), (Object[])new Object[0]);
                }
                this.vc.getStateMap().put("CloseNonUpgradedStreams", "CLOSED_NON_UPGRADED_STREAMS");
                return;
            }
            String upgradedListener = (String)this.vc.getStateMap().get("UpgradedListener");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("upgradedListener ->" + upgradedListener), (Object[])new Object[0]);
            }
            if (upgradedListener != null && upgradedListener.equalsIgnoreCase("true")) {
                boolean closeCalledFromWebConnection = false;
                HttpDispatcherLink httpDispatcherLink = this;
                synchronized (httpDispatcherLink) {
                    String fromWebConnection = (String)this.vc.getStateMap().get("CloseUpgradedWebConnection");
                    if (fromWebConnection != null && fromWebConnection.equalsIgnoreCase("true")) {
                        closeCalledFromWebConnection = true;
                        this.vc.getStateMap().put("CloseUpgradedWebConnection", "false");
                    }
                }
                if (!closeCalledFromWebConnection) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Connection Not to be closed here because Servlet Upgrade.", (Object[])new Object[0]);
                    }
                    return;
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connection must be already closed since vc is null", (Object[])new Object[0]);
            }
            return;
        }
        if (!this.myChannel.getStop0Called()) {
            super.close(conn, e);
            this.myChannel.decrementActiveConns();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void destroy(Exception e) {
        Object webConnectionObject;
        String upgraded;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroy with exc=" + e), (Object[])new Object[0]);
        }
        this.linkIsReady = false;
        VirtualConnection vc = this.getVC();
        if (vc != null && (upgraded = (String)vc.getStateMap().get("UpgradedConnection")) != null && upgraded.compareToIgnoreCase("true") == 0 && (webConnectionObject = vc.getStateMap().get("UpgradedWebConnectionObject")) != null) {
            if (webConnectionObject instanceof TransportConnectionAccess) {
                TransportConnectionAccess tWebConn = (TransportConnectionAccess)webConnectionObject;
                try {
                    tWebConn.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink", (String)"230", (Object)this, (Object[])new Object[]{e});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void webConnectionCloseException;
                        Tr.debug((TraceComponent)tc, (String)"Failed to close WebConnection {0}", (Object[])new Object[]{webConnectionCloseException});
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"call application destroy if not done yet", (Object[])new Object[0]);
            }
        }
        super.destroy();
        this.isc = null;
        this.request = null;
        this.response = null;
        this.sslinfo = null;
    }

    @FFDCIgnore(value={Throwable.class})
    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Received HTTP connection: " + inVC), (Object[])new Object[0]);
        }
        this.myChannel.incrementActiveConns();
        this.init(inVC);
        this.isc = (HttpInboundServiceContextImpl)this.getDeviceLink().getChannelAccessor();
        this.response.init(this.isc);
        this.linkIsReady = true;
        ExecutorService executorService = HttpDispatcher.getExecutorService();
        if (null == executorService) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Missing executor service", (Object[])new Object[0]);
            }
            this.sendResponse(StatusCodes.UNAVAILABLE, null, false);
            return;
        }
        this.request.init(this.isc);
        VirtualHostImpl vhost = VirtualHostMap.findVirtualHost(this.myChannel.getEndpointPid(), this);
        if (vhost == null) {
            String url = this.isc.getRequest().getRequestURI();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String alias = this.getLocalHostAlias();
                Tr.debug((TraceComponent)tc, (String)("No virtual host found for this alias: " + alias), (Object[])new Object[0]);
            }
            this.send404Message(url);
            return;
        }
        Runnable handler = null;
        try {
            handler = vhost.discriminate(this);
            if (handler == null) {
                URL landingURL = this.getLandingURL();
                if (landingURL != null) {
                    this.displayLandingPage(landingURL);
                } else {
                    String url = this.isc.getRequest().getRequestURI();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        String alias = this.getLocalHostAlias();
                        Tr.debug((TraceComponent)tc, (String)("The URI was not associated with the virtual host " + vhost.getName()), (Object[])new Object[]{alias, url});
                    }
                    this.send404Message(url);
                }
            } else {
                this.wrapHandlerAndExecute(handler);
            }
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Exception during dispatch; " + t), (Object[])new Object[0]);
            }
            if (t instanceof Exception) {
                this.sendResponse(StatusCodes.INTERNAL_ERROR, (Exception)t, true);
            }
            this.sendResponse(StatusCodes.INTERNAL_ERROR, new Exception("Dispatch error", t), true);
        }
    }

    private void wrapHandlerAndExecute(Runnable handler) {
        TaskWrapper taskWrapper = new TaskWrapper(handler, this);
        WorkClassifier workClassifier = HttpDispatcher.getWorkClassifier();
        if (workClassifier != null) {
            Executor classifyExecutor = workClassifier.classify(this.request, this);
            if (classifyExecutor != null) {
                taskWrapper.setClassifiedExecutor(classifyExecutor);
                classifyExecutor.execute(taskWrapper);
            } else {
                taskWrapper.run();
            }
        } else {
            taskWrapper.run();
        }
    }

    @Override
    public TCPConnectionContext getTCPConnectionContext() {
        TCPConnectionContext tcc = null;
        if (this.isc != null) {
            tcc = this.isc.getTSC();
        }
        return tcc;
    }

    @Override
    public VirtualConnection getVC() {
        if (this.isc != null) {
            return this.isc.getVC();
        }
        return null;
    }

    @Override
    public ConnectionLink getHttpInboundDeviceLink() {
        if (this.isc != null && this.isc.getLink() != null) {
            return this.isc.getLink().getDeviceLink();
        }
        return null;
    }

    @Override
    public ConnectionLink getHttpInboundLink() {
        if (this.isc != null) {
            return this.isc.getLink();
        }
        return null;
    }

    @Override
    public ConnectionLink getHttpDispatcherLink() {
        return this;
    }

    private URL getLandingURL() {
        if (!HttpDispatcher.isWelcomePageEnabled().booleanValue()) {
            return null;
        }
        String theURI = this.isc.getRequest().getRequestURI();
        Bundle bc = FrameworkUtil.getBundle(this.getClass());
        URL url = theURI.equals("/") ? bc.getEntry("/OSGI-INF/welcome/index.html") : bc.getEntry("/OSGI-INF/welcome" + theURI);
        return url;
    }

    private URL getNotFoundURL() {
        if (!HttpDispatcher.isWelcomePageEnabled().booleanValue()) {
            return null;
        }
        Bundle bc = FrameworkUtil.getBundle(this.getClass());
        URL url = bc.getEntry("/OSGI-INF/notFound/index.html");
        return url;
    }

    private void displayLandingPage(URL url) throws IOException {
        this.displayPage(url, StatusCodes.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayPage(URL url, StatusCodes status) throws IOException {
        HttpOutputStreamImpl body = this.response.getBody();
        InputStream inputStream = this.getClass().getResourceAsStream(url.getPath());
        try {
            if (this.exists(inputStream)) {
                int len;
                if (status == StatusCodes.OK && !url.getPath().endsWith(".html")) {
                    this.response.setHeader(HttpHeaderKeys.HDR_CACHE_CONTROL.getName(), "max-age=604800");
                }
                byte[] buffer = new byte[4096];
                while ((len = inputStream.read(buffer)) > 0) {
                    ((OutputStream)body).write(buffer, 0, len);
                }
            }
        }
        finally {
            this.tryToCloseStream(inputStream);
        }
        this.sendResponse(status, null, null, false);
    }

    @FFDCIgnore(value={Throwable.class})
    private void send404Message(String url) {
        int difference;
        String s = HttpDispatcher.getContextRootNotFoundMessage();
        boolean addAddress = false;
        if (s == null || s.isEmpty()) {
            if (HttpDispatcher.isWelcomePageEnabled().booleanValue()) {
                URL notFoundPage = this.getNotFoundURL();
                try {
                    this.displayPage(notFoundPage, StatusCodes.NOT_FOUND);
                }
                catch (Throwable t) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Exception displaying error page; " + t), (Object[])new Object[0]);
                    }
                    if (t instanceof Exception) {
                        this.sendResponse(StatusCodes.INTERNAL_ERROR, (Exception)t, true);
                    }
                    this.sendResponse(StatusCodes.INTERNAL_ERROR, new Exception("Error page", t), true);
                }
                return;
            }
            String safeUrl = URLEscapingUtils.toSafeString(url);
            s = Tr.formatMessage((TraceComponent)tc, (String)"Missing.App.Or.Context.Root.No.Error.Code", (Object[])new Object[]{safeUrl});
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("send error with following string: " + s), (Object[])new Object[0]);
        }
        if (s != null && HttpDispatcher.padContextRootNotFoundMessage() && (difference = 513 - s.length()) > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("404 message is not 512 so pad it. Length = " + s.length()), (Object[])new Object[0]);
            }
            StringBuffer sb = new StringBuffer(s);
            String beginComment = " <!--A comment to allow the error page to be greater than 512 bytes:";
            difference -= beginComment.length();
            String endComment = "--!> ";
            sb.append(beginComment);
            for (int i = 0; i < difference; i += 50) {
                sb.append("12345678901234567890123456789012345678901234567890");
            }
            sb.append(endComment);
            s = sb.toString();
        }
        this.sendResponse(StatusCodes.NOT_FOUND, s, null, addAddress);
    }

    private void sendResponse(StatusCodes code, Exception failure, boolean addAddress) {
        this.sendResponse(code, null, failure, addAddress);
    }

    @FFDCIgnore(value={IOException.class})
    private void sendResponse(StatusCodes code, String detail, Exception failure, boolean addAddress) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending HTTP response: " + code), (Object[])new Object[0]);
        }
        HttpInboundServiceContextImpl finalSc = this.isc;
        HttpResponseImpl finalResponse = this.response;
        if (finalSc == null || finalResponse == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to send response, isc= " + finalSc + ", response=" + finalResponse), (Object[])new Object[0]);
            }
            return;
        }
        HttpResponseMessage rMsg = finalSc.getResponse();
        this.setResponseProperties(rMsg, code);
        HttpOutputStreamImpl body = finalResponse.getBody();
        if (code.isBodyAllowed() && !((HttpOutputStream)body).hasBufferedContent()) {
            try {
                byte[][] bits = new byte[][]{"<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">".getBytes(), "<html><head><title>".getBytes(), "</title></head><body><h1>".getBytes(), "</h1><p>".getBytes(), "</p><hr /><address>".getBytes(), "</address></body></html>".getBytes(), "</p></body></html>".getBytes()};
                byte[] at = " at ".getBytes();
                byte[] port = " port ".getBytes();
                ((OutputStream)body).write(bits[0]);
                ((OutputStream)body).write(bits[1]);
                byte[] msg = code.getStatusWithPhrase();
                ((OutputStream)body).write(msg);
                ((OutputStream)body).write(bits[2]);
                msg = code.getDefaultPhraseBytes();
                ((OutputStream)body).write(msg);
                ((OutputStream)body).write(bits[3]);
                if (detail != null) {
                    msg = detail.getBytes();
                    ((OutputStream)body).write(msg);
                }
                if (addAddress) {
                    ((OutputStream)body).write(bits[4]);
                    HttpChannelConfig cfg = finalSc.getHttpConfig();
                    byte[] name = cfg.getServerHeaderValue();
                    if (!cfg.removeServerHeader() && name != null) {
                        ((OutputStream)body).write(name);
                        ((OutputStream)body).write(at);
                    }
                    msg = this.getRequestedHost().getBytes();
                    ((OutputStream)body).write(msg);
                    ((OutputStream)body).write(port);
                    ((OutputStream)body).write(Integer.toString(this.getRequestedPort()).getBytes());
                    ((OutputStream)body).write(bits[5]);
                } else {
                    ((OutputStream)body).write(bits[6]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.finish(failure);
    }

    void setResponseProperties(HttpResponseMessage rMsg, StatusCodes code) {
        rMsg.setStatusCode(code);
        rMsg.setConnection(ConnectionValues.CLOSE);
        rMsg.setCharset(Charset.forName("UTF-8"));
        rMsg.setHeader("Content-Type", "text/html; charset=UTF-8");
    }

    @Override
    public String getRequestedHost() {
        String pluginHost;
        if (this.useTrustedHeaders() && (pluginHost = this.request.getHeader(HttpHeaderKeys.HDR_$WSSN.getName())) != null) {
            return pluginHost;
        }
        String host = this.request.getVirtualHost();
        if (host == null) {
            return "localhost";
        }
        return host;
    }

    @Override
    public int getRequestedPort() {
        String pluginPort;
        if (this.useTrustedHeaders() && (pluginPort = this.request.getHeader(HttpHeaderKeys.HDR_$WSSP.getName())) != null) {
            return Integer.parseInt(pluginPort);
        }
        int port = this.request.getVirtualPort();
        if (port > 0) {
            return port;
        }
        if (this.request.getHeader(HttpHeaderKeys.HDR_HOST.getName()) != null) {
            String scheme = this.request.getScheme();
            if ("http".equals(scheme)) {
                return 80;
            }
            if ("https".equals(scheme)) {
                return 443;
            }
        }
        return this.getLocalPort();
    }

    @Override
    public boolean useTrustedHeaders() {
        UsePrivateHeaders useHeaders = this.usePrivateHeaders;
        int lastUpdate = HttpDispatcher.getConfigUpdate();
        if (useHeaders == UsePrivateHeaders.unknown || this.configUpdate != lastUpdate) {
            useHeaders = this.usePrivateHeaders = UsePrivateHeaders.set(HttpDispatcher.usePrivateHeaders(this.contextRemoteHostAddress()));
            this.configUpdate = lastUpdate;
        }
        return useHeaders.asBoolean();
    }

    @Override
    public String getTrustedHeader(String headerName) {
        if (this.useTrustedHeaders() && this.request != null) {
            return this.request.getHeader(headerName);
        }
        return null;
    }

    @Override
    public String getLocalHostAddress() {
        return this.isc.getLocalAddr().getHostAddress();
    }

    @Override
    public String getLocalHostAlias() {
        String alias = this.localHostAlias;
        if (alias == null) {
            alias = this.localHostAlias = this.getRequestedHost() + ":" + this.getRequestedPort();
        }
        return alias;
    }

    @Override
    public String getLocalHostName(boolean canonical) {
        String hostName = null;
        if (canonical) {
            hostName = this.localCanonicalHostName;
            if (hostName == null) {
                this.localCanonicalHostName = hostName = this.internalGetHostName(true);
            }
        } else {
            hostName = this.internalGetHostName(false);
        }
        return hostName;
    }

    private String internalGetHostName(final boolean canonical) {
        final HttpInboundServiceContextImpl finalSc = this.isc;
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -2892128341662403934L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                if (canonical) {
                    return finalSc.getLocalAddr().getCanonicalHostName();
                }
                return finalSc.getLocalAddr().getHostName();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    @Override
    public int getLocalPort() {
        return this.isc.getLocalPort();
    }

    @Override
    public String getRemoteHostAddress() {
        String remoteAddr = this.getTrustedHeader(HttpHeaderKeys.HDR_$WSRA.getName());
        if (remoteAddr != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRemoteHostAddress isTrusted --> true, addr --> " + remoteAddr), (Object[])new Object[0]);
            }
        } else {
            remoteAddr = this.contextRemoteHostAddress();
        }
        return remoteAddr;
    }

    private String contextRemoteHostAddress() {
        HttpInboundServiceContextImpl finalSc;
        String remoteAddr = this.remoteContextAddress;
        if (remoteAddr == null && (finalSc = this.isc) != null) {
            remoteAddr = this.remoteContextAddress = finalSc.getRemoteAddr().getHostAddress();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRemoteAddr addr --> " + remoteAddr), (Object[])new Object[0]);
            }
        }
        return remoteAddr;
    }

    @Override
    public String getRemoteHostName(final boolean canonical) {
        String remoteHost = this.getTrustedHeader(HttpHeaderKeys.HDR_$WSRH.getName());
        if (remoteHost != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRemoteHost isTrusted --> true, host --> " + remoteHost), (Object[])new Object[0]);
            }
        } else {
            final HttpInboundServiceContextImpl finalSc = this.isc;
            remoteHost = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = -5897722172110745537L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    if (canonical) {
                        return finalSc.getRemoteAddr().getCanonicalHostName();
                    }
                    return finalSc.getRemoteAddr().getHostName();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRemoteHost host --> " + remoteHost), (Object[])new Object[0]);
            }
        }
        return remoteHost;
    }

    @Override
    public int getRemotePort() {
        return this.isc.getRemotePort();
    }

    @Override
    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public SSLContext getSSLContext() {
        if (this.sslinfo == null && this.isc != null && this.isc.getSSLContext() != null) {
            this.sslinfo = new SSLContextImpl(this.isc.getSSLContext());
        }
        return this.sslinfo;
    }

    @Override
    public void finish(Exception e) {
        HttpInboundServiceContextImpl finalSc = this.isc;
        Exception error = e;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Finishing conn; " + finalSc + " error=" + e), (Object[])new Object[0]);
        }
        if (this.vc != null) {
            String webconn = (String)this.vc.getStateMap().get("CloseNonUpgradedStreams");
            if (webconn != null && webconn.equalsIgnoreCase("CLOSED_NON_UPGRADED_STREAMS")) {
                this.vc.getStateMap().put("CloseNonUpgradedStreams", "null");
            } else {
                error = this.closeStreams();
            }
        } else {
            error = this.closeStreams();
        }
        this.close(this.getVirtualConnection(), error);
    }

    private Exception closeStreams() {
        Exception ex;
        HttpRequestImpl finalRequest = this.request;
        HttpResponseImpl finalResponse = this.response;
        Exception error = null;
        if (finalRequest != null) {
            ex = this.tryToCloseStream(finalRequest.getBody());
            if (null == error) {
                error = ex;
            }
        }
        if (finalResponse != null) {
            ex = this.tryToCloseStream(finalResponse.getBody());
            if (null == error) {
                error = ex;
            }
        }
        return error;
    }

    @Override
    public HttpDateFormat getDateFormatter() {
        return HttpDispatcher.getDateFormatter();
    }

    @Override
    public EncodingUtils getEncodingUtils() {
        return HttpDispatcher.getEncodingUtils();
    }

    @Trivial
    @FFDCIgnore(value={IOException.class})
    private boolean exists(InputStream inputStream) {
        try {
            return inputStream.available() > 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Trivial
    @FFDCIgnore(value={IOException.class})
    private Exception tryToCloseStream(Closeable closeStream) {
        if (closeStream != null) {
            try {
                closeStream.close();
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error closing stream; " + ioe), (Object[])new Object[0]);
                }
                return ioe;
            }
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class TaskWrapper
    implements Runnable {
        private final Runnable runnable;
        private final HttpDispatcherLink ic;
        private Executor classifiedExecutor;
        static final long serialVersionUID = 2989690679377838424L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public TaskWrapper(Runnable run, HttpDispatcherLink inboundConnection) {
            this.runnable = run;
            this.ic = inboundConnection;
            this.classifiedExecutor = null;
        }

        public void setClassifiedExecutor(Executor classifiedExecutor) {
            this.classifiedExecutor = classifiedExecutor;
        }

        @Override
        @FFDCIgnore(value={Throwable.class})
        public void run() {
            try {
                DecoratedExecutorThread.setExecutor(this.classifiedExecutor);
                this.runnable.run();
            }
            catch (Throwable t) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unhandled exception during dispatch (bad container); " + t), (Object[])new Object[0]);
                }
                if (this.ic.linkIsReady) {
                    if (t instanceof Exception) {
                        this.ic.sendResponse(StatusCodes.INTERNAL_ERROR, (Exception)t, true);
                    } else {
                        this.ic.sendResponse(StatusCodes.INTERNAL_ERROR, new Exception("Dispatch error", t), true);
                    }
                }
            }
            finally {
                DecoratedExecutorThread.setExecutor(null);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(TaskWrapper.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class UsePrivateHeaders
    extends Enum<UsePrivateHeaders> {
        public static final /* enum */ UsePrivateHeaders unknown;
        public static final /* enum */ UsePrivateHeaders yes;
        public static final /* enum */ UsePrivateHeaders no;
        private final boolean enabled;
        private static final /* synthetic */ UsePrivateHeaders[] $VALUES;
        static final long serialVersionUID = 3568402691044685543L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static UsePrivateHeaders[] values() {
            return (UsePrivateHeaders[])$VALUES.clone();
        }

        public static UsePrivateHeaders valueOf(String name) {
            return Enum.valueOf(UsePrivateHeaders.class, name);
        }

        static UsePrivateHeaders set(boolean useHeaders) {
            if (useHeaders) {
                return yes;
            }
            return no;
        }

        private UsePrivateHeaders(boolean enabled) {
            this.enabled = enabled;
        }

        boolean asBoolean() {
            return this.enabled;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(UsePrivateHeaders.class);
            unknown = new UsePrivateHeaders(true);
            yes = new UsePrivateHeaders(true);
            no = new UsePrivateHeaders(false);
            $VALUES = new UsePrivateHeaders[]{unknown, yes, no};
        }
    }
}

