/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.internal.util.EventLock;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class EventLockCumulativeTimeout
extends EventLock {
    private static final long serialVersionUID = 1L;
    private final long timeout;
    private long timeWaited;
    private long startTime;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    EventLockCumulativeTimeout(long nanos) {
        this.timeout = nanos;
    }

    @Override
    synchronized boolean wait(int oldEventCount) throws InterruptedException {
        while (this.waitNeeded(oldEventCount)) {
            this.startTimer();
            try {
                this.waitForEventOrTimeout();
            }
            finally {
                this.recordElapsedTime();
            }
        }
        return this.eventPosted(oldEventCount);
    }

    @Override
    synchronized void postEvent() {
        super.postEvent();
        this.stopTimer();
    }

    @Override
    boolean canTimeOut() {
        return true;
    }

    @Override
    boolean hasTimedOut() {
        return this.timeout <= this.timeWaited;
    }

    private synchronized void startTimer() {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
    }

    private synchronized void recordElapsedTime() {
        if (this.startTime == 0L) {
            return;
        }
        long current = System.nanoTime();
        this.timeWaited += Math.abs(current - this.startTime);
        this.startTime = current;
    }

    private synchronized void stopTimer() {
        if (this.startTime == 0L) {
            return;
        }
        this.timeWaited += Math.abs(System.nanoTime() - this.startTime);
        this.startTime = 0L;
    }

    private void waitForEventOrTimeout() throws InterruptedException {
        long remainingWait = this.timeout - this.timeWaited;
        long millisToWait = remainingWait / 1000000L;
        int nanosToWait = (int)(remainingWait % 1000000L);
        this.wait(millisToWait, nanosToWait);
    }

    private boolean waitNeeded(int oldEventCount) {
        if (this.eventPosted(oldEventCount)) {
            return false;
        }
        return !this.hasTimedOut();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(EventLockCumulativeTimeout.class);
    }
}

