/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Map;
import javax.rmi.CORBA.Util;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.CorbaObjectReader;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

class AbstractObjectArrayDescriptor
extends ArrayDescriptor {
    AbstractObjectArrayDescriptor(Class type, Class elemType, TypeRepository rep) {
        super(type, elemType, rep);
    }

    @Override
    public void writeValue(OutputStream out, Serializable value) {
        Object[] arr = (Object[])value;
        out.write_long(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            Util.writeAbstractObject((OutputStream)out, (Object)arr[i]);
        }
    }

    public Serializable readValue(InputStream in, Map offsetMap, Integer key) {
        try {
            CorbaObjectReader reader = this.makeCorbaObjectReader(in, offsetMap, null);
            int length = ((ObjectInputStream)reader).readInt();
            Object[] arr = (Object[])Array.newInstance(this.elementType, length);
            offsetMap.put(key, arr);
            for (int i = 0; i < length; ++i) {
                try {
                    arr[i] = ((ObjectReader)reader).readAbstractObject();
                    continue;
                }
                catch (IndirectionException ex) {
                    arr[i] = offsetMap.get(new Integer(ex.offset));
                }
            }
            return arr;
        }
        catch (IOException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    @Override
    Object copyObject(Object value, CopyState state) {
        Object[] orig = (Object[])value;
        final Object[] result = (Object[])Array.newInstance(this.elementType, orig.length);
        state.put(value, result);
        for (int i = 0; i < orig.length; ++i) {
            try {
                result[i] = state.copy(orig[i]);
                continue;
            }
            catch (CopyRecursionException e) {
                final int idx = i;
                state.registerRecursion(new CopyRecursionResolver(orig[i]){

                    @Override
                    public void resolve(Object value) {
                        result[idx] = value;
                    }
                });
            }
        }
        return result;
    }

    @Override
    void printFields(PrintWriter pw, Map recurse, Object val) {
        Object[] arr = (Object[])val;
        TypeDescriptor desc = this.repo.getDescriptor(this.elementType);
        pw.print("length=" + arr.length + "; ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            desc.print(pw, recurse, arr[i]);
        }
    }
}

