/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.Proxy;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;

public class OrderingContextProxy
extends Proxy
implements OrderingContext {
    private static final TraceComponent tc = SibTr.register(OrderingContextProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private int useCount = 0;
    private boolean dead = false;
    private Queue queue;

    public OrderingContextProxy(Conversation con, ConnectionProxy cp) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        super(con, cp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.setOrderingContextProxyId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public OrderingContextProxy(int id) {
        super(null, null);
        this.setProxyID((short)id);
    }

    public short getId() {
        return this.getProxyID();
    }

    public int getUseCount() {
        return this.useCount;
    }

    public synchronized void incrementUseCount() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"incrementUseCount");
        }
        if (this.dead) {
            this.setOrderingContextProxyId();
            this.dead = false;
        }
        ++this.useCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Use count is now: " + this.useCount));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"incrementUseCount");
        }
    }

    private void setOrderingContextProxyId() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        ConnectionProxy cp;
        Short orderContext;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setOrderingContextProxyId");
        }
        if ((orderContext = (cp = this.getConnectionProxy()).getOrderContext()) != null) {
            this.setProxyID(orderContext);
        } else {
            this.create();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setOrderingContextProxyId");
        }
    }

    public synchronized void decrementUseCount() throws SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"decrementUseCount");
        }
        --this.useCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Use count is now: " + this.useCount));
        }
        if (this.useCount == 0) {
            this.close();
            this.dead = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"decrementUseCount");
        }
    }

    public void create() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"create");
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        CommsByteBuffer reply = null;
        try {
            reply = this.jfapExchange(request, 107, 11, true);
            short err = reply.getCommandCompletionCode(236);
            if (err != 0) {
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            short ocId = reply.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Created the order proxy. ID: " + ocId));
            }
            this.setProxyID(ocId);
        }
        catch (SIConnectionLostException e) {
            throw new SIConnectionDroppedException("", (Throwable)e);
        }
        finally {
            if (reply != null) {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"create");
        }
    }

    public void close() throws SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        this.queue = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Returning order context to the order context pool");
        }
        ConnectionProxy cp = this.getConnectionProxy();
        cp.addOrderContext(this.getProxyID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public String toString() {
        return "CommsOrderContext@" + Integer.toHexString(this.hashCode()) + ". Id: " + this.getProxyID() + ". Use count: " + this.useCount + ". Dead: " + this.dead;
    }

    public void associateWithQueue(Queue queueToAssociate) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"associateWithQueue", (Object)queueToAssociate);
        }
        this.queue = queueToAssociate;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"associateWithQueue");
        }
    }

    public Queue getAssociatedQueue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAssociatedQueue");
        }
        Queue result = this.queue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAssociatedQueue", (Object)result);
        }
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/OrderingContextProxy.java, SIB.comms, WASX.SIB, uu1215.01 1.21");
        }
    }
}

