/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.InterceptorCallback;
import com.ibm.ws.javaee.dd.ejb.EnterpriseBean;
import com.ibm.ws.javaee.dd.ejb.Interceptor;
import com.ibm.ws.javaee.dd.ejb.InterceptorBinding;
import com.ibm.ws.javaee.dd.ejb.InterceptorOrder;
import com.ibm.ws.javaee.dd.ejb.Interceptors;
import com.ibm.ws.javaee.dd.ejb.MessageDriven;
import com.ibm.ws.javaee.dd.ejb.NamedMethod;
import com.ibm.ws.javaee.dd.ejb.Session;
import com.ibm.ws.javaee.dd.ejb.SessionInterceptor;
import com.ibm.ws.metadata.ejb.CheckEJBAppConfigHelper;
import com.ibm.ws.metadata.ejb.EJBInterceptorBinding;
import com.ibm.ws.metadata.ejb.InterceptorMethodKind;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.interceptor.InvocationContext;

public class InterceptorMetaDataHelper {
    private static final String CLASS_NAME = InterceptorMetaDataHelper.class.getName();
    private static final TraceComponent tc = Tr.register(InterceptorMetaDataHelper.class, (String)"EJB3Interceptors", (String)"com.ibm.ejs.container.container");
    private static final Class<?>[] PARM_TYPES = new Class[]{InvocationContext.class};
    private static final Class<?>[] NO_PARMS = null;

    public static void populateInterceptorBindingMap(List<InterceptorBinding> bindingList, Map<String, List<EJBInterceptorBinding>> map) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"populateInterceptorBindingMap", (Object[])new Object[0]);
        }
        for (InterceptorBinding ib : bindingList) {
            String methodName;
            EJBInterceptorBinding binding;
            String ejbName = ib.getEjbName();
            List<EJBInterceptorBinding> ejbList = map.get(ejbName);
            NamedMethod nm = ib.getMethod();
            List parms = null;
            if (nm != null) {
                parms = nm.getMethodParamList();
            }
            InterceptorOrder order = ib.getInterceptorOrder();
            List interceptorClassNameList = null;
            List interceptorOrderList = null;
            if (order == null) {
                interceptorClassNameList = ib.getInterceptorClassNames();
            } else {
                interceptorOrderList = order.getInterceptorClassNames();
            }
            if (ejbName.equals("*")) {
                if (nm != null) {
                    EJBConfigurationException ecex = new EJBConfigurationException("CNTR0239E: The method-name element is not valid in an interceptor-binding when EJB name is \"*\"");
                    Tr.error((TraceComponent)tc, (String)"METHOD_NAME_INVALID_FOR_DEFAULT_CNTR0239E", (Object[])new Object[0]);
                    throw ecex;
                }
                binding = new EJBInterceptorBinding(interceptorClassNameList, interceptorOrderList);
            } else if (nm == null) {
                binding = new EJBInterceptorBinding(ejbName, interceptorClassNameList, interceptorOrderList);
            } else if (parms == null) {
                methodName = nm.getMethodName();
                binding = new EJBInterceptorBinding(ejbName, interceptorClassNameList, interceptorOrderList, methodName, null);
            } else {
                methodName = nm.getMethodName();
                binding = new EJBInterceptorBinding(ejbName, interceptorClassNameList, interceptorOrderList, methodName, parms);
            }
            if (ib.isSetExcludeDefaultInterceptors()) {
                binding.setExcludeDefaultInterceptors(ib.isExcludeDefaultInterceptors());
            }
            if (ib.isSetExcludeClassInterceptors()) {
                binding.setExcludeClassLevelInterceptors(ib.isExcludeClassInterceptors());
            }
            if (ejbList != null) {
                ejbList.add(binding);
            } else {
                ejbList = new LinkedList<EJBInterceptorBinding>();
                ejbList.add(binding);
                map.put(ejbName, ejbList);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            binding.dump();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"populateInterceptorBindingMap");
        }
    }

    public static Map<String, Interceptor> populateInterceptorsMap(ClassLoader classLoader, Interceptors interceptors, IdentityHashMap<Class<?>, EnumMap<InterceptorMethodKind, List<Method>>> interceptorsMap, J2EEName name) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"populateInterceptorsMap", (Object[])new Object[0]);
        }
        List interceptorList = interceptors.getInterceptorList();
        HashMap<String, Interceptor> interceptorMap = new HashMap<String, Interceptor>(interceptorList.size());
        for (Interceptor interceptor : interceptorList) {
            Class<?> c;
            String className = interceptor.getInterceptorClassName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Loading EJB 3.0 Interceptor class: " + className), (Object[])new Object[0]);
            }
            try {
                c = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".initializeInterceptorMD"), (String)"5352");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Load of EJB 3.0 Interceptor class failed: " + className), (Object[])new Object[]{ex});
                }
                EJBConfigurationException ecex = new EJBConfigurationException("CNTR0237E: The user-provided EJB 3.0 interceptor class \"" + className + "\" could not be found or loaded.", ex);
                Tr.error((TraceComponent)tc, (String)"INTERCEPTOR_CLASS_NOT_FOUND_CNTR0237E", (Object[])new Object[]{className});
                throw ecex;
            }
            interceptorMap.put(className, interceptor);
            LinkedList<Class<?>> lifoClasses = InterceptorMetaDataHelper.getLIFOSuperClassesList(c);
            EnumMap<InterceptorMethodKind, List<Method>> methodMap = new EnumMap<InterceptorMethodKind, List<Method>>(InterceptorMethodKind.class);
            for (InterceptorMethodKind kind : InterceptorMethodKind.values()) {
                List<? extends InterceptorCallback> methodMetaDataList = kind.getMethods((SessionInterceptor)interceptor);
                if (methodMetaDataList == null || methodMetaDataList.isEmpty()) continue;
                InterceptorMetaDataHelper.populateInterceptorMethodMap(c, lifoClasses, kind, PARM_TYPES, methodMetaDataList, methodMap, false, name);
            }
            interceptorsMap.put(c, methodMap);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"populateInterceptorsMap");
        }
        return interceptorMap;
    }

    private static void populateInterceptorMethodMap(Class<?> c, LinkedList<Class<?>> lifoClasses, InterceptorMethodKind kind, Class<?>[] parmTypes, List<? extends InterceptorCallback> methodMetaDataList, Map<InterceptorMethodKind, List<Method>> methodMap, boolean ejbClass, J2EEName name) throws EJBConfigurationException {
        String className = c.getName();
        LinkedList<Method> methodList = new LinkedList<Method>();
        for (InterceptorCallback interceptorCallback : methodMetaDataList) {
            String methodName = interceptorCallback.getMethodName();
            Method m = InterceptorMetaDataHelper.findMethod(c, methodName, parmTypes);
            if (m == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(methodName + " not found in " + className + " or in any of it's super classes"), (Object[])new Object[0]);
                }
                EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a " + kind.getXMLElementName() + " method of EJB interceptor class " + className);
                Tr.error((TraceComponent)tc, (String)"INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", (Object[])new Object[]{methodName, kind.getXMLElementName(), className});
                throw ecex;
            }
            if (kind.isLifecycle()) {
                InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters(kind, kind.getXMLElementName(), m, ejbClass, name);
            } else {
                InterceptorMetaDataHelper.validateAroundSignature(kind, m, name);
            }
            methodList.add(m);
        }
        LinkedList<Method> lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
        methodMap.put(kind, lifo);
    }

    public static EnumMap<InterceptorMethodKind, List<Method>> getEJBInterceptorMethods(Class<?> ejbClass, EnterpriseBean bean, LinkedList<Class<?>> lifoClasses, J2EEName name) throws EJBConfigurationException {
        String className = ejbClass.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEJBInterceptorMethods for EJB class: " + className), (Object[])new Object[0]);
        }
        EnumMap<InterceptorMethodKind, List<Method>> methodMap = new EnumMap<InterceptorMethodKind, List<Method>>(InterceptorMethodKind.class);
        for (InterceptorMethodKind kind : InterceptorMethodKind.values()) {
            List<? extends InterceptorCallback> methodMetaDataList = bean.getKindValue() == 0 ? kind.getMethods((SessionInterceptor)((Session)bean)) : kind.getMethods((MessageDriven)bean);
            if (methodMetaDataList == null || methodMetaDataList.isEmpty()) continue;
            InterceptorMetaDataHelper.populateInterceptorMethodMap(ejbClass, lifoClasses, kind, kind.isLifecycle() ? NO_PARMS : PARM_TYPES, methodMetaDataList, methodMap, true, name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEJBInterceptorMethods: " + methodMap));
        }
        return methodMap;
    }

    public static LinkedList<Method> getLIFOMethodList(List<Method> methodList, LinkedList<Class<?>> lifoSuperClassesList) {
        LinkedList<Method> sortedList = new LinkedList<Method>();
        for (Class clazz : lifoSuperClassesList) {
            if (methodList.isEmpty()) break;
            Iterator<Method> it = methodList.iterator();
            while (it.hasNext()) {
                Method m = it.next();
                if (m.getDeclaringClass() != clazz) continue;
                sortedList.addFirst(m);
                it.remove();
            }
        }
        return sortedList;
    }

    public static Method findMethod(Class<?> c, String methodName, Class<?>[] parmTypes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findMethod", (Object[])new Object[]{c, methodName, Arrays.toString(parmTypes)});
        }
        Class<?> classObject = c;
        Method m = null;
        while (classObject != null && m == null) {
            try {
                m = classObject.getDeclaredMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException e) {
                classObject = classObject.getSuperclass();
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                if (classObject != null) {
                    Tr.debug((TraceComponent)tc, (String)("searching superclass: " + classObject.getName()), (Object[])new Object[0]);
                    continue;
                }
                Tr.debug((TraceComponent)tc, (String)(methodName + " was not found"), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findMethod returning: " + m));
        }
        return m;
    }

    public static LinkedList<Class<?>> getLIFOSuperClassesList(Class<?> interceptorClass) {
        LinkedList supers = new LinkedList();
        supers.addFirst(interceptorClass);
        for (Class<?> interceptorSuperClass = interceptorClass.getSuperclass(); interceptorSuperClass != null && interceptorSuperClass != Object.class; interceptorSuperClass = interceptorSuperClass.getSuperclass()) {
            supers.addFirst(interceptorSuperClass);
        }
        return supers;
    }

    public static void validateAroundSignature(InterceptorMethodKind kind, Method m, J2EEName name) throws EJBConfigurationException {
        int mod = m.getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_INTERCEPTOR_METHOD_MODIFIER_CNTR0229E", (Object[])new Object[]{method});
            throw new EJBConfigurationException(kind.getXMLElementName() + " interceptor \"" + method + "\" must not be declared as final or static.");
        }
        Class<?>[] parmTypes = m.getParameterTypes();
        if (parmTypes.length != 1 || !parmTypes[0].equals(InvocationContext.class)) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_AROUND_INVOKE_SIGNATURE_CNTR0230E", (Object[])new Object[]{method, kind.getXMLElementName()});
            throw new EJBConfigurationException(kind.getXMLElementName() + " interceptor \"" + method + "\" must have a single parameter of type javax.interceptors.InvocationContext.");
        }
        Class<?> returnType = m.getReturnType();
        if (returnType != Object.class) {
            boolean compatiblyValid;
            boolean bl = compatiblyValid = kind == InterceptorMethodKind.AROUND_INVOKE && Object.class.isAssignableFrom(returnType);
            if (!compatiblyValid || CheckEJBAppConfigHelper.isValidationLoggable()) {
                String method = m.toGenericString();
                Tr.error((TraceComponent)tc, (String)"INVALID_AROUND_INVOKE_SIGNATURE_CNTR0230E", (Object[])new Object[]{method, kind.getXMLElementName()});
                if (!compatiblyValid || CheckEJBAppConfigHelper.isValidationFailable()) {
                    throw new EJBConfigurationException(kind.getXMLElementName() + " interceptor \"" + method + "\" must have a return value of type java.lang.Object.");
                }
            }
        }
    }

    public static void validateLifeCycleSignatureExceptParameters(InterceptorMethodKind kind, String lifeCycle, Method m, boolean ejbClass, J2EEName name) throws EJBConfigurationException {
        InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters(kind, lifeCycle, m, ejbClass, name, InterceptorMethodKind.isInterceptor1_2());
    }

    static void validateLifeCycleSignatureExceptParameters(InterceptorMethodKind kind, String lifeCycle, Method m, boolean ejbClass, J2EEName name, boolean isInterceptor1_2) throws EJBConfigurationException {
        if (kind == InterceptorMethodKind.AROUND_CONSTRUCT && ejbClass) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_AROUND_CONSTRUCT_DEFINITION_CNTR0249E", (Object[])new Object[]{name.getComponent(), name.getModule(), name.getApplication(), method});
            throw new EJBConfigurationException("CNTR0249E: The " + name.getComponent() + " enterprise bean in the " + name.getModule() + " module in the " + name.getApplication() + " application specifies the @AroundConstruct annotation on the " + method + " method, but this annotation can only be used by interceptor classes.");
        }
        int mod = m.getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_INTERCEPTOR_METHOD_MODIFIER_CNTR0229E", (Object[])new Object[]{method});
            throw new EJBConfigurationException(lifeCycle + " interceptor \"" + method + "\" must not be declared as final or static.");
        }
        Class<?> returnType = m.getReturnType();
        if (!(returnType == Void.TYPE || isInterceptor1_2 && returnType == Object.class)) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_LIFECYCLE_SIGNATURE_CNTR0231E", (Object[])new Object[]{method, lifeCycle});
            throw new EJBConfigurationException(lifeCycle + " interceptor \"" + method + "\" must have void as return type.");
        }
    }

    public static void validateLifeCycleSignature(InterceptorMethodKind kind, String lifeCycle, Method m, boolean ejbClass, J2EEName name) throws EJBConfigurationException {
        InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters(kind, lifeCycle, m, ejbClass, name);
        Class<?>[] parmTypes = m.getParameterTypes();
        if (ejbClass) {
            if (parmTypes.length != 0) {
                String method = m.toGenericString();
                Tr.error((TraceComponent)tc, (String)"INVALID_LIFECYCLE_SIGNATURE_CNTR0231E", (Object[])new Object[]{method, lifeCycle});
                throw new EJBConfigurationException(lifeCycle + " interceptor \"" + method + "\" must have zero parameters.");
            }
        } else if (parmTypes.length != 1 || !parmTypes[0].equals(InvocationContext.class)) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_LIFECYCLE_SIGNATURE_CNTR0232E", (Object[])new Object[]{method, lifeCycle});
            throw new EJBConfigurationException("CNTR0232E: The \"" + method + "\" method does not have the required method signature for a \"" + lifeCycle + "\" method of a interceptor class.");
        }
    }

    public static boolean isMethodOverridden(Method m, LinkedList<Class<?>> supers) {
        int startIndex;
        int methodModifier = m.getModifiers();
        if (!Modifier.isPrivate(methodModifier) && (startIndex = supers.indexOf(m.getDeclaringClass()) + 1) < supers.size()) {
            String name = m.getName();
            Class<?>[] pTypes = m.getParameterTypes();
            ListIterator<Class<?>> lit = supers.listIterator(startIndex);
            while (lit.hasNext()) {
                Class<?> subClass = lit.next();
                try {
                    subClass.getDeclaredMethod(name, pTypes);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return false;
    }
}

