/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ejbcontainer.osgi.internal.BeanInitDataImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.EJBRuntimeException;
import com.ibm.ws.ejbcontainer.osgi.internal.EJBRuntimeImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.ModuleInitDataAdapter;
import com.ibm.ws.ejbcontainer.osgi.internal.ModuleInitDataImpl;
import com.ibm.ws.ejbcontainer.runtime.ComponentNameSpaceConfigurationProviderImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.metadata.ejb.BeanInitData;
import com.ibm.ws.metadata.ejb.ModuleInitData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfigurationProvider;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleRuntimeContainer.class}, property={"type=ejb"})
public class EJBModuleRuntimeContainerImpl
implements ModuleRuntimeContainer {
    private static final TraceComponent tc = Tr.register(EJBModuleRuntimeContainerImpl.class);
    private EJBRuntimeImpl runtime;
    private InjectionEngine injectionEngine;
    private FutureMonitor futureMonitor;
    static final long serialVersionUID = -5683466374332526997L;

    @Reference
    protected void setRuntime(EJBRuntimeImpl runtime) {
        this.runtime = runtime;
    }

    protected void unsetRuntime(EJBRuntimeImpl runtime) {
        this.runtime = null;
    }

    @Reference
    protected void setInjectionEngine(InjectionEngine injectionEngine) {
        this.injectionEngine = injectionEngine;
    }

    protected void unsetInjectionEngine(InjectionEngine injectionEngine) {
        this.injectionEngine = null;
    }

    @Reference
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = null;
    }

    /*
     * WARNING - void declaration
     */
    public ModuleMetaData createModuleMetaData(ExtendedModuleInfo moduleInfo) throws MetaDataException {
        ModuleInitData mid;
        if (this.runtime == null || this.injectionEngine == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("EJBRuntime null: " + (this.runtime == null) + " InjectionEngine null: " + (this.injectionEngine == null)), (Object[])new Object[0]);
            }
            return null;
        }
        Container container2 = moduleInfo.getContainer();
        try {
            mid = (ModuleInitData)container2.adapt(ModuleInitDataImpl.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.ejbcontainer.osgi.internal.EJBModuleRuntimeContainerImpl", (String)"97", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new MetaDataException((Throwable)e);
        }
        EJBModuleMetaDataImpl ejbMMD = this.runtime.createModuleMetaData((ModuleInfo)moduleInfo, mid);
        for (BeanInitData bid : ejbMMD.ivInitData.ivBeans) {
            BeanMetaData bmd;
            try {
                bmd = this.runtime.createBeanMetaData(bid, ejbMMD);
            }
            catch (ContainerException containerException) {
                void e;
                FFDCFilter.processException((Throwable)containerException, (String)"com.ibm.ws.ejbcontainer.osgi.internal.EJBModuleRuntimeContainerImpl", (String)"107", (Object)this, (Object[])new Object[]{moduleInfo});
                throw new MetaDataException((Throwable)e);
            }
            catch (EJBConfigurationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.ejbcontainer.osgi.internal.EJBModuleRuntimeContainerImpl", (String)"109", (Object)this, (Object[])new Object[]{moduleInfo});
                throw new MetaDataException((Throwable)e);
            }
            BeanInitDataImpl bidImpl = (BeanInitDataImpl)bid;
            bidImpl.beanMetaData = bmd;
            bmd.ivReferenceContext = this.injectionEngine.createReferenceContext((MetaData)ejbMMD);
            bmd.ivReferenceContext.add((ComponentNameSpaceConfigurationProvider)new ComponentNameSpaceConfigurationProviderImpl(bmd, this.runtime));
        }
        return ejbMMD;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EJBRuntimeException.class})
    public Future<Boolean> startModule(ExtendedModuleInfo moduleInfo) throws StateChangeException {
        if (this.runtime == null || this.futureMonitor == null) {
            throw new StateChangeException("EJBRuntime available: " + (this.runtime != null) + " FutureMonitor available: " + (this.futureMonitor != null));
        }
        try {
            ModuleInitDataAdapter.removeFromCache(moduleInfo.getContainer());
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.ejbcontainer.osgi.internal.EJBModuleRuntimeContainerImpl", (String)"140", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new StateChangeException((Throwable)e);
        }
        EJBModuleMetaDataImpl mmd = (EJBModuleMetaDataImpl)moduleInfo.getMetaData();
        try {
            this.runtime.start(mmd);
        }
        catch (EJBRuntimeException e) {
            throw new StateChangeException(e.getCause());
        }
        return this.futureMonitor.createFutureWithResult((Object)true);
    }

    public void stopModule(ExtendedModuleInfo moduleInfo) {
        EJBModuleMetaDataImpl mmd = (EJBModuleMetaDataImpl)moduleInfo.getMetaData();
        if (this.runtime != null) {
            this.runtime.stop(mmd);
        }
    }
}

