/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.IllegalOperationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.HashMap;

public final class WrapperBucket
implements Bucket {
    private static final TraceComponent tc = Tr.register(WrapperBucket.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final int DEFAULT_BUCKET_SIZE = 3;
    public final Cache ivWrapperCache;
    private HashMap<Object, EJSWrapperCommon> ivWrappers;

    WrapperBucket(Cache cache) {
        this.ivWrapperCache = cache;
    }

    @Override
    public Element findByKey(Object key) {
        Element element = null;
        if (this.ivWrappers != null) {
            element = this.ivWrappers.get(key);
        }
        return element;
    }

    @Override
    public Element insertByKey(Object key, Object object) {
        EJSWrapperCommon duplicate;
        EJSWrapperCommon element = (EJSWrapperCommon)object;
        if (this.ivWrappers == null) {
            this.ivWrappers = new HashMap(3);
        }
        if ((duplicate = this.ivWrappers.put(key, element)) != null) {
            if (duplicate == element) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("insertByKey : same object again : " + object), (Object[])new Object[0]);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("insertByKey : attempt to insert duplicate : " + key + " : " + object + " : " + duplicate), (Object[])new Object[0]);
                }
                throw new IllegalArgumentException("Attempt to insert duplicate element into EJB Wrapper Cache");
            }
        }
        element.ivBucket = this;
        element.pinned = 0;
        return element;
    }

    @Override
    public Element discardByKey(Object key) {
        EJSWrapperCommon element;
        EJSWrapperCommon eJSWrapperCommon = element = this.ivWrappers != null ? this.ivWrappers.get(key) : null;
        if (element != null) {
            if (element.pinned > 0) {
                return null;
            }
            this.remove(key);
        }
        return element;
    }

    @Override
    public Element removeByKey(Object key) {
        return this.removeByKey(key, false);
    }

    @Override
    public Element removeByKey(Object key, boolean dropRef) {
        EJSWrapperCommon element;
        EJSWrapperCommon eJSWrapperCommon = element = this.ivWrappers != null ? this.ivWrappers.get(key) : null;
        if (element != null) {
            if (!dropRef && element.pinned > 0 || dropRef && element.pinned > 1) {
                throw new IllegalOperationException(key, element.pinned);
            }
            this.remove(key);
        }
        return element;
    }

    @Override
    public boolean isEmpty() {
        return this.ivWrappers == null || this.ivWrappers.isEmpty();
    }

    @Override
    public int size() {
        return this.ivWrappers != null ? this.ivWrappers.size() : 0;
    }

    @Override
    public void toArray(Element[] array) {
        if (this.ivWrappers != null) {
            this.ivWrappers.values().toArray(array);
        }
    }

    private EJSWrapperCommon remove(Object key) {
        EJSWrapperCommon removed = this.ivWrappers.remove(key);
        removed.pinned = -1;
        return removed;
    }
}

