/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.utility.IMaintenanceModeMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class UnsetMaintenanceTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(UnsetMaintenanceTask.class);
    private static final String ARG_SERVER = "--server";
    private static final String ARG_USR_DIR = "--usrDir";
    private static final String ARG_HOSTNAME = "--hostName";
    private final IMaintenanceModeMBeanConnection maintenanceMode;

    public UnsetMaintenanceTask(String scriptName, IMaintenanceModeMBeanConnection mbeanconn) {
        super(tc, scriptName, null);
        this.maintenanceMode = mbeanconn;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.promptableArgs.add("--password");
        this.reqArgs.add(ARG_HOSTNAME);
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.add(ARG_SERVER);
        this.knownArgs.add(ARG_USR_DIR);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "exitMaintenanceMode";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("exitMaintenanceMode.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("exitMaintenance.option-key.", "exitMaintenance.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("exitMaintenanceMode.desc", "exitMaintenanceMode.usage.options", "connection.option-key", "connection.option-desc", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("exitMaintenanceMode.desc", new Object[0]);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Validating command arguments...", (Object[])new Object[0]);
        }
        this.validateArgumentList(args, false, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Parsing command arguments...", (Object[])new Object[0]);
        }
        String controllerHost = this.getArgumentValue("--host", args, null);
        int port = Integer.parseInt(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String pwd = this.getArgumentValue("--password", args, null);
        String hostName = this.getArgumentValue(ARG_HOSTNAME, args, null);
        String serverName = this.getArgumentValue(ARG_SERVER, args, null);
        String usrDir = this.getArgumentValue(ARG_USR_DIR, args, null);
        this.handleAutoAcceptArgument(args);
        if (serverName != null && usrDir == null || usrDir != null && serverName == null) {
            String missingArg = usrDir == null ? ARG_USR_DIR : ARG_SERVER;
            this.abort(this.getMessage("missingArg", missingArg));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("controllerHost: " + controllerHost), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("controllerPort: " + port), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("username: " + user), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("password: " + pwd.replaceAll(".", "*")), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("targetHost: " + hostName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("server: " + serverName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("usrDir: " + usrDir), (Object[])new Object[0]);
        }
        this.unsetMaintenanceMode(controllerHost, port, user, pwd, hostName, usrDir, serverName);
    }

    private void unsetMaintenanceMode(String host, int port, String user, String pwd, String hostName, String usrDir, String serverName) throws TaskErrorException {
        String target;
        if (serverName == null) {
            target = hostName;
        } else {
            usrDir = RepositoryPathUtility.normalizePath((String)usrDir);
            target = RepositoryPathUtility.buildServerTuple((String)hostName, (String)usrDir, (String)serverName);
        }
        try {
            ArrayList<String> targets = new ArrayList<String>(1);
            targets.add(target);
            List<Map<String, String>> results = serverName == null ? this.maintenanceMode.exitHostMaintenanceMode(host, port, user, pwd, targets) : this.maintenanceMode.exitServerMaintenanceMode(host, port, user, pwd, targets);
            Map<String, String> result = results.get(0);
            if (serverName == null) {
                this.processResult(hostName, result.get(hostName));
            }
            for (Map.Entry<String, String> entry : result.entrySet()) {
                String key = entry.getKey();
                if (key.equals(hostName)) continue;
                int lastTupleComponent = Math.max(0, key.lastIndexOf(44));
                String name = key.substring(lastTupleComponent + 1);
                this.processResult(name, entry.getValue());
            }
        }
        catch (RuntimeMBeanException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            if (e.getMessage() != null && e.getMessage().contains(this.maintenanceMode.getMaintModeConnectExceptionMsg())) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("ConnectException while attempting to connect to target machine: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.abort(this.getMessage("unsetMaintenanceMode.connectionError", hostName));
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
                }
                this.abort(this.getMessage("common.portError", String.valueOf(port)));
            }
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (KeyManagementException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught KeyManagementException, this happens if the keys cannot be trusted.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("unsetMaintenanceMode.error", target));
        }
        catch (InstanceNotFoundException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught InstanceNotFoundException, this happens if the MBean has not been registered.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("unsetMaintenanceMode.error", target));
        }
        catch (NoSuchAlgorithmException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught NoSuchAlgorithmException, this should only happen if a crypto algorithm is not implemented.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("unsetMaintenanceMode.error", target));
        }
        catch (ReflectionException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught ReflectionException, this happens if the method invocation signature does not match the bean declaration.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("unsetMaintenanceMode.error", target));
        }
        catch (MBeanException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught MBeanException, this happens if a declared exception is thrown.", (Object[])new Object[0]);
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught MBeanException, an unexpected declared exception occurred.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("unsetMaintenanceMode.error", target));
        }
    }

    private void processResult(String name, String status) throws TaskErrorException {
        if (status.equals("notInMaintenanceMode")) {
            this.stdout.println(this.getMessage("unsetMaintenanceMode.success", name));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Successfully unset maintenance mode for " + name), (Object[])new Object[0]);
            }
        } else {
            this.stderr.println(this.getMessage("unsetMaintenanceMode.error", name));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encountered an error while unsetting maintenance mode for " + name), (Object[])new Object[0]);
            }
        }
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File cleanupRoot) throws TaskErrorException {
        throw new TaskErrorException(message);
    }
}

