/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.security.CollectiveDNUtil;
import com.ibm.ws.collective.utility.ICertificateUtility;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.CertificateUtility;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.security.KeyStore;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

public class CreateTask
extends BaseCommandTask {
    protected Collection<String> pwdArgs = new HashSet<String>();
    private static final TraceComponent tc = Tr.register(CreateTask.class);
    private ICertificateUtility certUtil;

    protected void setCertUtil(ICertificateUtility certUtil) {
        this.certUtil = certUtil;
    }

    private ICertificateUtility createCertificateUtility() throws TaskErrorException {
        try {
            Constructor ctor = CertificateUtility.class.getDeclaredConstructor(PrintStream.class, PrintStream.class);
            ctor.setAccessible(true);
            return (ICertificateUtility)ctor.newInstance(System.out, System.err);
        }
        catch (Throwable ex) {
            this.abort(this.getMessage("create.certUtil.NotAvailable", ex));
            return null;
        }
    }

    private ICertificateUtility certUtil() throws TaskErrorException {
        if (this.certUtil == null) {
            this.certUtil = this.createCertificateUtility();
        }
        return this.certUtil;
    }

    public CreateTask(String scriptName, IFileUtility fileUtility) {
        super(tc, scriptName, fileUtility);
        this.pwdArgs.add("--serverIdentityKeystorePassword");
        this.pwdArgs.add("--collectiveTrustKeystorePassword");
        this.pwdArgs.add("--httpsKeystorePassword");
        this.pwdArgs.add("--httpsTruststorePassword");
        this.pwdArgs.add("--rootKeystorePassword");
        this.confirmedArgs.add("--keystorePassword");
        this.confirmedArgs.add("--serverIdentityKeystorePassword");
        this.confirmedArgs.add("--collectiveTrustKeystorePassword");
        this.confirmedArgs.add("--httpsKeystorePassword");
        this.confirmedArgs.add("--httpsTruststorePassword");
        this.confirmedArgs.add("--rootKeystorePassword");
        this.flagArgs.add("--createConfigFile");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--collectiveName");
        this.knownArgs.add("--serverIdentityCertificateValidity");
        this.knownArgs.add("--httpsCertificateSubject");
        this.knownArgs.add("--httpsCertificateValidity");
        this.knownArgs.add("--hostName");
        this.knownArgs.add("--encoding");
        this.knownArgs.add("--key");
    }

    @Override
    public String getTaskName() {
        return "create";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("create.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("certProps.option-key.s", "certProps.option-desc.s") + this.buildScriptOptions("certProps.option-key.c", "certProps.option-desc.c") + this.buildScriptOptions("certProps.option-key.h", "certProps.option-desc.h") + this.buildScriptOptions("create.option-key.", "create.option-desc.") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("common.option-key.", "common.option-desc.");
        return this.getTaskHelp("create.desc", "create.usage.options", "keystore5.option-key.", "keystore5.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("create.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("create.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        this.stdout.println(this.getMessage("create.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            this.stdout.println(this.getMessage("create.cleanupFail", collectiveResourcesDir));
        }
        throw new TaskErrorException(message);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        String encodedKeystorePassword;
        boolean checkInDefaultsDir;
        File collectiveResourcesDir;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        boolean keyStorePwdUsed = false;
        if (args.length >= 3) {
            keyStorePwdUsed = this.isKeystorePwdUsed(args, this.pwdArgs);
        }
        if (this.pwdArgs.size() == 5 && !keyStorePwdUsed) {
            this.reqArgs.add("--keystorePassword");
        } else if (!this.pwdArgs.isEmpty() && !keyStorePwdUsed) {
            this.printMissingPasswordArgs(this.pwdArgs);
        }
        this.validateArgumentList(args, false);
        String serverName = this.getTaskTarget(args);
        String userDir = this.fileUtility.getUserDir();
        String serverDir = userDir + "servers" + "/" + serverName + "/";
        if (!this.fileUtility.exists(serverDir)) {
            userDir = this.fileUtility.resolvePath(userDir);
            this.abort(this.getMessage("serverNotFound", serverName, userDir));
        }
        if (this.fileUtility.exists(collectiveResourcesDir = new File(serverDir + "resources/collective")) && !this.fileUtility.isDirectoryEmpty(collectiveResourcesDir)) {
            this.abort(this.getMessage("create.errorAlreadyHasResources", new Object[0]));
        }
        if (this.isConfigFileInDropins(args, checkInDefaultsDir = true)) {
            this.abort(this.getMessage("create.configLocationInDefaults", new Object[0]));
        }
        String keystorePassword = this.getArgumentValue("--keystorePassword", args, null);
        String rootKSPassword = this.getArgumentValue("--rootKeystorePassword", args, keystorePassword);
        String serverIdentityKeystorePassword = this.getArgumentValue("--serverIdentityKeystorePassword", args, keystorePassword);
        String collectiveTrustKSPassword = this.getArgumentValue("--collectiveTrustKeystorePassword", args, keystorePassword);
        String httpsKSPassword = this.getArgumentValue("--httpsKeystorePassword", args, keystorePassword);
        String httpsTSPassword = this.getArgumentValue("--httpsTruststorePassword", args, keystorePassword);
        String hostName = this.getArgumentValue("--hostName", args, this.getHostName());
        int serverIdentityCertificateValidity = Integer.valueOf(this.getArgumentValue("--serverIdentityCertificateValidity", args, String.valueOf(1825)));
        if (serverIdentityCertificateValidity < 365) {
            this.abort(this.getMessage("create.validityTooShort", "--serverIdentityCertificateValidity"));
        }
        int rootCertValidity = 9125;
        if (serverIdentityCertificateValidity > 9125) {
            rootCertValidity = serverIdentityCertificateValidity + 9125;
        }
        String defaultHTTPSCertificateSubject = "CN=" + hostName + ",OU=" + serverName + ",O=ibm,C=us";
        String httpsCertificateSubject = this.getArgumentValue("--httpsCertificateSubject", args, defaultHTTPSCertificateSubject);
        int httpsCertificateValidity = Integer.valueOf(this.getArgumentValue("--httpsCertificateValidity", args, String.valueOf(1825)));
        if (httpsCertificateValidity < 365) {
            this.abort(this.getMessage("create.validityTooShort", "--httpsCertificateValidity"));
        }
        try {
            new LdapName(httpsCertificateSubject);
        }
        catch (InvalidNameException e) {
            this.abort(this.getMessage("common.invalidDN", "--httpsCertificateSubject", httpsCertificateSubject));
        }
        String collectiveName = this.getArgumentValue("--collectiveName", args, null);
        String encoding = this.getArgumentValue("--encoding", args, "xor");
        String key = this.getArgumentValue("--key", args, null);
        this.validateEncoding(encoding, key);
        if (keystorePassword != null && (encodedKeystorePassword = this.encodePassword(keystorePassword, "--keystorePassword", encoding, key)) == null) {
            this.abort(null);
        }
        String encodedRootKSPassword = this.encodePassword(rootKSPassword, "--rootKeystorePassword", encoding, key);
        String encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", encoding, key);
        String encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--serverIdentityKeystorePassword", encoding, key);
        String encodedHTTPSKSPassword = this.encodePassword(httpsKSPassword, "--httpsKeystorePassword", encoding, key);
        String encodedHTTPSTSPassword = this.encodePassword(httpsTSPassword, "--httpsTruststorePassword", encoding, key);
        if (encodedRootKSPassword == null || encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null || encodedHTTPSKSPassword == null || encodedHTTPSTSPassword == null) {
            this.abort(null);
        }
        File collectiveUUIDFile = new File(serverDir + "resources/collective/collective.uuid");
        File collectiveNameFile = new File(serverDir + "resources/collective/collective.name");
        File rootKeysFile = new File(serverDir + "resources/collective/rootKeys.jks");
        File serverIdentityKeyFile = new File(serverDir + "resources/collective/serverIdentity.jks");
        File collectiveTrustKeyFile = new File(serverDir + "resources/collective/collectiveTrust.jks");
        if (!this.fileUtility.createParentDirectory(stdout, collectiveUUIDFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, collectiveNameFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, rootKeysFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, serverIdentityKeyFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, collectiveTrustKeyFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        File httpsKSFile = new File(serverDir + "resources/security/key.jks");
        File tmpHttpsKSFile = new File(serverDir + "resources/security/key.jks" + ".tmp");
        if (httpsKSFile.exists()) {
            stdout.println(this.getMessage("common.regenerateKey", httpsKSFile.getAbsolutePath()));
        }
        File httpsTSFile = new File(serverDir + "resources/security/trust.jks");
        File tmpHttpsTSFile = new File(serverDir + "resources/security/trust.jks" + ".tmp");
        if (httpsTSFile.exists()) {
            stdout.println(this.getMessage("common.regenerateTrust", httpsTSFile.getAbsolutePath()));
        }
        if (!this.fileUtility.createParentDirectory(stdout, httpsKSFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsKSFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, httpsTSFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsTSFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        stdout.println(this.getMessage("create.start", new Object[0]));
        KeyStore rootKS = this.certUtil().createKeystore(rootKeysFile, rootKSPassword.toCharArray());
        KeyStore serverIdentityKS = this.certUtil().createKeystore(serverIdentityKeyFile, serverIdentityKeystorePassword.toCharArray());
        KeyStore collectiveTrustKS = this.certUtil().createKeystore(collectiveTrustKeyFile, serverIdentityKeystorePassword.toCharArray());
        KeyStore httpsKS = this.certUtil().createKeystore(tmpHttpsKSFile, httpsKSPassword.toCharArray());
        KeyStore httpsTS = this.certUtil().createKeystore(tmpHttpsTSFile, httpsTSPassword.toCharArray());
        String uuid = UUID.randomUUID().toString();
        if (!this.fileUtility.writeToFile(stderr, uuid, collectiveUUIDFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (collectiveName != null && !this.fileUtility.writeToFile(stderr, collectiveName, collectiveNameFile)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        String dn = CollectiveDNUtil.buildControllerRootCertificateDN((String)uuid);
        PkSsCertificate controllerRootKey = this.certUtil().createSelfSignedCACert(dn, rootCertValidity);
        if (controllerRootKey == null) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Generated controller root certificate: " + dn), (Object[])new Object[0]);
            }
            stdout.println(this.getMessage("create.genCertControllerRoot", new Object[0]));
        }
        dn = CollectiveDNUtil.buildMemberRootCertificateDN((String)uuid);
        PkSsCertificate memberRootKey = this.certUtil().createSelfSignedCACert(dn, rootCertValidity);
        if (memberRootKey == null) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Generated member root certificate: " + dn), (Object[])new Object[0]);
            }
            stdout.println(this.getMessage("create.genCertMemberRoot", new Object[0]));
        }
        dn = CollectiveDNUtil.buildControllerDN((String)serverName, (String)userDir, (String)hostName, (String)uuid);
        PkNewCertificate serverIdentityKey = this.certUtil().createSignedCert(dn, serverIdentityCertificateValidity, controllerRootKey);
        if (serverIdentityKey == null) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Generated server identity certificate: " + dn), (Object[])new Object[0]);
            }
            stdout.println(this.getMessage("create.genCertServerIdentity", dn));
        }
        PkNewCertificate httpsKey = this.certUtil().createSignedCert(httpsCertificateSubject, httpsCertificateValidity, controllerRootKey);
        if (httpsKey == null) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Generated HTTPS certificate: " + httpsCertificateSubject), (Object[])new Object[0]);
            }
            stdout.println(this.getMessage("create.genCertHTTPS", new Object[0]));
        }
        if (!this.certUtil().setToKeyStore(controllerRootKey, rootKS, rootKSPassword, "controllerRoot")) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().setToKeyStore(memberRootKey, rootKS, rootKSPassword, "memberRoot")) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().setToKeyStore(serverIdentityKey, serverIdentityKS, serverIdentityKeystorePassword, "serverIdentity")) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().setToKeyStore(httpsKey, httpsKS, httpsKSPassword, "default")) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().setCertToKeyStore(controllerRootKey.getCertificate(), collectiveTrustKS, "controllerRoot")) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().setCertToKeyStore(memberRootKey.getCertificate(), collectiveTrustKS, "memberRoot")) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().setCertToKeyStore(controllerRootKey.getCertificate(), httpsTS, "controllerRoot")) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().setCertToKeyStore(memberRootKey.getCertificate(), httpsTS, "memberRoot")) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().saveKeyStore(rootKS, rootKeysFile, rootKSPassword)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().saveKeyStore(serverIdentityKS, serverIdentityKeyFile, serverIdentityKeystorePassword)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().saveKeyStore(collectiveTrustKS, collectiveTrustKeyFile, serverIdentityKeystorePassword)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().saveKeyStore(httpsKS, tmpHttpsKSFile, httpsKSPassword)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        if (!this.certUtil().saveKeyStore(httpsTS, tmpHttpsTSFile, httpsTSPassword)) {
            this.abortAndPerformCleanup(null, collectiveResourcesDir);
        }
        this.updateExistingSSLKeys(httpsKSFile, tmpHttpsKSFile, httpsTSFile, tmpHttpsTSFile, collectiveResourcesDir);
        stdout.println();
        stdout.println(this.getMessage("create.successful", serverName));
        String configXML = this.getConfigXML(hostName, encoding, key, encodedRootKSPassword, encodedServerIdentityKeystorePassword, encodedCollectiveTrustKSPassword, encodedHTTPSKSPassword, encodedHTTPSTSPassword);
        this.handleConfigXML(stdout, args, serverDir, configXML);
        stdout.println(this.getMessage("create.configureSecurity", new Object[0]));
    }

    private String getConfigXML(String hostName, String encoding, String key, String encodedRootKSPassword, String encodedServerIdentityKeystorePassword, String encodedCollectiveTrustKSPassword, String encodedHTTPSKSPassword, String encodedHTTPSTSPassword) {
        String xmlSnippet = "    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + "    <!-- TODO: Set the security configuration for Administrative access -->" + NL + "    <quickStartSecurity userName=\"\" userPassword=\"\" />" + NL + NL + this.insertEncodingKey(encoding, key) + "    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\"" + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore -->" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedHTTPSKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/key.jks" + "\" />" + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" password=\"" + encodedHTTPSTSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/trust.jks" + "\" />" + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" password=\"" + encodedServerIdentityKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/serverIdentity.jks" + "\" />" + NL + NL + "    <!-- collective trust keystore -->" + NL + "    <keyStore id=\"collectiveTrust\" password=\"" + encodedCollectiveTrustKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/collectiveTrust.jks" + "\" />" + NL + NL + "    <!-- collective root signers keystore -->" + NL + "    <keyStore id=\"collectiveRootKeys\" password=\"" + encodedRootKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/rootKeys.jks" + "\" />" + NL;
        return xmlSnippet;
    }
}

