/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteConsumerReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.impl.AnycastInputControl;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.RemoteMediationPoint;
import com.ibm.ws.sib.processor.runtime.impl.XmitPoint;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;

public class RemoteQueuePoint
extends RemoteMediationPoint
implements SIMPRemoteQueuePointControllable,
XmitPoint {
    private SIBUuid8 remoteME;
    private DestinationHandler destinationHandler;
    private static TraceComponent tc = SibTr.register(RemoteQueuePoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public RemoteQueuePoint(SIBUuid8 remoteME, DestinationHandler destinationHandler, MessageProcessor messageProcessor) {
        super(remoteME, destinationHandler, messageProcessor, ControllableType.REMOTE_QUEUE_POINT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteQueuePoint", (Object)new Object[]{remoteME, destinationHandler, messageProcessor});
        }
        this.remoteME = remoteME;
        this.destinationHandler = destinationHandler;
        this.id = destinationHandler.getUuid().toString() + "_REMOTE_QUEUE_" + remoteME.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteQueuePoint", (Object)this);
        }
    }

    public SIMPRemoteConsumerReceiverControllable getRemoteConsumerReceiver() {
        AIStream aiStream;
        AnycastInputHandler aih;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteConsumerReceiver");
        }
        SIMPRemoteConsumerReceiverControllable remoteConsumerReceiverControl = null;
        RemoteConsumerDispatcher rcd = this.destinationHandler.getRemoteConsumerDispatcher(this.remoteME, null, false);
        if (rcd != null && (aih = rcd.getAnycastInputHandler()) != null && (aiStream = aih.getAIStream()) != null) {
            remoteConsumerReceiverControl = (SIMPRemoteConsumerReceiverControllable)aiStream.getControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteConsumerReceiver", remoteConsumerReceiverControl);
        }
        return remoteConsumerReceiverControl;
    }

    public SIMPIterator getRemoteConsumerReceiverIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteConsumerReceiverIterator");
        }
        Iterator<AnycastInputControl> aihIterator = this.destinationHandler.getAIControlAdapterIterator();
        ArrayList<ControlAdapter> rcrList = new ArrayList<ControlAdapter>();
        while (aihIterator.hasNext()) {
            AIStream stream = aihIterator.next().getStream();
            if (stream == null || !stream.getAnycastInputHandler().getLocalisationUuid().equals((Object)this.remoteME)) continue;
            rcrList.add(stream.getControlAdapter());
        }
        BasicSIMPIterator rcrIterator = new BasicSIMPIterator(rcrList.iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteConsumerReceiverIterator", (Object)rcrIterator);
        }
        return rcrIterator;
    }

    public long getNumberOfCompletedRequests() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfCompletedRequests");
        }
        Iterator<AnycastInputControl> aihIterator = this.destinationHandler.getAIControlAdapterIterator();
        long requests = 0L;
        while (aihIterator.hasNext()) {
            requests += aihIterator.next().getNumberOfCompletedRequests();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfCompletedRequests", (Object)requests);
        }
        return requests;
    }
}

