/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.processor.impl.AbstractAliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.AccessChecker;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DynamicConfigManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.LocalizationPoint;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractDestinationHandler
extends SIMPItemStream
implements DestinationHandler {
    private static final TraceComponent tc = SibTr.register(AbstractDestinationHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    SIMPTransactionManager txManager;
    ControlAdapter controlAdapter;
    MessageProcessor messageProcessor;
    DestinationManager destinationManager;
    private String busName = null;
    protected AccessChecker accessChecker;
    protected boolean isBusSecure = false;
    private List<DestinationHandler> aliasesThatTargetThisDest = null;
    private boolean isDeleted = false;
    ProducerInputHandler inputHandler = null;
    protected Boolean _sendAllowedOnTargetForeignBus = null;

    public AbstractDestinationHandler() {
    }

    public AbstractDestinationHandler(MessageProcessor messageProcessor, String busName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractDestinationHandler", (Object)new Object[]{messageProcessor, busName});
        }
        this.initializeNonPersistent(messageProcessor);
        this.busName = busName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractDestinationHandler", (Object)this);
        }
    }

    protected void reconstitute(MessageProcessor processor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)processor);
        }
        this.initializeNonPersistent(processor);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    protected void initializeNonPersistent(MessageProcessor processor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)processor);
        }
        this.messageProcessor = processor;
        this.txManager = this.messageProcessor.getTXManager();
        this.destinationManager = this.messageProcessor.getDestinationManager();
        this.busName = this.messageProcessor.getMessagingEngineBus();
        this.isBusSecure = this.messageProcessor.isBusSecure();
        if (this.isBusSecure) {
            this.accessChecker = this.messageProcessor.getAccessChecker();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    @Override
    public DestinationManager getDestinationManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationManager");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationManager", (Object)((Object)this.destinationManager));
        }
        return this.destinationManager;
    }

    @Override
    public MessageProcessor getMessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this.messageProcessor);
        }
        return this.messageProcessor;
    }

    public SIMPTransactionManager getTransactionManager() {
        return this.txManager;
    }

    @Override
    public SIMPTransactionManager getTxManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTxManager");
            SibTr.exit((TraceComponent)tc, (String)"getTxManager", (Object)this.txManager);
        }
        return this.txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeProducers() {
        ProducerInputHandler inputHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeProducers");
        }
        if (this.aliasesThatTargetThisDest != null) {
            List<DestinationHandler> list = this.aliasesThatTargetThisDest;
            synchronized (list) {
                for (AbstractAliasDestinationHandler abstractAliasDestinationHandler : this.aliasesThatTargetThisDest) {
                    abstractAliasDestinationHandler.closeProducers();
                }
            }
        }
        if ((inputHandler = (ProducerInputHandler)this.getInputHandler()) != null) {
            inputHandler.closeProducersDestinationDeleted();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeProducers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConsumers() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeConsumers");
        }
        if (this.aliasesThatTargetThisDest != null) {
            List<DestinationHandler> list = this.aliasesThatTargetThisDest;
            synchronized (list) {
                for (AbstractAliasDestinationHandler abstractAliasDestinationHandler : this.aliasesThatTargetThisDest) {
                    abstractAliasDestinationHandler.closeConsumers();
                }
            }
        }
        if (this.isPubSub()) {
            ConsumerDispatcher cd;
            SubscriptionTypeFilter filter = new SubscriptionTypeFilter();
            filter.LOCAL = Boolean.TRUE;
            SIMPIterator itr = this.getSubscriptionIndex().iterator(filter);
            while (itr.hasNext()) {
                ControllableSubscription controllableSubscription = (ControllableSubscription)itr.next();
                cd = (ConsumerDispatcher)controllableSubscription.getOutputHandler();
                if (!cd.getConsumerDispatcherState().getTopicSpaceUuid().equals((Object)this.getUuid())) continue;
                cd.closeAllConsumersForDelete(this);
            }
            if (this.isAlias()) {
                itr = this.getSubscriptionIndex().iterator(filter);
                while (itr.hasNext()) {
                    ControllableSubscription controllableSubscription = (ControllableSubscription)itr.next();
                    cd = (ConsumerDispatcher)controllableSubscription.getOutputHandler();
                    ConsumerDispatcherState subState = cd.getConsumerDispatcherState();
                    if (!subState.getTopicSpaceUuid().equals((Object)this.getUuid()) || !cd.isDurable()) continue;
                    try {
                        this.deleteDurableSubscription(subState.getSubscriberID(), subState.getDurableHome());
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractDestinationHandler.closeConsumers", (String)"1:347:1.57", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                }
                itr.finished();
            }
        } else {
            LocalizationPoint ptoPMessageItemStream = this.getQueuePoint(this.messageProcessor.getMessagingEngineUuid());
            if (ptoPMessageItemStream != null) {
                ConsumerDispatcher consumerManager = (ConsumerDispatcher)ptoPMessageItemStream.getConsumerManager();
                consumerManager.closeAllConsumersForDelete(this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeConsumers");
        }
    }

    @Override
    public boolean isPubSub() {
        boolean isPubSub;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPubSub");
        }
        boolean bl = isPubSub = this.getDestinationType() == DestinationType.TOPICSPACE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isPubSub", (Object)new Boolean(isPubSub));
        }
        return isPubSub;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isForeignBus() {
        return false;
    }

    @Override
    public boolean isMQLink() {
        return false;
    }

    @Override
    public InputHandler getInputHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getInputHandler", (Object)this.inputHandler);
        }
        return this.inputHandler;
    }

    public void setInputHandler(ProducerInputHandler inputHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setInputHandler", (Object)inputHandler);
        }
        this.inputHandler = inputHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setInputHandler");
        }
    }

    void setBus(String busName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBus", (Object)busName);
        }
        this.busName = busName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBus");
        }
    }

    @Override
    public String getBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBus");
            SibTr.exit((TraceComponent)tc, (String)"getBus", (Object)this.busName);
        }
        return this.busName;
    }

    @Override
    public Object getContextValue(String keyName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getContextValue", (Object)keyName);
        }
        Map context = this.getDefinition().getDestinationContext();
        Object property = context.get(keyName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getContextValue", property);
        }
        return property;
    }

    @Override
    public String getDescription() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDescription");
        }
        String desc = this.getDefinition().getDescription();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDescription", (Object)desc);
        }
        return desc;
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    @Override
    public void dereferenceControlAdapter() {
        this.controlAdapter.dereferenceControllable();
        this.controlAdapter = null;
    }

    @Override
    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String name = null;
        BaseDestinationDefinition def = this.getDefinition();
        if (def != null) {
            name = this.getDefinition().getName();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)name);
        }
        return name;
    }

    @Override
    public SIBUuid12 getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
        }
        SIBUuid12 uuid = this.getDefinition().getUUID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)uuid);
        }
        return uuid;
    }

    @Override
    public SIBUuid12 getBaseUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBaseUuid");
        }
        SIBUuid12 uuid = this.getDefinition().getUUID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBaseUuid", (Object)uuid);
        }
        return uuid;
    }

    public String toString() {
        BaseDestinationDefinition def = this.getDefinition();
        if (def != null) {
            return "Destination (" + this.hashCode() + ") " + this.getName() + " : " + this.getUuid();
        }
        return "Destination setup incomplete (" + this.hashCode() + ") Link:" + this.isLink() + " Foreign Bus: " + this.isForeignBus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTargettingAlias(DestinationHandler aliasDestinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTargettingAlias", (Object)aliasDestinationHandler);
        }
        if (this.aliasesThatTargetThisDest == null) {
            this.aliasesThatTargetThisDest = new ArrayList<DestinationHandler>();
        }
        List<DestinationHandler> list = this.aliasesThatTargetThisDest;
        synchronized (list) {
            this.aliasesThatTargetThisDest.add(aliasDestinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTargettingAlias");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargettingAlias(DestinationHandler aliasDestinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTargettingAlias", (Object)aliasDestinationHandler);
        }
        List<DestinationHandler> list = this.aliasesThatTargetThisDest;
        synchronized (list) {
            this.aliasesThatTargetThisDest.remove(aliasDestinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTargettingAlias");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTargettingAliases() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteTargettingAliases");
        }
        if (this.aliasesThatTargetThisDest != null) {
            DynamicConfigManager dcm = this.messageProcessor.getDynamicConfigManager();
            List<DestinationHandler> list = this.aliasesThatTargetThisDest;
            synchronized (list) {
                Iterator<DestinationHandler> i = this.aliasesThatTargetThisDest.iterator();
                while (i.hasNext()) {
                    AbstractAliasDestinationHandler abstractAliasDestinationHandler = (AbstractAliasDestinationHandler)i.next();
                    abstractAliasDestinationHandler.deleteTargettingAliases();
                    dcm.deleteAbstractAliasDestinationHandler(abstractAliasDestinationHandler);
                    i.remove();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteTargettingAliases");
        }
    }

    @Override
    public boolean isDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDeleted");
            SibTr.exit((TraceComponent)tc, (String)"isDeleted", (Object)new Boolean(this.isDeleted));
        }
        return this.isDeleted;
    }

    @Override
    public void setDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDeleted");
            SibTr.exit((TraceComponent)tc, (String)"setDeleted");
        }
        this.isDeleted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeignBusSendAllowed(boolean sendAllowed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setForeignBusSendAllowed", (Object)sendAllowed);
        }
        this._sendAllowedOnTargetForeignBus = sendAllowed;
        if (this.aliasesThatTargetThisDest != null) {
            List<DestinationHandler> list = this.aliasesThatTargetThisDest;
            synchronized (list) {
                for (AbstractAliasDestinationHandler abstractAliasDestinationHandler : this.aliasesThatTargetThisDest) {
                    abstractAliasDestinationHandler.setForeignBusSendAllowed(sendAllowed);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setForeignBusSendAllowed");
        }
    }

    @Override
    public void reset() throws InvalidOperationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        InvalidOperationException e = new InvalidOperationException(nls.getFormattedMessage("OPERATION_IS_INVALID_ERROR_CWSIP0121", new Object[]{this.getName(), this.getBus()}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset", (Object)((Object)e));
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTargettingAliasesReceiveAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyTargettingAliasesReceiveAllowed");
        }
        if (this.aliasesThatTargetThisDest != null) {
            List<DestinationHandler> list = this.aliasesThatTargetThisDest;
            synchronized (list) {
                for (AbstractAliasDestinationHandler abstractAliasDestinationHandler : this.aliasesThatTargetThisDest) {
                    abstractAliasDestinationHandler.notifyReceiveAllowed(abstractAliasDestinationHandler);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyTargettingAliasesReceiveAllowed");
        }
    }

    @Override
    public Boolean getSendAllowedOnTargetForeignBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSendAllowedOnTargetForeignBus");
            SibTr.exit((TraceComponent)tc, (String)"getSendAllowedOnTargetForeignBus", (Object)this._sendAllowedOnTargetForeignBus);
        }
        return this._sendAllowedOnTargetForeignBus;
    }
}

