/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.impl.AOBrowserSessionKey;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;

public final class AOBrowserSession
implements AlarmListener {
    private MPAlarmManager am;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(AOBrowserSession.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final AnycastOutputHandler parent;
    private BrowseCursor browseCursor;
    private final AOBrowserSessionKey key;
    private final SIBUuid8 remoteMEUuid;
    private final SIBUuid12 gatheringTargetDestUuid;
    private long expectedSequenceNumber;
    private Alarm expiryAlarmHandle;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AOBrowserSession(AnycastOutputHandler parent, BrowseCursor browseCursor, SIBUuid8 remoteMEUuid, SIBUuid12 gatheringTargetDestUuid, long browseId, MPAlarmManager am) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOBrowserSession", (Object)new Object[]{parent, browseCursor, remoteMEUuid, gatheringTargetDestUuid, browseId, am});
        }
        AOBrowserSession aOBrowserSession = this;
        synchronized (aOBrowserSession) {
            this.parent = parent;
            this.browseCursor = browseCursor;
            this.key = new AOBrowserSessionKey(remoteMEUuid, gatheringTargetDestUuid, browseId);
            this.remoteMEUuid = remoteMEUuid;
            this.gatheringTargetDestUuid = gatheringTargetDestUuid;
            this.am = am;
            this.expectedSequenceNumber = 0L;
            this.expiryAlarmHandle = am.create(parent.getMessageProcessor().getCustomProperties().get_browse_expiry_timeout(), this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOBrowserSession", (Object)this);
        }
    }

    public AOBrowserSessionKey getKey() {
        return this.key;
    }

    public synchronized boolean next(long seqNum) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next", (Object)new Long(seqNum));
            }
            this.expiryAlarmHandle.cancel();
            this.expiryAlarmHandle = this.am.create(this.parent.getMessageProcessor().getCustomProperties().get_browse_expiry_timeout(), this);
            if (this.closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"next", (Object)new Boolean(this.closed));
                }
                return true;
            }
            if (seqNum == this.expectedSequenceNumber) {
                try {
                    JsMessage msg = this.browseCursor.next();
                    if (msg != null) {
                        this.parent.sendBrowseData(msg, this.remoteMEUuid, this.gatheringTargetDestUuid, this.key.getRemoteMEUuid(), this.key.getBrowseId(), this.expectedSequenceNumber);
                        ++this.expectedSequenceNumber;
                        break block9;
                    }
                    this.parent.sendBrowseEnd(this.remoteMEUuid, this.gatheringTargetDestUuid, this.key.getBrowseId(), 0);
                    this.close();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOBrowserSession.next", (String)"1:182:1.30", (Object)this);
                    SIResourceException e2 = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AOBrowserSession", "1:190:1.30", e}, null), (Throwable)e);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOBrowserSession", "1:199:1.30", e});
                    this.parent.sendBrowseEnd(this.remoteMEUuid, this.gatheringTargetDestUuid, this.key.getBrowseId(), 1);
                    this.close();
                }
            } else {
                this.parent.sendBrowseEnd(this.remoteMEUuid, this.gatheringTargetDestUuid, this.key.getBrowseId(), 2);
                this.close();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", (Object)new Boolean(this.closed));
        }
        return this.closed;
    }

    public final synchronized void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        this.closed = true;
        if (this.browseCursor != null) {
            try {
                this.browseCursor.finished();
            }
            catch (SISessionDroppedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AOBrowserSession.close", (String)"1:237:1.30", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOBrowserSession.close", "1:244:1.30", SIMPUtils.getStackTrace(e)});
            }
            this.browseCursor = null;
        }
        if (this.expiryAlarmHandle != null) {
            this.expiryAlarmHandle.cancel();
            this.expiryAlarmHandle = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public final synchronized void keepAlive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"keepAlive");
        }
        if (!this.closed) {
            if (this.expiryAlarmHandle != null) {
                this.expiryAlarmHandle.cancel();
            }
            this.expiryAlarmHandle = this.am.create(this.parent.getMessageProcessor().getCustomProperties().get_browse_expiry_timeout(), this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"keepAlive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object thandle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)thandle);
        }
        AOBrowserSession aOBrowserSession = this;
        synchronized (aOBrowserSession) {
            if (this.expiryAlarmHandle != null) {
                this.expiryAlarmHandle = null;
                this.close();
                this.parent.removeBrowserSession(this.key);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public long getExpectedSequenceNumber() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExpectedSequenceNumber");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExpectedSequenceNumber", (Object)new Long(this.expectedSequenceNumber));
        }
        return this.expectedSequenceNumber;
    }
}

