/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListOptions;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils;
import com.ibm.ws.kernel.feature.internal.generator.Indenter;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DefaultConfigurationList {
    private static final String DEFAULT_INSTANCE = "defaultInstance";
    private static final String PROVIDING_FEATURES = "providingFeatures";
    private final Map<String, ProvisioningFeatureDefinition> features;
    private final FeatureListOptions options;
    private final XMLStreamWriter writer;
    private final Indenter indenter;
    private final Map<FeatureResource, Set<String>> bundleNameToFeaturesMap = new HashMap<FeatureResource, Set<String>>();
    static final long serialVersionUID = 6264511073217675465L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DefaultConfigurationList(FeatureListOptions options, Map<String, ProvisioningFeatureDefinition> features, FeatureListUtils utils) {
        this.options = options;
        this.features = features;
        this.writer = utils.getXMLStreamWriter();
        this.indenter = utils.getIndenter();
    }

    /*
     * WARNING - void declaration
     */
    public void writeDefaultConfiguration(ManifestFileProcessor mfp) {
        try {
            try {
                this.buildDefaultConfigurationList(mfp);
                this.startDefaultConfigurationSection();
                for (Map.Entry<FeatureResource, Set<String>> entry : this.bundleNameToFeaturesMap.entrySet()) {
                    FeatureResource bundle = entry.getKey();
                    BundleWrapper bw = new BundleWrapper(mfp, bundle);
                    for (DefaultElement element : bw.getDefaultElements()) {
                        this.indenter.indent(1);
                        this.writer.writeStartElement(DEFAULT_INSTANCE);
                        this.writer.writeAttribute(PROVIDING_FEATURES, this.getFeatureString(entry.getValue()));
                        if (element.requiresExisting()) {
                            this.writer.writeAttribute("requireExisting", "true");
                        }
                        if (element.addIfMissing()) {
                            this.writer.writeAttribute("addIfMissing", "true");
                        }
                        element.writeElement(2);
                        this.indenter.indent(1);
                        this.writer.writeEndElement();
                    }
                }
                this.endDefaultConfigurationSection();
            }
            catch (XMLStreamException xMLStreamException) {
                void e;
                FFDCFilter.processException((Throwable)xMLStreamException, (String)"com.ibm.ws.kernel.feature.internal.generator.DefaultConfigurationList", (String)"380", (Object)this, (Object[])new Object[]{mfp});
                throw new IOException("Error generating feature list", (Throwable)e);
            }
            catch (BundleException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.feature.internal.generator.DefaultConfigurationList", (String)"382", (Object)this, (Object[])new Object[]{mfp});
                throw new IOException("Error generating feature list", e);
            }
        }
        catch (IOException e) {
            void ex;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.feature.internal.generator.DefaultConfigurationList", (String)"385", (Object)this, (Object[])new Object[]{mfp});
            this.options.setReturnCode(FeatureListOptions.ReturnCode.RUNTIME_EXCEPTION);
            throw new RuntimeException((Throwable)ex);
        }
    }

    private String getFeatureString(Set<String> featureNames) {
        StringBuilder featureBuilder = new StringBuilder();
        if (featureNames != null) {
            Iterator<String> iter = featureNames.iterator();
            while (iter.hasNext()) {
                featureBuilder.append(iter.next());
                if (!iter.hasNext()) continue;
                featureBuilder.append(',');
            }
        }
        return featureBuilder.toString();
    }

    private void startDefaultConfigurationSection() throws XMLStreamException, IOException {
        this.indenter.indent(0);
        this.writer.writeStartElement("defaultConfiguration");
    }

    private void endDefaultConfigurationSection() throws XMLStreamException, IOException {
        this.indenter.indent(0);
        this.writer.writeEndElement();
    }

    private void buildDefaultConfigurationList(ManifestFileProcessor mfp) {
        for (Map.Entry<String, ProvisioningFeatureDefinition> entry : this.features.entrySet()) {
            ProvisioningFeatureDefinition feature = entry.getValue();
            Collection<FeatureResource> featureResources = feature.getConstituents(SubsystemContentType.BUNDLE_TYPE);
            for (FeatureResource featureResource : featureResources) {
                Set<String> featureSet = this.bundleNameToFeaturesMap.get(featureResource);
                if (featureSet == null) {
                    featureSet = new HashSet<String>();
                    this.bundleNameToFeaturesMap.put(featureResource, featureSet);
                }
                featureSet.add(feature.getSymbolicName());
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DefaultConfigurationList.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class DefaultElement {
        private final String localName;
        private final List<DefaultElement> children = new ArrayList<DefaultElement>();
        private final HashMap<String, String> attributes = new HashMap();
        private final boolean addIfMissing;
        private final boolean requireExisting;
        private String text = null;
        static final long serialVersionUID = -7241422818599045788L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DefaultElement(XMLStreamReader reader, boolean requireExisting, boolean addIfMissing) throws XMLStreamException {
            this.localName = reader.getLocalName();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                this.attributes.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
            }
            this.requireExisting = requireExisting;
            this.addIfMissing = addIfMissing;
        }

        void setText(String txt) {
            this.text = txt;
        }

        public List<DefaultElement> getChildren() {
            return this.children;
        }

        public void writeElement(int index) throws XMLStreamException, IOException {
            DefaultConfigurationList.this.indenter.indent(index);
            DefaultConfigurationList.this.writer.writeStartElement(this.localName);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                DefaultConfigurationList.this.writer.writeAttribute(entry.getKey(), entry.getValue());
            }
            for (DefaultElement e : this.children) {
                e.writeElement(index + 1);
            }
            if (this.text != null) {
                DefaultConfigurationList.this.writer.writeCharacters(this.text);
            }
            DefaultConfigurationList.this.indenter.indent(index);
            DefaultConfigurationList.this.writer.writeEndElement();
        }

        public boolean addIfMissing() {
            return this.addIfMissing;
        }

        public boolean requiresExisting() {
            return this.requireExisting;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DefaultElement.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class BundleWrapper {
        protected JarFile jar;
        private final List<BundleWrapperFile> bundleFiles = new ArrayList<BundleWrapperFile>();
        static final long serialVersionUID = -7241612430645678717L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BundleWrapper(ManifestFileProcessor mfp, FeatureResource bundle) throws IOException, BundleException, XMLStreamException, FactoryConfigurationError {
            ContentBasedLocalBundleRepository repo = mfp.getBundleRepository(bundle.getBundleRepositoryType(), null);
            File bundleFile = repo.selectBundle(bundle.getLocation(), bundle.getSymbolicName(), bundle.getVersionRange());
            if (bundleFile != null) {
                String defaultConfig;
                this.jar = new JarFile(bundleFile);
                Manifest manifest = this.jar.getManifest();
                Attributes headers = manifest.getMainAttributes();
                if (headers != null && (defaultConfig = headers.getValue("IBM-Default-Config")) != null) {
                    ManifestElement[] elements;
                    for (ManifestElement element : elements = ManifestElement.parseHeader((String)"IBM-Default-Config", (String)defaultConfig)) {
                        this.bundleFiles.add(new BundleWrapperFile(element));
                    }
                }
            }
        }

        public List<DefaultElement> getDefaultElements() {
            ArrayList<DefaultElement> elements = new ArrayList<DefaultElement>();
            for (BundleWrapperFile file : this.bundleFiles) {
                elements.addAll(file.getDefaultElements());
            }
            return elements;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BundleWrapper.class);
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        private class BundleWrapperFile {
            private static final String SERVER = "server";
            private static final String CLIENT = "client";
            private XMLStreamReader reader;
            private final List<DefaultElement> elements = new ArrayList<DefaultElement>();
            static final long serialVersionUID = -6931411248315455438L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public BundleWrapperFile(ManifestElement element) throws XMLStreamException, FactoryConfigurationError, IOException {
                String fileFilter;
                ZipEntry defaultConfigFile;
                String requireDoesNotExistStr;
                boolean existing = false;
                boolean notExisting = false;
                String requireExistingStr = element.getAttribute("requireExisting");
                if (requireExistingStr != null) {
                    existing = Boolean.valueOf(requireExistingStr);
                }
                if ((requireDoesNotExistStr = element.getAttribute("addIfMissing")) != null) {
                    notExisting = Boolean.valueOf(requireDoesNotExistStr);
                }
                if ((defaultConfigFile = BundleWrapper.this.jar.getEntry(fileFilter = element.getValue())) != null) {
                    this.reader = XMLInputFactory.newInstance().createXMLStreamReader(BundleWrapper.this.jar.getInputStream(defaultConfigFile));
                    this.parseConfig(this.elements, existing, notExisting);
                }
            }

            private void parseConfig(List<DefaultElement> elements, boolean requireExisting, boolean addIfMissing) throws XMLStreamException {
                while (this.reader.hasNext()) {
                    if (this.reader.isStartElement()) {
                        if (SERVER.equals(this.reader.getLocalName()) || CLIENT.equals(this.reader.getLocalName())) {
                            this.nextTag();
                            continue;
                        }
                        DefaultElement element = new DefaultElement(this.reader, requireExisting, addIfMissing);
                        elements.add(element);
                        this.nextTag();
                        while (this.reader.isCharacters()) {
                            element.setText(this.reader.getText());
                            this.nextTag();
                        }
                        if (this.reader.isEndElement()) {
                            this.reader.next();
                            continue;
                        }
                        if (this.reader.isStartElement()) {
                            this.parseConfig(element.getChildren(), element.requiresExisting(), element.addIfMissing());
                        }
                    } else if (this.reader.isEndElement()) {
                        return;
                    }
                    this.nextTag();
                }
            }

            private void nextTag() throws XMLStreamException {
                while (this.reader.hasNext()) {
                    this.reader.next();
                    if (!this.reader.isCharacters() && !this.reader.isStartElement() && !this.reader.isEndElement()) continue;
                    return;
                }
            }

            public List<DefaultElement> getDefaultElements() {
                return this.elements;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(BundleWrapperFile.class);
            }
        }
    }
}

