/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.Launcher;
import java.util.ResourceBundle;

public class EnvCheck {
    private static final int CLASS_MAJOR_VERSION_JAVA6 = 50;
    private static final int ERROR_BAD_JAVA_VERSION = 30;
    private static final int ERROR_BAD_JAVA_BITMODE = 31;

    public static void main(String[] args) {
        EnvCheck.main(args, null);
    }

    protected static void main(String[] args, Launcher launcher) {
        String bitmode;
        String osName;
        if (EnvCheck.getClassMajorVersion() < 50) {
            EnvCheck.badVersion();
        }
        if ((osName = System.getProperty("os.name")).equals("z/OS") && (bitmode = System.getProperty("com.ibm.vm.bitmode")).equals("32")) {
            EnvCheck.badBitMode();
        }
        try {
            if (launcher == null) {
                launcher = new Launcher();
            }
            System.exit(launcher.createPlatform(args));
            System.exit(0);
        }
        catch (UnsupportedClassVersionError versionError) {
            EnvCheck.badVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(30);
        }
    }

    private static void badVersion() {
        System.out.println(ResourceBundle.getBundle("com.ibm.ws.kernel.boot.resources.LauncherMessages").getString("error.badVersion"));
        System.exit(30);
    }

    private static void badBitMode() {
        System.out.println(ResourceBundle.getBundle("com.ibm.ws.kernel.boot.resources.LauncherMessages").getString("error.badBitmode"));
        System.exit(31);
    }

    private static int getClassMajorVersion() {
        String classVersion = System.getProperty("java.class.version");
        if (classVersion == null) {
            return 50;
        }
        int index = classVersion.indexOf(46);
        String majorVersion = index == -1 ? classVersion : classVersion.substring(0, index);
        try {
            return Integer.parseInt(majorVersion);
        }
        catch (NumberFormatException ex) {
            return 50;
        }
    }
}

