/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SecurityConfiguration {
    private static final TraceComponent tc = Tr.register(SecurityConfiguration.class);
    static final String CFG_KEY_AUTHENTICATION_REF = "authenticationRef";
    static final String CFG_KEY_AUTHORIZATION_REF = "authorizationRef";
    static final String CFG_KEY_USERREGISTRY_REF = "userRegistryRef";
    private volatile String cfgAuthenticationRef;
    private volatile String cfgAuthorizationRef;
    private volatile String cfgUserRegistryRef;
    static final long serialVersionUID = 2206672415367694188L;

    protected void activate(Map<String, Object> properties) {
        this.setAndValidateProperties((String)properties.get(CFG_KEY_AUTHENTICATION_REF), (String)properties.get(CFG_KEY_AUTHORIZATION_REF), (String)properties.get(CFG_KEY_USERREGISTRY_REF));
    }

    protected void modify(Map<String, Object> newProperties) {
        this.setAndValidateProperties((String)newProperties.get(CFG_KEY_AUTHENTICATION_REF), (String)newProperties.get(CFG_KEY_AUTHORIZATION_REF), (String)newProperties.get(CFG_KEY_USERREGISTRY_REF));
    }

    protected void deactivate() {
        this.cfgAuthenticationRef = null;
        this.cfgAuthorizationRef = null;
        this.cfgUserRegistryRef = null;
    }

    private void throwIllegalArgumentExceptionMissingAttribute(String attributeName) {
        Tr.error((TraceComponent)tc, (String)"SECURITY_CONFIG_ERROR_MISSING_ATTRIBUTE", (Object[])new Object[]{attributeName});
        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"SECURITY_CONFIG_ERROR_MISSING_ATTRIBUTE", (Object[])new Object[]{attributeName}));
    }

    private void setAndValidateProperties(String cfgAuthentication, String cfgAuthorization, String cfgUserRegistry) {
        if (cfgAuthentication == null || cfgAuthentication.isEmpty()) {
            this.throwIllegalArgumentExceptionMissingAttribute(CFG_KEY_AUTHENTICATION_REF);
        }
        this.cfgAuthenticationRef = cfgAuthentication;
        if (cfgAuthorization == null || cfgAuthorization.isEmpty()) {
            this.throwIllegalArgumentExceptionMissingAttribute(CFG_KEY_AUTHORIZATION_REF);
        }
        this.cfgAuthorizationRef = cfgAuthorization;
        if (cfgUserRegistry == null || cfgUserRegistry.isEmpty()) {
            this.throwIllegalArgumentExceptionMissingAttribute(CFG_KEY_USERREGISTRY_REF);
        }
        this.cfgUserRegistryRef = cfgUserRegistry;
    }

    String getAuthenticationServiceId() {
        return this.cfgAuthenticationRef;
    }

    String getAuthorizationServiceId() {
        return this.cfgAuthorizationRef;
    }

    String getUserRegistryServiceId() {
        return this.cfgUserRegistryRef;
    }
}

