/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.JaxRsConstants;
import com.ibm.ws.jaxrs20.cache.LibertyJaxRsResourceMethodCache;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JAXRSInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInInterceptor.class);
    private static final String RESOURCE_METHOD = "org.apache.cxf.resource.method";
    private static final String RESOURCE_OPERATION_NAME = "org.apache.cxf.resource.operation.name";
    static final long serialVersionUID = 6368422462091613981L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXRSInInterceptor() {
        super("unmarshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Fault.class, RuntimeException.class})
    public void handleMessage(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "handleMessage", new Object[]{message});
        }
        Exchange exchange = message.getExchange();
        exchange.put((Object)"org.apache.cxf.rest.message", (Object)Boolean.TRUE);
        Response response = (Response)exchange.get(Response.class);
        if (response == null) {
            try {
                this.processRequest(message, exchange);
                if (exchange.isOneWay()) {
                    ServerProviderFactory.getInstance(message).clearThreadLocalProxies();
                }
            }
            catch (Fault ex) {
                this.convertExceptionToResponseIfPossible(ex.getCause(), message);
            }
            catch (RuntimeException ex) {
                this.convertExceptionToResponseIfPossible(ex, message);
            }
        }
        if ((response = (Response)exchange.get(Response.class)) != null) {
            this.createOutMessage(message, response);
            message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "handleMessage");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={WebApplicationException.class})
    private void processRequest(Message message, Exchange exchange) {
        String mediaType;
        LibertyJaxRsResourceMethodCache.ResourceMethodCache rmCache;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "processRequest", new Object[]{message, exchange});
        }
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance(message);
        RequestPreprocessor rp = providerFactory.getRequestPreprocessor();
        if (rp != null) {
            rp.preprocess(message, (UriInfo)new UriInfoImpl(message, null));
        }
        if (!JaxRsConstants.JAXRS_CONTAINER_FILTER_DISABLED.booleanValue() && JAXRSUtils.runContainerRequestFilters(providerFactory, message, true, null)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "processRequest");
            }
            return;
        }
        String httpMethod = HttpUtils.getProtocolHeader(message, "org.apache.cxf.request.method", "POST", true);
        String rawPath = HttpUtils.getPathToMatch(message, true);
        Map protocolHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        String requestContentType = null;
        List ctHeaderValues = (List)protocolHeaders.get("Content-Type");
        if (ctHeaderValues != null && !ctHeaderValues.isEmpty()) {
            requestContentType = (String)ctHeaderValues.get(0);
            message.put((Object)"Content-Type", (Object)requestContentType);
        }
        if (requestContentType == null && (requestContentType = (String)message.get((Object)"Content-Type")) == null) {
            requestContentType = "*/*";
        }
        String acceptTypes = null;
        List acceptHeaderValues = (List)protocolHeaders.get("Accept");
        if (acceptHeaderValues != null && !acceptHeaderValues.isEmpty()) {
            acceptTypes = (String)acceptHeaderValues.get(0);
            message.put((Object)"Accept", (Object)acceptTypes);
        }
        if (acceptTypes == null && (acceptTypes = HttpUtils.getProtocolHeader(message, "Accept", null)) == null) {
            acceptTypes = "*/*";
            message.put((Object)"Accept", (Object)acceptTypes);
        }
        List<MediaType> acceptContentTypes = null;
        try {
            acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes, "q");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", (String)"163", (Object)((Object)this), (Object[])new Object[]{message, exchange});
            throw ExceptionUtils.toNotAcceptableException(null, null);
        }
        exchange.put((Object)"Accept", acceptContentTypes);
        List<ClassResourceInfo> resources = JAXRSUtils.getRootResources(message);
        LibertyJaxRsResourceMethodCache resourceMethodCache = (LibertyJaxRsResourceMethodCache)exchange.getBus().getExtension(LibertyJaxRsResourceMethodCache.class);
        MultivaluedMap<String, String> matchedValues = new MultivaluedMap<String, String>();
        OperationResourceInfo ori = null;
        boolean shouldFind = true;
        String ckey = message.get((Object)Message.BASE_PATH) + ":" + rawPath + ":" + httpMethod + ":" + requestContentType + ":" + acceptTypes;
        if (resourceMethodCache != null && (rmCache = resourceMethodCache.get(ckey)) != null) {
            ori = rmCache.getOperationResourceInfo();
            matchedValues = rmCache.getValues();
            mediaType = rmCache.getMediaType();
            if (!ori.isSubResourceLocator() && mediaType != null) {
                message.getExchange().put((Object)"Content-Type", (Object)mediaType);
            }
            this.setExchangeProperties(message, exchange, ori, matchedValues, resources.size());
            shouldFind = false;
        }
        if (shouldFind) {
            Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources = JAXRSUtils.selectResourceClass(resources, rawPath, message);
            if (matchedResources == null) {
                org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_ROOT_EXC", BUNDLE, new Object[]{message.get((Object)"org.apache.cxf.request.uri"), rawPath});
                LOG.warning(errorMsg.toString());
                Response resp = JAXRSUtils.createResponse(resources, message, errorMsg.toString(), Response.Status.NOT_FOUND.getStatusCode(), false);
                throw ExceptionUtils.toNotFoundException(null, (Response)resp);
            }
            try {
                ori = JAXRSUtils.findTargetMethod(matchedResources, message, httpMethod, matchedValues, requestContentType, acceptContentTypes, true);
                this.setExchangeProperties(message, exchange, ori, matchedValues, resources.size());
                if (resourceMethodCache != null) {
                    mediaType = (String)message.getExchange().get((Object)"Content-Type");
                    resourceMethodCache.put(ckey, ori, matchedValues, mediaType);
                }
            }
            catch (WebApplicationException ex) {
                if (JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), httpMethod)) {
                    Response response = JAXRSUtils.createResponse(resources, null, null, 200, true);
                    exchange.put(Response.class, (Object)response);
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "processRequest");
                    }
                    return;
                }
                throw ex;
            }
            if (LOG != null && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Request path is: " + rawPath);
                LOG.fine("Request HTTP method is: " + httpMethod);
                LOG.fine("Request contentType is: " + requestContentType);
                LOG.fine("Accept contentType is: " + acceptTypes);
                LOG.fine("Found operation: " + ori.getMethodToInvoke().getName());
            }
        }
        if (!JaxRsConstants.JAXRS_CONTAINER_FILTER_DISABLED.booleanValue() && !ori.isSubResourceLocator() && JAXRSUtils.runContainerRequestFilters(providerFactory, message, false, ori.getNameBindings())) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "processRequest");
            }
            return;
        }
        try {
            List<Object> params = JAXRSUtils.processParameters(ori, matchedValues, message);
            message.setContent(List.class, params);
        }
        catch (IOException params) {
            void ex;
            FFDCFilter.processException((Throwable)params, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", (String)"257", (Object)((Object)this), (Object[])new Object[]{message, exchange});
            this.convertExceptionToResponseIfPossible((Throwable)ex, message);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "processRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void convertExceptionToResponseIfPossible(Throwable ex, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "convertExceptionToResponseIfPossible", new Object[]{ex, message});
        }
        Response excResponse = JAXRSUtils.convertFaultToResponse(ex, message);
        if (excResponse == null) {
            ServerProviderFactory.getInstance(message).clearThreadLocalProxies();
            message.getExchange().put((Object)Message.PROPOGATE_EXCEPTION, (Object)ExceptionUtils.propogateException((Message)message));
            throw ex instanceof RuntimeException ? (RuntimeException)ex : ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
        message.getExchange().put(Response.class, (Object)excResponse);
        message.getExchange().put(Throwable.class, (Object)ex);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "convertExceptionToResponseIfPossible");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setExchangeProperties(Message message, Exchange exchange, OperationResourceInfo ori, MultivaluedMap<String, String> values, int numberOfResources) {
        ResourceProvider rp;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "setExchangeProperties", new Object[]{message, exchange, ori, values, numberOfResources});
        }
        ClassResourceInfo cri = ori.getClassResourceInfo();
        exchange.put(OperationResourceInfo.class, (Object)ori);
        exchange.put((Object)"root.resource.class", (Object)cri);
        message.put((Object)RESOURCE_METHOD, (Object)ori.getMethodToInvoke());
        message.put((Object)"jaxrs.template.parameters", values);
        String plainOperationName = ori.getMethodToInvoke().getName();
        if (numberOfResources > 1) {
            plainOperationName = cri.getServiceClass().getSimpleName() + "#" + plainOperationName;
        }
        exchange.put((Object)RESOURCE_OPERATION_NAME, (Object)plainOperationName);
        if (ori.isOneway() || MessageUtils.isTrue((Object)HttpUtils.getProtocolHeader(message, "OnewayRequest", null))) {
            exchange.setOneWay(true);
        }
        if ((rp = cri.getResourceProvider()) instanceof SingletonResourceProvider) {
            exchange.put((Object)"org.apache.cxf.service.object", rp.getInstance(message));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "setExchangeProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleFault(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "handleFault", new Object[]{message});
        }
        super.handleFault(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "handleFault");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Message createOutMessage(Message inMessage, Response r) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "createOutMessage", new Object[]{inMessage, r});
        }
        Endpoint e = inMessage.getExchange().getEndpoint();
        Message mout = e.getBinding().createMessage();
        mout.setContent(List.class, (Object)new MessageContentsList(new Object[]{r}));
        mout.setExchange(inMessage.getExchange());
        mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain((Exchange)inMessage.getExchange()));
        inMessage.getExchange().setOutMessage(mout);
        if (r.getStatus() >= Response.Status.BAD_REQUEST.getStatusCode()) {
            inMessage.getExchange().put((Object)"cxf.io.cacheinput", (Object)Boolean.FALSE);
        }
        Message message = mout;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            message = message;
            LOG.exiting("org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor", "createOutMessage", message);
        }
        return message;
    }
}

