/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.cxf.jaxrs.impl.LinkBuilderImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResponseBuilderImpl
extends Response.ResponseBuilder
implements Cloneable {
    private int status = 200;
    private boolean statusSet;
    private Object entity;
    private final MultivaluedMap<String, Object> metadata = new MetadataMap();
    private Annotation[] annotations;
    public static final String CONTENT_LANGUAGE_CXF = "Content-Language-Cxf";
    static final long serialVersionUID = 8951782684352805546L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ResponseBuilderImpl() {
    }

    private ResponseBuilderImpl(ResponseBuilderImpl copy) {
        this.status = copy.status;
        this.statusSet = copy.statusSet;
        this.metadata.putAll(copy.metadata);
        this.entity = copy.entity;
    }

    public Response build() {
        if (this.entity == null && !this.statusSet) {
            this.status = 204;
        }
        ResponseImpl r = new ResponseImpl(this.status);
        MetadataMap m = new MetadataMap(this.metadata, false, true);
        r.addMetadata((MultivaluedMap<String, Object>)m);
        r.setEntity(this.entity, this.annotations);
        this.reset();
        return r;
    }

    public Response.ResponseBuilder status(int s) {
        if (s < 100 || s > 599) {
            throw new IllegalArgumentException("Illegal status value : " + s);
        }
        this.status = s;
        this.statusSet = true;
        return this;
    }

    public Response.ResponseBuilder entity(Object e) {
        this.entity = e;
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        return this.setHeader("Content-Type", type);
    }

    public Response.ResponseBuilder type(String type) {
        return this.setHeader("Content-Type", type);
    }

    public Response.ResponseBuilder language(Locale locale) {
        this.setHeader(CONTENT_LANGUAGE_CXF, locale);
        return this.setHeader("Content-Language", locale);
    }

    public Response.ResponseBuilder language(String language) {
        this.setHeader(CONTENT_LANGUAGE_CXF, language);
        return this.setHeader("Content-Language", language);
    }

    public Response.ResponseBuilder location(URI loc) {
        Message currentMessage;
        if (!loc.isAbsolute() && (currentMessage = PhaseInterceptorChain.getCurrentMessage()) != null) {
            UriInfoImpl ui = new UriInfoImpl(currentMessage.getExchange().getInMessage(), null);
            loc = ui.getBaseUriBuilder().path(loc.getRawPath()).replaceQuery(loc.getRawQuery()).fragment(loc.getRawFragment()).buildFromEncoded(new Object[0]);
        }
        return this.setHeader("Location", loc);
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        return this.setHeader("Content-Location", location);
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        return this.setHeader("ETag", tag);
    }

    public Response.ResponseBuilder tag(String tag) {
        String doubleQuote = "\"";
        if (tag != null && !tag.startsWith("\"")) {
            tag = "\"" + tag + "\"";
        }
        return this.setHeader("ETag", tag);
    }

    public Response.ResponseBuilder lastModified(Date date) {
        return this.setHeader("Last-Modified", date);
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        return this.setHeader("Cache-Control", cacheControl);
    }

    public Response.ResponseBuilder expires(Date date) {
        return this.setHeader("Expires", date);
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        return this.addHeader("Set-Cookie", cookies);
    }

    public Response.ResponseBuilder header(String name, Object value) {
        return this.addHeader(name, value);
    }

    public Response.ResponseBuilder variant(Variant variant) {
        this.type(variant == null ? null : variant.getMediaType());
        this.language(variant == null ? null : variant.getLanguage());
        this.setHeader("Content-Encoding", variant == null ? null : variant.getEncoding());
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        if (variants == null) {
            this.metadata.remove((Object)"Vary");
            return this;
        }
        String acceptVary = null;
        String acceptLangVary = null;
        String acceptEncVary = null;
        for (Variant v : variants) {
            String enc;
            Locale l;
            MediaType mt = v.getMediaType();
            if (mt != null) {
                acceptVary = "Accept";
                this.addHeader("Content-Type", mt);
            }
            if ((l = v.getLanguage()) != null) {
                acceptLangVary = "Accept-Language";
                this.addHeader("Content-Language", l);
            }
            if ((enc = v.getEncoding()) == null) continue;
            acceptEncVary = "Accept-Encoding";
            this.addHeader("Content-Encoding", enc);
        }
        this.handleVaryValue(acceptVary, acceptLangVary, acceptEncVary);
        return this;
    }

    private void handleVaryValue(String ... values) {
        List varyValues = (List)this.metadata.get((Object)"Vary");
        for (String v : values) {
            if (v == null) {
                this.metadata.remove(null);
                if (varyValues == null) continue;
                varyValues.remove(null);
                continue;
            }
            this.addHeader("Vary", v);
        }
    }

    public Response.ResponseBuilder clone() {
        return new ResponseBuilderImpl(this);
    }

    private void reset() {
        this.metadata.clear();
        this.entity = null;
        this.annotations = null;
        this.status = 200;
    }

    private Response.ResponseBuilder setHeader(String name, Object value) {
        if (value == null) {
            this.metadata.remove((Object)name);
        } else {
            this.metadata.putSingle((Object)name, value);
        }
        return this;
    }

    private Response.ResponseBuilder addHeader(String name, Object ... values) {
        if (values != null && values.length >= 1 && values[0] != null) {
            boolean isAllowHeader = "Allow".equals(name);
            for (Object value : values) {
                Object thevalue;
                Object object = thevalue = isAllowHeader ? value.toString().toUpperCase() : value;
                if (this.valueExists(name, thevalue)) continue;
                this.metadata.add((Object)name, thevalue);
            }
        } else {
            this.metadata.remove((Object)name);
        }
        return this;
    }

    private boolean valueExists(String key, Object value) {
        List values = (List)this.metadata.get((Object)key);
        return values == null ? false : values.contains(value);
    }

    public Response.ResponseBuilder allow(String ... methods) {
        return this.addHeader("Allow", methods);
    }

    public Response.ResponseBuilder allow(Set<String> methods) {
        if (methods == null) {
            return this.allow(new String[0]);
        }
        return this.allow(methods.toArray(new String[methods.size()]));
    }

    public Response.ResponseBuilder encoding(String encoding) {
        return this.setHeader("Content-Encoding", encoding);
    }

    public Response.ResponseBuilder entity(Object ent, Annotation[] anns) {
        this.annotations = anns;
        this.entity = ent;
        return this;
    }

    public Response.ResponseBuilder link(URI href, String rel) {
        LinkBuilderImpl linkBuilder = new LinkBuilderImpl();
        return this.links(linkBuilder.uri(href).rel(rel).build(new Object[0]));
    }

    public Response.ResponseBuilder link(String href, String rel) {
        LinkBuilderImpl linkBuilder = new LinkBuilderImpl();
        return this.links(linkBuilder.uri(href).rel(rel).build(new Object[0]));
    }

    public Response.ResponseBuilder links(Link ... links) {
        return this.addHeader("Link", links);
    }

    public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> map) {
        this.metadata.clear();
        if (map != null) {
            this.metadata.putAll(map);
        }
        return this;
    }

    public Response.ResponseBuilder variants(Variant ... variants) {
        if (variants == null) {
            return this.variants((List<Variant>)null);
        }
        return this.variants(Arrays.asList(variants));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ResponseBuilderImpl.class);
    }
}

