/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.support.JaxRsMetaDataManager;
import com.ibm.ws.jaxrs20.utils.JaxRsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionMetaData;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxRsInjectionMetaDataListener
implements InjectionMetaDataListener {
    private static final TraceComponent tc = Tr.register(JaxRsInjectionMetaDataListener.class);
    static final long serialVersionUID = 1415505079605568152L;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void injectionMetaDataCreated(InjectionMetaData injectionMetaData) throws InjectionException {
        ModuleMetaData mmd = injectionMetaData.getModuleMetaData();
        JaxRsModuleMetaData jaxWsmoduleMetaData = JaxRsMetaDataManager.getJaxRsModuleMetaData(mmd);
        if (jaxWsmoduleMetaData == null) {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)("Unsupported Module, no JaxWsModuleMetaData is created for " + mmd.getName() + ", Injection Processing for web service is ignored"), (Object[])new Object[0]);
            return;
        }
        if (!jaxWsmoduleMetaData.getJ2EEName().equals(mmd.getJ2EEName())) {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"Not main module for the JaxWsModuleMetaData {0} or the jaxWsModuleMetaData has been initialized, Injection Processing for web service is ignored", (Object[])new Object[]{mmd.getName()});
            return;
        }
        List injectionClasses = injectionMetaData.getComponentNameSpaceConfiguration().getInjectionClasses();
        if (injectionClasses != null) {
            for (Class clazz : injectionClasses) {
                jaxWsmoduleMetaData.setReferenceContext(clazz, injectionMetaData.getReferenceContext());
            }
        }
        try {
            if (!JaxRsUtils.isEJBModule(jaxWsmoduleMetaData.getModuleContainer())) return;
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxrs20.support.JaxRsInjectionMetaDataListener", (String)"73", (Object)this, (Object[])new Object[]{injectionMetaData});
            throw new InjectionException((Throwable)e);
        }
    }
}

