/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.IORAddressingInfoHelper;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHelper;

public final class GIOPOutgoingMessage {
    private static int maxMessageSize_ = 0;
    private ORBInstance orbInstance_;
    private OutputStream out_;
    private ProfileInfo profileInfo_;

    private void writeServiceContextList(ServiceContext[] scl) {
        int len = scl.length;
        this.out_.write_ulong(len);
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ServiceContext sc = scl[i];
                this.out_.write_ulong(sc.context_id);
                int n = sc.context_data.length;
                this.out_.write_ulong(n);
                this.out_.write_octet_array(sc.context_data, 0, n);
            }
        }
    }

    private void writeTargetAddress(TargetAddress target) {
        short disc = target.discriminator();
        this.out_.write_short(disc);
        switch (disc) {
            case 0: {
                byte[] seq = target.object_key();
                int len = seq.length;
                this.out_.write_ulong(len);
                if (len <= 0) break;
                this.out_.write_octet_array(seq, 0, len);
                break;
            }
            case 1: {
                TaggedProfile profile = target.profile();
                TaggedProfileHelper.write((org.omg.CORBA.portable.OutputStream)this.out_, (TaggedProfile)profile);
                break;
            }
            case 2: {
                IORAddressingInfo info = target.ior();
                IORAddressingInfoHelper.write((org.omg.CORBA.portable.OutputStream)this.out_, (IORAddressingInfo)info);
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
    }

    GIOPOutgoingMessage(ORBInstance orbInstance, OutputStream out, ProfileInfo profileInfo) {
        this.orbInstance_ = orbInstance;
        this.out_ = out;
        this.profileInfo_ = profileInfo;
    }

    ProfileInfo profileInfo() {
        return this.profileInfo_;
    }

    void writeMessageHeader(MsgType_1_1 type, boolean fragment, int size) {
        Assert._OB_assert(type.value() >= 0 && type.value() <= 7);
        Assert._OB_assert(this.profileInfo_.major != 1 || this.profileInfo_.minor != 0 || type.value() <= 6 && !fragment);
        if (maxMessageSize_ > 0 && size > maxMessageSize_) {
            String msg = "outgoing message size (" + size + ") exceeds maximum (" + maxMessageSize_ + ")";
            this.orbInstance_.getLogger().warning(msg);
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        byte flags = 0;
        if (fragment) {
            flags = (byte)(flags | 2);
        }
        byte[] giop = new byte[]{71, 73, 79, 80};
        this.out_.write_octet_array(giop, 0, 4);
        this.out_.write_octet(this.profileInfo_.major);
        this.out_.write_octet(this.profileInfo_.minor);
        this.out_.write_octet(flags);
        this.out_.write_octet((byte)type.value());
        this.out_.write_ulong(size);
    }

    void writeRequestHeader(int id, String op, boolean response, ServiceContext[] scl) {
        switch (this.profileInfo_.minor) {
            case 0: 
            case 1: {
                this.writeServiceContextList(scl);
                this.out_.write_ulong(id);
                this.out_.write_boolean(response);
                byte[] reserved = new byte[]{0, 0, 0};
                this.out_.write_octet_array(reserved, 0, 3);
                int keyLen = this.profileInfo_.key.length;
                this.out_.write_ulong(keyLen);
                this.out_.write_octet_array(this.profileInfo_.key, 0, keyLen);
                int opLen = op.length();
                this.out_.write_ulong(opLen + 1);
                this.out_.write_octet_array(op.getBytes(), 0, opLen);
                this.out_.write_octet((byte)0);
                this.out_.write_ulong(0);
                break;
            }
            case 2: {
                this.out_.write_ulong(id);
                byte responseFlags = 0;
                if (response) {
                    responseFlags = (byte)(responseFlags | 3);
                }
                this.out_.write_octet(responseFlags);
                byte[] reserved = new byte[]{0, 0, 0};
                this.out_.write_octet_array(reserved, 0, 3);
                this.out_.write_short((short)0);
                int keyLen = this.profileInfo_.key.length;
                this.out_.write_ulong(keyLen);
                this.out_.write_octet_array(this.profileInfo_.key, 0, keyLen);
                int opLen = op.length();
                this.out_.write_ulong(opLen + 1);
                this.out_.write_octet_array(op.getBytes(), 0, opLen);
                this.out_.write_octet((byte)0);
                this.writeServiceContextList(scl);
                this.out_._OB_alignNext(8);
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
    }

    void writeReplyHeader(int id, ReplyStatusType_1_2 status, ServiceContext[] scl) {
        switch (this.profileInfo_.minor) {
            case 0: 
            case 1: {
                Assert._OB_assert(status.value() <= 3);
                this.writeServiceContextList(scl);
                this.out_.write_ulong(id);
                this.out_.write_ulong(status.value());
                break;
            }
            case 2: {
                this.out_.write_ulong(id);
                this.out_.write_ulong(status.value());
                this.writeServiceContextList(scl);
                this.out_._OB_alignNext(8);
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
    }

    void writeCancelRequestHeader(int id) {
        this.out_.write_ulong(id);
    }

    void writeLocateRequestHeader(int id) {
        switch (this.profileInfo_.minor) {
            case 0: 
            case 1: {
                this.out_.write_ulong(id);
                int keyLen = this.profileInfo_.key.length;
                this.out_.write_ulong(keyLen);
                this.out_.write_octet_array(this.profileInfo_.key, 0, keyLen);
                break;
            }
            case 2: {
                this.out_.write_ulong(id);
                this.out_.write_short((short)0);
                int keyLen = this.profileInfo_.key.length;
                this.out_.write_ulong(keyLen);
                this.out_.write_octet_array(this.profileInfo_.key, 0, keyLen);
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
    }

    void writeLocateReplyHeader(int id, LocateStatusType_1_2 status) {
        switch (this.profileInfo_.minor) {
            case 0: 
            case 1: {
                Assert._OB_assert(status.value() <= 2);
                this.out_.write_ulong(id);
                this.out_.write_ulong(status.value());
                break;
            }
            case 2: {
                this.out_.write_ulong(id);
                this.out_.write_ulong(status.value());
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
    }

    void writeFragmentHeader(int id) {
        Assert._OB_assert(this.profileInfo_.major != 1 || this.profileInfo_.minor > 1);
        this.out_.write_ulong(id);
    }

    public static void setMaxMessageSize(int max) {
        maxMessageSize_ = max;
    }
}

