/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.URLRegistry;
import org.apache.yoko.orb.OB.URLScheme;
import org.apache.yoko.orb.OB.URLUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;

public class FileURLScheme_impl
extends LocalObject
implements URLScheme {
    private boolean relative_;
    private URLRegistry registry_;

    public FileURLScheme_impl(boolean relative, URLRegistry registry) {
        this.relative_ = relative;
        this.registry_ = registry;
    }

    @Override
    public String name() {
        return this.relative_ ? "relfile" : "file";
    }

    @Override
    public Object parse_url(String url) {
        int startIdx = this.relative_ ? 8 : 5;
        int len = url.length();
        for (int n = 0; startIdx < len && n < 3 && url.charAt(startIdx) == '/'; ++n, ++startIdx) {
        }
        if (startIdx >= len) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": no file name specified", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        String fileName = this.relative_ ? "" : "/";
        fileName = fileName + URLUtil.unescapeURL(url.substring(startIdx));
        try {
            FileInputStream file = new FileInputStream(fileName);
            BufferedReader in = new BufferedReader(new InputStreamReader(file));
            String ref = in.readLine();
            file.close();
            return this.registry_.parse_url(ref);
        }
        catch (IOException ex) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": file error", 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public void destroy() {
        this.registry_ = null;
    }
}

